/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.stream;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import com.github.luben.zstd.util.Native;
import io.usethesource.vallang.io.binary.util.ByteBufferInputStream;
import io.usethesource.vallang.io.binary.util.DirectZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class Compressor {
    Compressor() {
    }

    public static boolean zstdAvailable() {
        try {
            Native.load();
            return Native.isLoaded();
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public static OutputStream wrapStream(OutputStream rawStream, int algorithm, int level) throws IOException {
        switch (algorithm) {
            case 1: {
                var result = new GZIPOutputStream(rawStream){

                    public void setLevel(int level) {
                        this.def.setLevel(level);
                    }
                };
                result.setLevel(level);
                return result;
            }
            case 2: {
                throw new UnsupportedOperationException("XZ compression is not supported anymore, please use an older version of rascal/vallang to open the file and store it with a different level of compression");
            }
            case 3: {
                return new ZstdOutputStream(rawStream, level);
            }
        }
        return rawStream;
    }

    public static InputStream wrapStream(InputStream raw, int algorithm) throws IOException {
        switch (algorithm) {
            case 0: {
                return raw;
            }
            case 1: {
                return new GZIPInputStream(raw);
            }
            case 2: {
                throw new UnsupportedOperationException("XZ compression is not supported anymore, please use an older version of rascal/vallang to open the file and store it with a different level of compression");
            }
            case 3: {
                if (Compressor.zstdAvailable()) {
                    if (raw instanceof ByteBufferInputStream && ((ByteBufferInputStream)raw).getByteBuffer().isDirect()) {
                        return new DirectZstdInputStream((ByteBufferInputStream)raw);
                    }
                    return new ZstdInputStream(raw);
                }
                throw new IOException("There is no native zstd library available for the current architecture.");
            }
        }
        throw new IOException("Unsupported compression format");
    }
}

