/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Comprehension
extends AbstractAST {
    public Comprehension(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasGenerators() {
        return false;
    }

    public java.util.List<Expression> getGenerators() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasResults() {
        return false;
    }

    public java.util.List<Expression> getResults() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasFrom() {
        return false;
    }

    public Expression getFrom() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTo() {
        return false;
    }

    public Expression getTo() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isList() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isSet() {
        return false;
    }

    public static class Set
    extends Comprehension {
        private final java.util.List<Expression> results;
        private final java.util.List<Expression> generators;

        public Set(ISourceLocation src, IConstructor node, java.util.List<Expression> results, java.util.List<Expression> generators) {
            super(src, node);
            this.results = results;
            this.generators = generators;
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitComprehensionSet(this);
        }

        @Override
        protected void addForLineNumber(int $line, java.util.List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.results) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            for (AbstractAST abstractAST : this.generators) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Set)) {
                return false;
            }
            Set tmp = (Set)o;
            return tmp.results.equals(this.results) && tmp.generators.equals(this.generators);
        }

        @Override
        public int hashCode() {
            return 821 + 971 * this.results.hashCode() + 173 * this.generators.hashCode();
        }

        @Override
        public java.util.List<Expression> getResults() {
            return this.results;
        }

        @Override
        public boolean hasResults() {
            return true;
        }

        @Override
        public java.util.List<Expression> getGenerators() {
            return this.generators;
        }

        @Override
        public boolean hasGenerators() {
            return true;
        }

        @Override
        public Object clone() {
            return Set.newInstance(this.getClass(), this.src, null, this.clone(this.results), this.clone(this.generators));
        }
    }

    public static class Map
    extends Comprehension {
        private final Expression from;
        private final Expression to;
        private final java.util.List<Expression> generators;

        public Map(ISourceLocation src, IConstructor node, Expression from, Expression to, java.util.List<Expression> generators) {
            super(src, node);
            this.from = from;
            this.to = to;
            this.generators = generators;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitComprehensionMap(this);
        }

        @Override
        protected void addForLineNumber(int $line, java.util.List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.from.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.from.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.to.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.to.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.generators) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map tmp = (Map)o;
            return tmp.from.equals(this.from) && tmp.to.equals(this.to) && tmp.generators.equals(this.generators);
        }

        @Override
        public int hashCode() {
            return 71 + 523 * this.from.hashCode() + 937 * this.to.hashCode() + 617 * this.generators.hashCode();
        }

        @Override
        public Expression getFrom() {
            return this.from;
        }

        @Override
        public boolean hasFrom() {
            return true;
        }

        @Override
        public Expression getTo() {
            return this.to;
        }

        @Override
        public boolean hasTo() {
            return true;
        }

        @Override
        public java.util.List<Expression> getGenerators() {
            return this.generators;
        }

        @Override
        public boolean hasGenerators() {
            return true;
        }

        @Override
        public Object clone() {
            return Map.newInstance(this.getClass(), this.src, null, this.clone(this.from), this.clone(this.to), this.clone(this.generators));
        }
    }

    public static class List
    extends Comprehension {
        private final java.util.List<Expression> results;
        private final java.util.List<Expression> generators;

        public List(ISourceLocation src, IConstructor node, java.util.List<Expression> results, java.util.List<Expression> generators) {
            super(src, node);
            this.results = results;
            this.generators = generators;
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitComprehensionList(this);
        }

        @Override
        protected void addForLineNumber(int $line, java.util.List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.results) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            for (AbstractAST abstractAST : this.generators) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List tmp = (List)o;
            return tmp.results.equals(this.results) && tmp.generators.equals(this.generators);
        }

        @Override
        public int hashCode() {
            return 881 + 349 * this.results.hashCode() + 449 * this.generators.hashCode();
        }

        @Override
        public java.util.List<Expression> getResults() {
            return this.results;
        }

        @Override
        public boolean hasResults() {
            return true;
        }

        @Override
        public java.util.List<Expression> getGenerators() {
            return this.generators;
        }

        @Override
        public boolean hasGenerators() {
            return true;
        }

        @Override
        public Object clone() {
            return List.newInstance(this.getClass(), this.src, null, this.clone(this.results), this.clone(this.generators));
        }
    }
}

