/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.control_exceptions;

import io.usethesource.vallang.ISourceLocation;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.interpreter.control_exceptions.ControlException;

public class InterruptException
extends ControlException {
    private static final long serialVersionUID = -6244185056015873062L;
    private final StackTrace stackTrace;
    private final ISourceLocation loc;
    private final String message;

    public InterruptException(StackTrace stackTrace, ISourceLocation loc) {
        this.stackTrace = stackTrace;
        this.loc = loc;
        this.message = null;
    }

    public InterruptException(String message, ISourceLocation loc) {
        this.stackTrace = null;
        this.loc = loc;
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public StackTrace getRascalStackTrace() {
        return this.stackTrace;
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    @Override
    public String toString() {
        Object str = "interrupted";
        if (this.message != null) {
            str = (String)str + ": " + this.message;
        }
        if (this.stackTrace != null) {
            str = (String)str + ":\n" + this.stackTrace.toString();
        }
        return str;
    }
}

