/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.unicode.UnicodeInputStreamReader;

public class InputConverter {
    private static final int STREAM_READ_SEGMENT_SIZE = 8192;

    private InputConverter() {
    }

    public static char[] toChar(String s2) {
        return s2.toCharArray();
    }

    public static char[] toChar(InputStream inputStream, Charset charset) throws IOException {
        return InputConverter.toChar(new UnicodeInputStreamReader(inputStream, charset));
    }

    public static char[] toChar(Reader reader) throws IOException {
        ArrayList<char[]> segments = new ArrayList<char[]>();
        ArrayList<Integer> segmentLengths = new ArrayList<Integer>();
        int charsRead = 0;
        int totalNrOfChars = 0;
        do {
            char[] segment;
            if ((charsRead = reader.read(segment = new char[8192], 0, 8192)) <= 0) continue;
            segments.add(segment);
            segmentLengths.add(charsRead);
            totalNrOfChars += charsRead;
        } while (charsRead != -1);
        assert (reader.read() == -1);
        char[] input = new char[totalNrOfChars];
        int pos = 0;
        for (int i = 0; i < segments.size(); ++i) {
            char[] segment = (char[])segments.get(i);
            int length = (Integer)segmentLengths.get(i);
            System.arraycopy(segment, 0, input, pos, length);
            pos += length;
        }
        assert (pos == totalNrOfChars);
        return input;
    }
}

