/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.CharNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class CharStackNode<P>
extends AbstractMatchableStackNode<P> {
    private final int[][] ranges;
    private final AbstractNode result;

    public CharStackNode(int id, int dot, int[][] ranges) {
        super(id, dot);
        this.ranges = ranges;
        this.result = null;
    }

    public CharStackNode(int id, int dot, int[][] ranges, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.ranges = ranges;
        this.result = null;
    }

    private CharStackNode(CharStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.ranges = original.ranges;
        this.result = null;
    }

    private CharStackNode(CharStackNode<P> original, int startLocation, AbstractNode result) {
        super(original, startLocation);
        this.ranges = original.ranges;
        this.result = result;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return false;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        int next = input[location];
        for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            if (next < range[0] || next > range[1]) continue;
            return CharNode.createCharNode(next);
        }
        return null;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new CharStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new CharStackNode<P>(this, startLocation, result);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int[] range = this.ranges[i];
            sb.append(this.codePointToString(range[0]));
            if (range[0] == range[1]) continue;
            sb.append('-');
            sb.append(this.codePointToString(range[1]));
        }
        return sb.toString();
    }

    private String codePointToString(int codePoint) {
        if (Character.isLetterOrDigit(codePoint)) {
            return new String(Character.toChars(codePoint));
        }
        return String.valueOf(codePoint);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CharStackNode[class=");
        int[] range = this.ranges[0];
        sb.append(range[0]);
        sb.append('-');
        sb.append(range[1]);
        for (int i = 1; i < this.ranges.length; ++i) {
            sb.append(',');
            range = this.ranges[i];
            sb.append(range[0]);
            sb.append('-');
            sb.append(range[1]);
        }
        sb.append(",");
        sb.append(super.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            hash = hash << 3 + hash >> 5;
            hash ^= range[0] + (range[1] << 2);
        }
        return hash;
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof CharStackNode)) {
            return false;
        }
        CharStackNode otherNode = (CharStackNode)stackNode;
        int[][] otherRanges = otherNode.ranges;
        if (this.ranges.length != otherRanges.length) {
            return false;
        }
        block0: for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            for (int j = otherRanges.length - 1; j >= 0; --j) {
                int[] otherRange = otherRanges[j];
                if (range[0] == otherRange[0] && range[1] == otherRange[1]) continue block0;
            }
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

