/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rascalmpl.uri.zip.CompressedFSTree;
import org.rascalmpl.uri.zip.EntryEnumerator;
import org.rascalmpl.uri.zip.IndexedFSEntry;

public class ZipInputStreamFileTree
extends CompressedFSTree {
    public ZipInputStreamFileTree(InputStream in, long created, long lastModified, long size) {
        super(new IndexedFSEntry(created, lastModified, size), ZipInputStreamFileTree.openStream(in));
    }

    private static EntryEnumerator openStream(InputStream zipStream) {
        return () -> {
            final ZipInputStream stream = new ZipInputStream(zipStream);
            return new EntryEnumerator.CloseableIterator(){
                ZipEntry next = null;

                @Override
                public void close() throws IOException {
                    stream.close();
                }

                @Override
                public boolean hasNext() throws IOException {
                    if (this.next == null) {
                        this.next = stream.getNextEntry();
                    }
                    return this.next != null;
                }

                @Override
                public ZipEntry next() throws IOException {
                    if (!this.hasNext()) {
                        throw new EOFException("No more entries in the stream");
                    }
                    ZipEntry result = this.next;
                    this.next = null;
                    return result;
                }
            };
        };
    }
}

