/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConcurrentSoftReferenceObjectPool<T> {
    private final Deque<TimestampedSoftReference<T>> availableObjects = new ConcurrentLinkedDeque<TimestampedSoftReference<T>>();
    private final ReferenceQueue<T> cleanedReferences = new ReferenceQueue();
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final AtomicInteger live = new AtomicInteger(0);
    private final Semaphore returnSignal = new Semaphore(0, true);
    private final long timeout;
    private final Supplier<T> initializeObject;
    private final int keepAlive;
    private final int maxAlive;

    public ConcurrentSoftReferenceObjectPool(long timeout, TimeUnit timeoutUnit, int keepAlive, int maxAlive, Supplier<T> initializeObject) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout should be > 0");
        }
        if (keepAlive < 0) {
            throw new IllegalArgumentException("keepAlive argument should be 0 or higher");
        }
        if (maxAlive < keepAlive) {
            throw new IllegalArgumentException("maxAlive should be not be lower than keepAlive");
        }
        this.maxAlive = maxAlive;
        this.keepAlive = keepAlive;
        this.timeout = timeoutUnit.toNanos(timeout);
        this.initializeObject = Objects.requireNonNull(initializeObject);
        Thread cleanup = new Thread(new CleanupRunner(this));
        cleanup.setName("Cleanup thread for: " + this);
        cleanup.setDaemon(true);
        cleanup.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R useAndReturn(Function<T, R> func) {
        TimestampedSoftReference<T> obj = null;
        Object worker = null;
        while (true) {
            if (obj != null) {
                Object s2 = obj.get();
                worker = s2;
                if (s2 != null) break;
            }
            obj = this.checkoutObject();
        }
        try {
            R r = func.apply(worker);
            return r;
        }
        finally {
            this.returnObject(obj);
        }
    }

    public void prepare(int howMany) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(Math.min(4, howMany), Math.min(4, howMany), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        pool.allowCoreThreadTimeOut(true);
        for (int i = 0; i < Math.min(this.maxAlive, howMany); ++i) {
            pool.execute(() -> {
                TimestampedSoftReference<T> newEntry = new TimestampedSoftReference<T>(this.initializeObject.get(), this.cleanedReferences);
                this.live.incrementAndGet();
                this.returnObject(newEntry);
            });
        }
    }

    public boolean healthCheck() {
        for (int i = 0; i < 10; ++i) {
            if (this.queueSize.get() != this.availableObjects.size()) continue;
            return true;
        }
        return false;
    }

    private void returnObject(TimestampedSoftReference<T> obj) {
        if (this.queueSize.get() < this.maxAlive) {
            this.availableObjects.addFirst(obj);
            this.queueSize.incrementAndGet();
            this.returnSignal.release();
        } else {
            this.live.decrementAndGet();
        }
    }

    private TimestampedSoftReference<T> checkoutObject() {
        TimestampedSoftReference<T> result;
        while ((result = this.availableObjects.pollFirst()) != null) {
            this.queueSize.decrementAndGet();
            if (result.get() == null) continue;
            return result;
        }
        if (this.live.get() < this.maxAlive) {
            this.live.incrementAndGet();
            return new TimestampedSoftReference<T>(this.initializeObject.get(), this.cleanedReferences);
        }
        try {
            this.returnSignal.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.checkoutObject();
    }

    private static final class TimestampedSoftReference<S>
    extends SoftReference<S> {
        private volatile long accessTimestamp = System.nanoTime();

        public TimestampedSoftReference(S referent, ReferenceQueue<? super S> q) {
            super(referent, q);
        }

        @Override
        public S get() {
            Object result = super.get();
            if (result != null) {
                this.touch();
            }
            return (S)result;
        }

        public void touch() {
            this.accessTimestamp = System.nanoTime();
        }
    }

    private static final class CleanupRunner<T>
    implements Runnable {
        private final Semaphore returnSignal;
        private final long timeout;
        private final WeakReference<ConcurrentSoftReferenceObjectPool<T>> targetPool;

        public CleanupRunner(ConcurrentSoftReferenceObjectPool<T> targetPool) {
            this.returnSignal = targetPool.returnSignal;
            this.timeout = targetPool.timeout;
            this.targetPool = new WeakReference<ConcurrentSoftReferenceObjectPool<ConcurrentSoftReferenceObjectPool<T>>>(targetPool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block5: while (true) {
                    this.returnSignal.tryAcquire(100, this.timeout, TimeUnit.NANOSECONDS);
                    ConcurrentSoftReferenceObjectPool target = (ConcurrentSoftReferenceObjectPool)this.targetPool.get();
                    if (target == null) {
                        return;
                    }
                    ReferenceQueue referenceQueue = target.cleanedReferences;
                    synchronized (referenceQueue) {
                        TimestampedSoftReference cleared;
                        while ((cleared = (TimestampedSoftReference)target.cleanedReferences.poll()) != null) {
                            if (!target.availableObjects.removeLastOccurrence(cleared)) continue;
                            target.queueSize.decrementAndGet();
                            target.live.decrementAndGet();
                        }
                    }
                    long outdatedTimeStamp = System.nanoTime() - this.timeout;
                    while (true) {
                        if (target.queueSize.get() <= target.keepAlive) continue block5;
                        TimestampedSoftReference last = target.availableObjects.pollLast();
                        if (last == null || last.accessTimestamp > outdatedTimeStamp) {
                            if (last == null) continue block5;
                            target.availableObjects.addLast(last);
                            continue block5;
                        }
                        last.clear();
                        target.queueSize.decrementAndGet();
                        target.live.decrementAndGet();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

