/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.maven.settings.Server;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.util.maven.BaseRepositoryDownloader;
import org.rascalmpl.util.maven.ChecksumInputStream;
import org.rascalmpl.util.maven.Repo;

class HttpRepositoryDownloader
extends BaseRepositoryDownloader {
    private final HttpClient client;
    private final Random rand;
    private final String authHeader;

    public HttpRepositoryDownloader(Repo repo, @Nullable Server server, HttpClient client) {
        super(repo);
        this.client = client;
        if (server != null && server.getPassword() != null && !server.getPassword().isEmpty()) {
            String auth = server.getUsername() + ":" + server.getPassword();
            this.authHeader = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        } else {
            this.authHeader = "";
        }
        this.rand = new Random();
    }

    @Override
    public boolean download(String url, Path target, boolean force) {
        try {
            this.ensureTargetDirectoryExists(target);
        }
        catch (IOException e) {
            return false;
        }
        Path result = this.download(url, target, force, true, input -> {
            Path tempTarget = this.getTempFile(target);
            Files.copy(input, tempTarget, new CopyOption[0]);
            return tempTarget;
        }, tempArtifact -> this.moveToTarget((Path)tempArtifact, target, force));
        return result != null;
    }

    private Path getTempFile(Path target) {
        String tempFileName = target.getFileName().toString() + String.valueOf(this.rand.nextInt(Integer.MAX_VALUE)) + ".tmp";
        return target.resolveSibling(tempFileName);
    }

    @Override
    public @Nullable String downloadAndRead(String url, Path target, boolean force) {
        return this.download(url, target, force, true, input -> new String(input.readAllBytes(), StandardCharsets.UTF_8), content -> this.writeToTarget((String)content, target, force));
    }

    private HttpRequest.Builder request(URI uri) {
        HttpRequest.Builder result = HttpRequest.newBuilder(uri);
        if (!this.authHeader.isEmpty()) {
            return result.header("Authorization", this.authHeader);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> @Nullable R download(String url, Path target, boolean force, boolean hasChecksums, FailableFunction<InputStream, R, IOException> resultCreator, FailableFunction<R, Boolean, IOException> resultWriter) {
        try {
            URI artifactUri = this.createUri(this.getRepo().getUrl(), url);
            HttpRequest req = this.request(artifactUri).GET().build();
            HttpResponse<InputStream> response = this.client.send(req, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                InputStream body = response.body();
                if (body == null) return null;
                body.close();
                return null;
            }
            if (hasChecksums) {
                try (ChecksumInputStream input = new ChecksumInputStream(response.body());){
                    R result = resultCreator.apply(input);
                    String sha1Checksum = input.getSha1Checksum();
                    String md5Checksum = input.getMd5Checksum();
                    if (!this.verifyChecksum(url, response.headers(), sha1Checksum, md5Checksum)) {
                        R r = null;
                        return r;
                    }
                    if (resultWriter.apply(result).booleanValue()) {
                        this.writeChecksumToTarget(target.resolveSibling(target.getFileName() + ".sha1"), sha1Checksum);
                        this.writeChecksumToTarget(target.resolveSibling(target.getFileName() + ".md5"), md5Checksum);
                    }
                    R r = result;
                    return r;
                }
            }
            try (InputStream input = response.body();){
                R result = resultCreator.apply(input);
                resultWriter.apply(result);
                R r = result;
                return r;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    private boolean verifyChecksum(String url, HttpHeaders headers, String actualSha1, String actualMd5) throws IOException, InterruptedException, URISyntaxException {
        String expectedSha1 = this.getChecksum(headers, Arrays.asList("x-checksum-sha1", "x-goog-meta-checksum-sha1"), url + ".sha1");
        if (expectedSha1 != null) {
            return expectedSha1.equals(actualSha1);
        }
        String expectedMd5 = this.getChecksum(headers, Arrays.asList("x-checksum-md5", "x-goog-meta-checksum-md5"), url + ".md5");
        if (expectedMd5 != null) {
            return expectedMd5.equals(actualMd5);
        }
        return true;
    }

    private @Nullable String getChecksum(HttpHeaders headers, List<String> checksumHeaders, String checksumUrl) throws IOException, InterruptedException, URISyntaxException {
        for (String headerName : checksumHeaders) {
            Optional<String> value = headers.firstValue(headerName);
            if (!value.isPresent()) continue;
            return value.get();
        }
        return this.downloadChecksum(this.createUri(this.getRepo().getUrl(), checksumUrl));
    }

    private @Nullable String downloadChecksum(URI uri) throws IOException, InterruptedException {
        HttpRequest req = this.request(uri).GET().build();
        HttpResponse<String> result = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        return result.statusCode() == 200 ? result.body() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveToTarget(Path from, Path to, boolean force) throws IOException {
        try {
            if (force) {
                Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(from, to, new CopyOption[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Files.deleteIfExists(from);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean writeToTarget(String content, Path target, boolean force) throws IOException {
        Path tempTarget = this.getTempFile(target);
        try {
            Files.writeString(tempTarget, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        return this.moveToTarget(tempTarget, target, force);
    }

    private void writeChecksumToTarget(Path path, @Nullable String checksum) throws IOException {
        if (checksum == null) {
            Files.delete(path);
        } else {
            Files.writeString(path, (CharSequence)checksum, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
    }
}

