/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.impl.primitive.AbstractNumberValue;
import io.usethesource.vallang.impl.primitive.BigDecimalValue;
import io.usethesource.vallang.impl.primitive.BigIntegerValue;
import io.usethesource.vallang.impl.primitive.BoolValue;
import io.usethesource.vallang.impl.primitive.ICanBecomeABigInteger;
import io.usethesource.vallang.impl.primitive.RationalValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

class IntegerValue
extends AbstractNumberValue
implements IInteger,
ICanBecomeABigInteger {
    private static final Type INTEGER_TYPE = TypeFactory.getInstance().integerType();
    private static final String INTEGER_MAX_STRING = "2147483647";
    private static final String NEGATIVE_INTEGER_MAX_STRING = "-2147483648";
    private static final int SEVEN_BITS_MASK = 127;
    private static final int FIFTEEN_BITS_MASK = Short.MAX_VALUE;
    private static final int TWENTYTHREE_BITS_MASK = 0x7FFFFF;
    private static final IInteger[] smallValues = new IInteger[201];
    private static final BigInteger[] smallBigIntegerValues = new BigInteger[201];
    private static final int minSmallValue = -100;
    private static final int maxSmallValue = 100;
    public static final IInteger INTEGER_ONE;
    public static final IInteger INTEGER_ZERO;
    protected final int value;

    static IInteger newInteger(BigInteger value) {
        if (value.bitLength() > 31) {
            return new BigIntegerValue(value);
        }
        return IntegerValue.newInteger(value.intValue());
    }

    static IInteger newInteger(int value) {
        if (-100 <= value && value <= 100) {
            return smallValues[value - -100];
        }
        return new IntegerValue(value);
    }

    static IInteger newInteger(String integerValue) {
        if (integerValue.startsWith("-")) {
            if (integerValue.length() < 11 || integerValue.length() == 11 && integerValue.compareTo(NEGATIVE_INTEGER_MAX_STRING) <= 0) {
                return IntegerValue.newInteger(Integer.parseInt(integerValue));
            }
            return new BigIntegerValue(new BigInteger(integerValue));
        }
        if (integerValue.length() < 10 || integerValue.length() == 10 && integerValue.compareTo(INTEGER_MAX_STRING) <= 0) {
            return IntegerValue.newInteger(Integer.parseInt(integerValue));
        }
        return new BigIntegerValue(new BigInteger(integerValue));
    }

    static IInteger newInteger(long value) {
        if ((value & Integer.MAX_VALUE) == value || (value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return IntegerValue.newInteger((int)value);
        }
        byte[] valueData = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return IntegerValue.newInteger(valueData);
    }

    static IInteger newInteger(byte[] integerData) {
        if (integerData.length <= 4) {
            int value = 0;
            int i = integerData.length - 1;
            int j = 0;
            while (i >= 0) {
                value |= (integerData[i] & 0xFF) << j * 8;
                --i;
                ++j;
            }
            return IntegerValue.newInteger(value);
        }
        return new BigIntegerValue(new BigInteger(integerData));
    }

    private IntegerValue(int value) {
        this.value = value;
    }

    @Override
    public IInteger toInteger() {
        return this;
    }

    @Override
    public Type getType() {
        return INTEGER_TYPE;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public IReal toReal(int precision) {
        return BigDecimalValue.newReal(BigDecimal.valueOf(this.value));
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        if ((this.value & 0x7F) == this.value) {
            byte[] data = new byte[]{(byte)(this.value & 0x7F)};
            return data;
        }
        if ((this.value & Short.MAX_VALUE) == this.value) {
            byte[] data = new byte[]{(byte)(this.value >> 8 & 0x7F), (byte)(this.value & 0xFF)};
            return data;
        }
        if ((this.value & 0x7FFFFF) == this.value) {
            byte[] data = new byte[]{(byte)(this.value >> 16 & 0x7F), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
            return data;
        }
        byte[] data = new byte[]{(byte)(this.value >> 24 & 0xFF), (byte)(this.value >> 16 & 0xFF), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
        return data;
    }

    @Override
    public BigInteger toBigInteger() {
        if (-100 <= this.value && this.value <= 100) {
            return smallBigIntegerValues[this.value - -100];
        }
        return new BigInteger(this.getTwosComplementRepresentation());
    }

    @Override
    public IInteger add(IInteger other) {
        if (this.value == 0) {
            return other;
        }
        if (other instanceof BigIntegerValue) {
            return other.add(this);
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 0) {
            return this;
        }
        int result = this.value + otherIntValue;
        if (this.value < 0 && otherIntValue < 0 && result >= 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return IntegerValue.newInteger(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue > 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return IntegerValue.newInteger(new BigInteger(intValueData));
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IRational add(IRational other) {
        return (IRational)other.add(this);
    }

    @Override
    public IReal add(IReal other) {
        return (IReal)other.add(this);
    }

    @Override
    public INumber subtract(IReal other) {
        return this.toReal(other.precision()).subtract(other);
    }

    @Override
    public IInteger subtract(IInteger other) {
        if (this.value == 0) {
            return other.negate();
        }
        if (other instanceof BigIntegerValue) {
            return other.negate().subtract(this.negate());
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 0) {
            return this;
        }
        int result = this.value - otherIntValue;
        if (this.value < 0 && otherIntValue > 0 && result > 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return IntegerValue.newInteger(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue < 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return IntegerValue.newInteger(new BigInteger(intValueData));
        }
        return IntegerValue.newInteger(result);
    }

    @Override
    public IRational subtract(IRational other) {
        return this.toRational().subtract(other);
    }

    @Override
    public IInteger multiply(IInteger other) {
        boolean resultIsPositive;
        if (this.value == 0) {
            return this;
        }
        if (this.value == 1) {
            return other;
        }
        if (other instanceof BigIntegerValue) {
            return other.multiply(this);
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 0) {
            return other;
        }
        if (otherIntValue == 1) {
            return this;
        }
        boolean bl = resultIsPositive = ((this.value ^ otherIntValue ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (resultIsPositive) {
            int div = Integer.MAX_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return IntegerValue.newInteger(this.value * other.intValue());
            }
        } else {
            int div = Integer.MIN_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return IntegerValue.newInteger(this.value * other.intValue());
            }
        }
        return IntegerValue.newInteger(this.toBigInteger().multiply(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
    }

    @Override
    public IRational multiply(IRational other) {
        return (IRational)other.multiply(this);
    }

    @Override
    public IReal multiply(IReal other) {
        return (IReal)other.multiply(this);
    }

    @Override
    public IInteger divide(IInteger other) {
        if (other.equals(INTEGER_ZERO)) {
            throw new ArithmeticException("/ by zero");
        }
        if (this.value == 0) {
            return this;
        }
        if (other instanceof BigIntegerValue) {
            return IntegerValue.newInteger(this.toBigInteger().divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 1) {
            return this;
        }
        return IntegerValue.newInteger(this.value / otherIntValue);
    }

    @Override
    public IRational divide(IRational other) {
        return this.toRational().divide(other);
    }

    @Override
    public INumber divide(IInteger other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public INumber divide(IRational other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return this.toReal(precision).divide(other, precision);
    }

    @Override
    public IInteger mod(IInteger other) {
        if (other instanceof BigIntegerValue) {
            if (this.value < 0) {
                BigInteger m4 = ((BigIntegerValue)other).toBigInteger();
                BigInteger res = m4.add(this.toBigInteger());
                return IntegerValue.newInteger(res);
            }
            return this;
        }
        int otherVal = other.intValue();
        int newValue = this.value % other.intValue();
        newValue = newValue >= 0 ? newValue : newValue + otherVal;
        return IntegerValue.newInteger(newValue);
    }

    @Override
    public IInteger remainder(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return this;
        }
        return IntegerValue.newInteger(this.value % other.intValue());
    }

    @Override
    public IInteger negate() {
        if (this.value == 0) {
            return this;
        }
        return IntegerValue.newInteger(((long)this.value ^ 0xFFFFFFFFFFFFFFFFL) + 1L);
    }

    @Override
    public IBool equal(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) == 0);
    }

    @Override
    public IBool equal(IRational other) {
        return other.equal(this);
    }

    @Override
    public IBool equal(IReal other) {
        return other.equal(this);
    }

    @Override
    public IBool greater(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IRational other) {
        return other.less(this);
    }

    @Override
    public IBool greater(IReal other) {
        return other.less(this);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IRational other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool less(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool less(IRational other) {
        return other.greater(this);
    }

    @Override
    public IBool less(IReal other) {
        return other.greater(this);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return BoolValue.getBoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IRational other) {
        return other.greaterEqual(this);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return other.greaterEqual(this);
    }

    @Override
    public int compare(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return ~other.compare(this) + 1;
        }
        if (this.value > other.intValue()) {
            return 1;
        }
        if (this.value < other.intValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(INumber other) {
        if (this.isIntegerType(other)) {
            return this.compare(other.toInteger());
        }
        if (this.isRationalType(other)) {
            return this.toRational().compare(other);
        }
        assert (other instanceof IReal);
        return this.toReal(((IReal)other).precision()).compare(other);
    }

    public int hashCode() {
        int h2 = this.value ^ 0x85EBCA6B;
        h2 ^= h2 >>> 13;
        h2 *= 1540483477;
        h2 ^= h2 >>> 15;
        return h2;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            IntegerValue otherInteger = (IntegerValue)o;
            return this.value == otherInteger.value;
        }
        return false;
    }

    @Override
    public String getStringRepresentation() {
        return Integer.toString(this.value);
    }

    @Override
    public int signum() {
        return this.value < 0 ? -1 : (this.value == 0 ? 0 : 1);
    }

    @Override
    public IInteger abs() {
        return IntegerValue.newInteger(Math.abs(this.value));
    }

    @Override
    public IRational toRational() {
        return RationalValue.newRational(this, INTEGER_ONE);
    }

    static {
        for (int i = -100; i <= 100; ++i) {
            IntegerValue.smallValues[i - -100] = new IntegerValue(i);
            IntegerValue.smallBigIntegerValues[i - -100] = new BigInteger("" + i);
        }
        INTEGER_ONE = smallValues[101];
        INTEGER_ZERO = smallValues[100];
    }
}

