/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

class Tuple
implements ITuple {
    protected final Type fType;
    protected final IValue[] fElements;

    Tuple(IValue ... elements) {
        this.fType = TypeFactory.getInstance().tupleType(elements);
        this.fElements = elements;
    }

    private Tuple(Tuple other, int i, IValue elem) {
        this.fType = other.getType();
        this.fElements = (IValue[])other.fElements.clone();
        this.fElements[i] = elem;
    }

    @Override
    public Type getType() {
        return this.fType;
    }

    @Override
    public Iterator<IValue> iterator() {
        return new Iterator<IValue>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < Tuple.this.arity();
            }

            @Override
            public IValue next() {
                return Tuple.this.get(this.count++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove elements from a tuple");
            }
        };
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.fElements.length; ++i) {
            hash = hash << 1 ^ hash >> 1 ^ this.fElements[i].hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            Tuple peer = (Tuple)o;
            if (this.fType != peer.fType) {
                return false;
            }
            int arity = this.arity();
            if (arity != peer.arity()) {
                return false;
            }
            for (int i = 0; i < arity; ++i) {
                if (this.get(i).equals(peer.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        try {
            return this.fElements[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Tuple index " + i + " is larger than tuple width " + this.arity());
        }
    }

    @Override
    public IValue get(String label) throws FactTypeUseException {
        return this.fElements[this.fType.getFieldIndex(label)];
    }

    @Override
    public ITuple set(int i, IValue arg) throws IndexOutOfBoundsException {
        return new Tuple(this, i, arg);
    }

    @Override
    public ITuple set(String label, IValue arg) throws FactTypeUseException {
        int i = this.fType.getFieldIndex(label);
        return new Tuple(this, i, arg);
    }

    @Override
    public int arity() {
        return this.fElements.length;
    }

    @Override
    public IValue select(int ... fields) throws IndexOutOfBoundsException {
        Type type = this.fType.select(fields);
        if (type.isFixedWidth()) {
            return this.doSelect(type, fields);
        }
        return this.get(fields[0]);
    }

    @Override
    public IValue selectByFieldNames(String ... fields) throws FactTypeUseException {
        Type type = this.fType.select(fields);
        if (type.isFixedWidth()) {
            int[] indexes = new int[fields.length];
            int i = 0;
            for (String name : fields) {
                indexes[i] = type.getFieldIndex(name);
            }
            return this.doSelect(type, indexes);
        }
        return this.get(fields[0]);
    }

    private IValue doSelect(Type type, int ... fields) throws IndexOutOfBoundsException {
        if (fields.length == 1) {
            return this.get(fields[0]);
        }
        IValue[] elems = new IValue[fields.length];
        Type[] elemTypes = new Type[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            elems[i] = this.get(fields[i]);
            elemTypes[i] = elems[i].getType();
        }
        return new Tuple(elems);
    }
}

