/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.stream;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.binary.message.IValueWriter;
import io.usethesource.vallang.io.binary.stream.Compressor;
import io.usethesource.vallang.io.binary.stream.Header;
import io.usethesource.vallang.io.binary.util.ByteBufferOutputStream;
import io.usethesource.vallang.io.binary.util.DelayedCompressionOutputStream;
import io.usethesource.vallang.io.binary.util.DelayedZstdOutputStream;
import io.usethesource.vallang.io.binary.util.FileChannelDirectOutputStream;
import io.usethesource.vallang.io.binary.util.WindowSizes;
import io.usethesource.vallang.io.binary.wire.IWireOutputStream;
import io.usethesource.vallang.io.binary.wire.binary.BinaryWireOutputStream;
import io.usethesource.vallang.io.binary.wire.xml.XMLWireOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class IValueOutputStream
implements Closeable {
    private CompressionRate compression;
    private OutputStream rawStream;
    private @MonotonicNonNull IWireOutputStream writer;
    private final IValueFactory vf;

    public IValueOutputStream(OutputStream out, IValueFactory vf) throws IOException {
        this(out, vf, CompressionRate.Normal);
    }

    public IValueOutputStream(FileChannel channel, IValueFactory vf, CompressionRate compression) throws IOException {
        this(IValueOutputStream.byteBufferedOutput(channel), vf, compression);
    }

    public IValueOutputStream(OutputStream out, IValueFactory vf, CompressionRate compression) throws IOException {
        out.write(Header.MAIN);
        this.rawStream = out;
        this.compression = compression;
        this.vf = vf;
    }

    private static OutputStream byteBufferedOutput(FileChannel channel) {
        return new FileChannelDirectOutputStream(channel, 10);
    }

    public void write(IValue value) throws IOException {
        WindowSizes sizes;
        WindowSizes windowSizes = sizes = this.compression.compressionLevel == 0 ? WindowSizes.NO_WINDOW : WindowSizes.NORMAL_WINDOW;
        if (this.writer == null) {
            this.writer = this.initializeWriter(sizes);
        }
        IValueWriter.write(this.writer, this.vf, sizes, value);
    }

    private static int fallbackIfNeeded(int compressionAlgorithm) {
        if (compressionAlgorithm == 3 && !Compressor.zstdAvailable()) {
            return 1;
        }
        return compressionAlgorithm;
    }

    private IWireOutputStream initializeWriter(WindowSizes sizes) throws IOException {
        if (this.compression == CompressionRate.XML) {
            return new XMLWireOutputStream(this.rawStream);
        }
        if (sizes == WindowSizes.NO_WINDOW || sizes == WindowSizes.TINY_WINDOW) {
            this.compression = CompressionRate.None;
        }
        int algorithm = IValueOutputStream.fallbackIfNeeded(this.compression.compressionAlgorithm);
        this.rawStream = this.rawStream instanceof ByteBufferOutputStream && algorithm == 3 && ((ByteBufferOutputStream)this.rawStream).getBuffer().isDirect() ? new DelayedZstdOutputStream((ByteBufferOutputStream)this.rawStream, algorithm, this.compression.compressionLevel) : new DelayedCompressionOutputStream(this.rawStream, algorithm, o -> Compressor.wrapStream(o, algorithm, this.compression.compressionLevel));
        return new BinaryWireOutputStream(this.rawStream, sizes.stringsWindow);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.rawStream.close();
        }
    }

    public static enum CompressionRate {
        NoSharing(0, 0),
        None(0, 0),
        Light(3, 1),
        Normal(3, 5),
        Strong(3, 13),
        Extreme(3, 19),
        XML(0, 0);

        private final int compressionAlgorithm;
        private final int compressionLevel;

        private CompressionRate(int compressionAlgorithm, int compressionLevel) {
            this.compressionLevel = compressionLevel;
            this.compressionAlgorithm = compressionAlgorithm;
        }
    }
}

