/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FunctionType
extends DefaultSubtypeOfValue {
    private final Type returnType;
    private final TupleType argumentTypes;
    private final @Nullable TupleType keywordParameters;

    FunctionType(Type returnType, TupleType argumentTypes, TupleType keywordParameters) {
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.keywordParameters = keywordParameters == null ? null : (keywordParameters.getArity() == 0 ? null : keywordParameters);
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Reifier(symbols);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public Type getFieldType(int i) {
        return this.argumentTypes.getFieldType(i);
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        return this.argumentTypes.getFieldType(fieldName);
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.argumentTypes.getFieldIndex(fieldName);
    }

    @Override
    public String getFieldName(int i) {
        return this.argumentTypes.getFieldName(i);
    }

    @Override
    public String[] getFieldNames() {
        return this.argumentTypes.getFieldNames();
    }

    @Override
    public Type getFieldTypes() {
        return this.argumentTypes;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitFunction(this);
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public int getArity() {
        return this.argumentTypes.getArity();
    }

    @Override
    public Type getKeywordParameterTypes() {
        return this.keywordParameters == null ? TypeFactory.getInstance().tupleEmpty() : this.keywordParameters;
    }

    @Override
    public @Nullable Type getKeywordParameterType(String label) {
        return this.keywordParameters != null ? this.keywordParameters.getFieldType(label) : null;
    }

    @Override
    public boolean hasKeywordParameter(String label) {
        return this.keywordParameters != null ? this.keywordParameters.hasField(label) : false;
    }

    @Override
    public boolean hasKeywordParameters() {
        return this.keywordParameters != null;
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfFunction(this);
    }

    @Override
    public Type lub(Type type) {
        return type.lubWithFunction(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithFunction(this);
    }

    @Override
    public boolean intersects(Type type) {
        return type.intersectsWithFunction(this);
    }

    @Override
    protected boolean intersectsWithFunction(Type other) {
        FunctionType otherType = (FunctionType)other;
        if (other.getArity() != this.getArity()) {
            return false;
        }
        if (otherType.getReturnType().isBottom() && this.getReturnType().isBottom()) {
            return otherType.getFieldTypes().intersects(this.getFieldTypes());
        }
        return otherType.getReturnType().intersects(this.getReturnType()) && otherType.getFieldTypes().intersects(this.getFieldTypes());
    }

    @Override
    public boolean isSubtypeOfFunction(Type other) {
        FunctionType otherType = (FunctionType)other;
        if (this.getReturnType().isSubtypeOf(otherType.getReturnType())) {
            Type argTypes = this.getFieldTypes();
            Type otherArgTypes = otherType.getFieldTypes();
            if (argTypes.getArity() != otherArgTypes.getArity()) {
                return false;
            }
            int N2 = argTypes.getArity();
            for (int i = 0; i < N2; ++i) {
                Type field = argTypes.getFieldType(i);
                Type otherField = otherArgTypes.getFieldType(i);
                if (field.isBottom() || otherField.isBottom() || field.intersects(otherField)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Type lubWithFunction(Type type) {
        if (this == type) {
            return this;
        }
        FunctionType f = (FunctionType)type;
        Type returnType = this.getReturnType().lub(f.getReturnType());
        Type argumentTypes = this.getFieldTypes().lub(f.getFieldTypes());
        if (argumentTypes.isTuple() && argumentTypes.getArity() == this.getArity()) {
            return TypeFactory.getInstance().functionType(returnType, argumentTypes, this.getKeywordParameterTypes() == f.getKeywordParameterTypes() ? this.getKeywordParameterTypes() : TF.tupleEmpty());
        }
        return TF.valueType();
    }

    @Override
    protected Type glbWithFunction(Type type) {
        if (this == type) {
            return this;
        }
        FunctionType f = (FunctionType)type;
        Type returnType = this.getReturnType().glb(f.getReturnType());
        Type argumentTypes = this.getFieldTypes().lub(f.getFieldTypes());
        if (argumentTypes.isTuple()) {
            return TF.functionType(returnType, argumentTypes, TF.tupleEmpty());
        }
        return TF.voidType();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.returnType);
        sb.append(' ');
        sb.append('(');
        int i = 0;
        for (Type arg : this.argumentTypes) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arg.toString());
            if (this.argumentTypes.hasFieldNames()) {
                sb.append(" " + this.argumentTypes.getFieldName(i));
            }
            ++i;
        }
        if (this.keywordParameters != null) {
            i = 0;
            for (Type arg : this.keywordParameters) {
                sb.append(", ");
                sb.append(arg.toString());
                if (this.keywordParameters.hasFieldNames()) {
                    sb.append(" " + this.keywordParameters.getFieldName(i) + " = ...");
                }
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return 19 + 19 * this.returnType.hashCode() + 23 * this.argumentTypes.hashCode() + (this.keywordParameters != null ? 29 * this.keywordParameters.hashCode() : 0);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof FunctionType) {
            FunctionType other = (FunctionType)o;
            if (this.returnType != other.returnType) {
                return false;
            }
            if (this.argumentTypes != other.argumentTypes) {
                return false;
            }
            return this.keywordParameters == other.keywordParameters;
        }
        return false;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        return TF.functionType(this.returnType.instantiate(bindings), this.instantiateTuple(this.argumentTypes, bindings), this.keywordParameters != null ? this.instantiateTuple(this.keywordParameters, bindings) : TypeFactory.getInstance().tupleEmpty());
    }

    @Override
    public boolean isOpen() {
        return this.returnType.isOpen() || this.argumentTypes.isOpen();
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (matched.isBottom()) {
            return this.argumentTypes.match(matched, bindings) && this.returnType.match(matched, bindings);
        }
        while (matched.isAliased()) {
            matched = matched.getAliased();
        }
        if (matched.isFunction()) {
            FunctionType matchedFunction = (FunctionType)matched;
            if (this.argumentTypes.getArity() != matchedFunction.getArity()) {
                return false;
            }
            for (int i = this.argumentTypes.getArity() - 1; i >= 0; --i) {
                Type fieldType = this.argumentTypes.getFieldType(i);
                Type otherFieldType = matchedFunction.getFieldTypes().getFieldType(i);
                HashMap<Type, Type> originalBindings = new HashMap<Type, Type>();
                originalBindings.putAll(bindings);
                if (fieldType.match(otherFieldType, bindings) || otherFieldType.match(matchedFunction, bindings = originalBindings)) continue;
                return false;
            }
            return this.returnType.match(matchedFunction.getReturnType(), bindings);
        }
        return false;
    }

    @Override
    public Type compose(Type right) {
        if (right.isBottom()) {
            return right;
        }
        if (right.isFunction()) {
            if (TF.tupleType(right.getReturnType()).isSubtypeOf(this.argumentTypes)) {
                return TF.functionType(this.returnType, right.getFieldTypes(), right.getKeywordParameterTypes());
            }
        } else {
            throw new IllegalOperationException("compose", this, right);
        }
        return TF.voidType();
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
        throw new RuntimeException("randomValue on FunctionType not yet implemented");
    }

    public static class Reifier
    extends TypeFactory.TypeReifier {
        public Reifier(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Type> getSymbolConstructorTypes() {
            return Arrays.stream(new Type[]{this.normalFunctionSymbol()}).collect(Collectors.toSet());
        }

        private Type normalFunctionSymbol() {
            return this.symbols().typeSymbolConstructor("func", this.symbols().symbolADT(), "ret", Type.TF.listType(this.symbols().symbolADT()), "parameters", Type.TF.listType(this.symbols().symbolADT()), "kwTypes");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            Type returnType = this.symbols().fromSymbol((IConstructor)symbol.get("ret"), store, grammar);
            Type parameters = this.symbols().fromSymbols((IList)symbol.get("parameters"), store, grammar);
            Type kwTypes = this.symbols().fromSymbols((IList)symbol.get("kwTypes"), store, grammar);
            return TypeFactory.getInstance().functionType(returnType, parameters, kwTypes);
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return Type.TF.integerType();
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            ((FunctionType)type).getReturnType().asProductions(vf, store, grammar, done);
            for (Type arg : ((FunctionType)type).getFieldTypes()) {
                arg.asProductions(vf, store, grammar, done);
            }
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IListWriter w = vf.listWriter();
            int i = 0;
            Type args = ((FunctionType)type).getFieldTypes();
            for (Type arg : args) {
                IConstructor sym = arg.asSymbol(vf, store, grammar, done);
                if (args.hasFieldNames()) {
                    sym = this.symbols().labelSymbol(vf, sym, args.getFieldName(i));
                }
                ++i;
                w.append(sym);
            }
            IListWriter kw = vf.listWriter();
            i = 0;
            Type kwArgs = ((FunctionType)type).getKeywordParameterTypes();
            if (kwArgs != null && !kwArgs.isBottom()) {
                for (Type arg : kwArgs) {
                    IConstructor sym = arg.asSymbol(vf, store, grammar, done);
                    if (kwArgs.hasFieldNames()) {
                        sym = this.symbols().labelSymbol(vf, sym, kwArgs.getFieldName(i));
                    }
                    ++i;
                    kw.append(sym);
                }
            }
            return vf.constructor(this.normalFunctionSymbol(), new IValue[]{((FunctionType)type).getReturnType().asSymbol(vf, store, grammar, done), w.done(), kw.done()});
        }
    }
}

