/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class DataTarget
extends AbstractAST {
    public DataTarget(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasLabel() {
        return false;
    }

    public Name getLabel() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isLabeled() {
        return false;
    }

    public static class Labeled
    extends DataTarget {
        private final Name label;

        public Labeled(ISourceLocation src, IConstructor node, Name label) {
            super(src, node);
            this.label = label;
        }

        @Override
        public boolean isLabeled() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDataTargetLabeled(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Labeled)) {
                return false;
            }
            Labeled tmp = (Labeled)o;
            return tmp.label.equals(this.label);
        }

        @Override
        public int hashCode() {
            return 769 + 17 * this.label.hashCode();
        }

        @Override
        public Name getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public Object clone() {
            return Labeled.newInstance(this.getClass(), this.src, null, this.clone(this.label));
        }
    }

    public static class Empty
    extends DataTarget {
        public Empty(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDataTargetEmpty(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty tmp = (Empty)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 167;
        }

        @Override
        public Object clone() {
            return Empty.newInstance(this.getClass(), this.src, null);
        }
    }
}

