/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Replacement;
import org.rascalmpl.ast.Statement;

public abstract class PatternWithAction
extends AbstractAST {
    public PatternWithAction(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasPattern() {
        return false;
    }

    public Expression getPattern() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasReplacement() {
        return false;
    }

    public Replacement getReplacement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStatement() {
        return false;
    }

    public Statement getStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isArbitrary() {
        return false;
    }

    public boolean isReplacing() {
        return false;
    }

    public static class Replacing
    extends PatternWithAction {
        private final Expression pattern;
        private final Replacement replacement;

        public Replacing(ISourceLocation src, IConstructor node, Expression pattern, Replacement replacement) {
            super(src, node);
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Override
        public boolean isReplacing() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitPatternWithActionReplacing(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pattern.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pattern.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.replacement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.replacement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Replacing)) {
                return false;
            }
            Replacing tmp = (Replacing)o;
            return tmp.pattern.equals(this.pattern) && tmp.replacement.equals(this.replacement);
        }

        @Override
        public int hashCode() {
            return 239 + 241 * this.pattern.hashCode() + 673 * this.replacement.hashCode();
        }

        @Override
        public Expression getPattern() {
            return this.pattern;
        }

        @Override
        public boolean hasPattern() {
            return true;
        }

        @Override
        public Replacement getReplacement() {
            return this.replacement;
        }

        @Override
        public boolean hasReplacement() {
            return true;
        }

        @Override
        public Object clone() {
            return Replacing.newInstance(this.getClass(), this.src, null, this.clone(this.pattern), this.clone(this.replacement));
        }
    }

    public static class Arbitrary
    extends PatternWithAction {
        private final Expression pattern;
        private final Statement statement;

        public Arbitrary(ISourceLocation src, IConstructor node, Expression pattern, Statement statement) {
            super(src, node);
            this.pattern = pattern;
            this.statement = statement;
        }

        @Override
        public boolean isArbitrary() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitPatternWithActionArbitrary(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pattern.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pattern.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.statement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Arbitrary)) {
                return false;
            }
            Arbitrary tmp = (Arbitrary)o;
            return tmp.pattern.equals(this.pattern) && tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 257 + 941 * this.pattern.hashCode() + 601 * this.statement.hashCode();
        }

        @Override
        public Expression getPattern() {
            return this.pattern;
        }

        @Override
        public boolean hasPattern() {
            return true;
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Arbitrary.newInstance(this.getClass(), this.src, null, this.clone(this.pattern), this.clone(this.statement));
        }
    }
}

