/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Prod;
import org.rascalmpl.ast.Start;
import org.rascalmpl.ast.Sym;
import org.rascalmpl.ast.Visibility;

public abstract class SyntaxDefinition
extends AbstractAST {
    public SyntaxDefinition(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasProduction() {
        return false;
    }

    public Prod getProduction() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStart() {
        return false;
    }

    public Start getStart() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasDefined() {
        return false;
    }

    public Sym getDefined() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasVis() {
        return false;
    }

    public Visibility getVis() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isKeyword() {
        return false;
    }

    public boolean isLanguage() {
        return false;
    }

    public boolean isLayout() {
        return false;
    }

    public boolean isLexical() {
        return false;
    }

    public static class Lexical
    extends SyntaxDefinition {
        private final Sym defined;
        private final Prod production;

        public Lexical(ISourceLocation src, IConstructor node, Sym defined, Prod production) {
            super(src, node);
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLexical() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLexical(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.defined.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Lexical)) {
                return false;
            }
            Lexical tmp = (Lexical)o;
            return tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 509 + 563 * this.defined.hashCode() + 149 * this.production.hashCode();
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Lexical.newInstance(this.getClass(), this.src, null, this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Layout
    extends SyntaxDefinition {
        private final Visibility vis;
        private final Sym defined;
        private final Prod production;

        public Layout(ISourceLocation src, IConstructor node, Visibility vis, Sym defined, Prod production) {
            super(src, node);
            this.vis = vis;
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLayout() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLayout(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.vis.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.vis.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.defined.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Layout)) {
                return false;
            }
            Layout tmp = (Layout)o;
            return tmp.vis.equals(this.vis) && tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 769 + 163 * this.vis.hashCode() + 641 * this.defined.hashCode() + 313 * this.production.hashCode();
        }

        @Override
        public Visibility getVis() {
            return this.vis;
        }

        @Override
        public boolean hasVis() {
            return true;
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Layout.newInstance(this.getClass(), this.src, null, this.clone(this.vis), this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Language
    extends SyntaxDefinition {
        private final Start start;
        private final Sym defined;
        private final Prod production;

        public Language(ISourceLocation src, IConstructor node, Start start, Sym defined, Prod production) {
            super(src, node);
            this.start = start;
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isLanguage() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionLanguage(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.start.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.start.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.defined.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Language)) {
                return false;
            }
            Language tmp = (Language)o;
            return tmp.start.equals(this.start) && tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 163 + 683 * this.start.hashCode() + 661 * this.defined.hashCode() + 499 * this.production.hashCode();
        }

        @Override
        public Start getStart() {
            return this.start;
        }

        @Override
        public boolean hasStart() {
            return true;
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Language.newInstance(this.getClass(), this.src, null, this.clone(this.start), this.clone(this.defined), this.clone(this.production));
        }
    }

    public static class Keyword
    extends SyntaxDefinition {
        private final Sym defined;
        private final Prod production;

        public Keyword(ISourceLocation src, IConstructor node, Sym defined, Prod production) {
            super(src, node);
            this.defined = defined;
            this.production = production;
        }

        @Override
        public boolean isKeyword() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSyntaxDefinitionKeyword(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.defined.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defined.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Keyword)) {
                return false;
            }
            Keyword tmp = (Keyword)o;
            return tmp.defined.equals(this.defined) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 617 + 233 * this.defined.hashCode() + 263 * this.production.hashCode();
        }

        @Override
        public Sym getDefined() {
            return this.defined;
        }

        @Override
        public boolean hasDefined() {
            return true;
        }

        @Override
        public Prod getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Keyword.newInstance(this.getClass(), this.src, null, this.clone(this.defined), this.clone(this.production));
        }
    }
}

