/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.Type;

public abstract class TypeArg
extends AbstractAST {
    public TypeArg(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isNamed() {
        return false;
    }

    public static class Named
    extends TypeArg {
        private final Type type;
        private final Name name;

        public Named(ISourceLocation src, IConstructor node, Type type, Name name) {
            super(src, node);
            this.type = type;
            this.name = name;
        }

        @Override
        public boolean isNamed() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeArgNamed(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Named)) {
                return false;
            }
            Named tmp = (Named)o;
            return tmp.type.equals(this.type) && tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 139 + 293 * this.type.hashCode() + 773 * this.name.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Named.newInstance(this.getClass(), this.src, null, this.clone(this.type), this.clone(this.name));
        }
    }

    public static class Default
    extends TypeArg {
        private final Type type;

        public Default(ISourceLocation src, IConstructor node, Type type) {
            super(src, node);
            this.type = type;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeArgDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.type.equals(this.type);
        }

        @Override
        public int hashCode() {
            return 59 + 823 * this.type.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.type));
        }
    }
}

