/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.RegExpVar;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.semantics.dynamic.RegExpLiteral;

public class RegExpPatternValue
extends AbstractMatchingResult {
    private final List<RegExpLiteral.InterpolationElement> regexp;
    private Pattern pat;
    private List<String> patternVars;
    private Matcher matcher;
    String subject;
    private boolean initialized = false;
    private boolean firstMatch;
    private boolean hasNext;
    private int start;
    private int end;
    private boolean iWroteItMySelf;

    public RegExpPatternValue(IEvaluatorContext ctx, AbstractAST x, List<RegExpLiteral.InterpolationElement> regexp, List<String> patternVars) {
        super(ctx, x);
        this.regexp = regexp;
        this.patternVars = patternVars;
        this.initialized = false;
        this.iWroteItMySelf = false;
    }

    private String interpolate(IEvaluatorContext env) {
        StringBuilder b = new StringBuilder();
        for (RegExpLiteral.InterpolationElement elem : this.regexp) {
            b.append(elem.getString(env));
        }
        return b.toString();
    }

    @Override
    public Type getType(Environment ev, HashMap<String, IVarPattern> patternVars) {
        return this.tf.stringType();
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        Type runType = subject.getValue().getType();
        if (!runType.isSubtypeOf(this.tf.stringType())) {
            this.hasNext = false;
            return;
        }
        this.subject = ((IString)subject.getValue()).getValue();
        this.hasNext = true;
        this.firstMatch = true;
        this.initialized = true;
        try {
            String RegExpAsString = this.interpolate(this.ctx);
            this.pat = Pattern.compile(RegExpAsString, 256);
        }
        catch (PatternSyntaxException e) {
            throw new SyntaxError(e.getMessage(), this.ctx.getCurrentAST().getLocation());
        }
    }

    @Override
    public boolean hasNext() {
        return this.initialized && (this.firstMatch || this.hasNext);
    }

    @Override
    public boolean mayMatch(Type subjectType, Environment env) {
        return subjectType.equivalent(this.tf.stringType());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    private boolean findMatch() {
        if (this.matcher.find()) {
            for (int nVar = 0; nVar < this.patternVars.size(); ++nVar) {
                String binding = this.matcher.group(1 + nVar);
                if (binding == null) continue;
                String name = this.patternVars.get(nVar);
                this.ctx.getCurrentEnvt().storeVariable(name, ResultFactory.makeResult(this.tf.stringType(), this.ctx.getValueFactory().string(binding), this.ctx));
            }
            this.start = this.matcher.start(0);
            this.end = this.matcher.end(0);
            return true;
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public boolean next() {
        if (this.firstMatch) {
            this.firstMatch = false;
            this.matcher = this.pat.matcher(this.subject);
            IString empty = this.ctx.getValueFactory().string("");
            for (String name : this.patternVars) {
                if (!this.iWroteItMySelf && !this.ctx.getCurrentEnvt().declareVariable(this.tf.stringType(), name)) {
                    throw new RedeclaredVariable(name, this.ctx.getCurrentAST());
                }
                this.ctx.getCurrentEnvt().storeVariable(name, ResultFactory.makeResult(this.tf.stringType(), empty, this.ctx));
            }
            this.iWroteItMySelf = true;
        }
        try {
            return this.findMatch();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ImplementationError("Unexpected error in mapping to Java regex:" + this.interpolate(this.ctx), this.ctx.getCurrentAST().getLocation());
        }
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        for (String name : this.patternVars) {
            res.add(new RegExpVar(name));
        }
        return res;
    }

    public String toString() {
        return "RegExpPatternValue(" + this.regexp + ", " + this.patternVars + ")";
    }

    @Override
    public AbstractAST getAST() {
        return this.ctx.getCurrentAST();
    }

    public boolean bindingInstance() {
        return this.iWroteItMySelf;
    }
}

