/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.staticErrors;

import io.usethesource.vallang.ISourceLocation;
import org.rascalmpl.ast.AbstractAST;

public abstract class StaticError
extends RuntimeException {
    private static final long serialVersionUID = 2730379050952564623L;
    private ISourceLocation loc;

    public StaticError(String message, ISourceLocation loc) {
        super(message);
        if (loc != null) {
            this.addStackTraceElement(loc);
        }
        this.loc = loc;
    }

    public StaticError(String message, ISourceLocation loc, Throwable cause) {
        super(message, cause);
        if (loc != null) {
            this.addStackTraceElement(loc);
        }
        this.loc = loc;
    }

    public StaticError(String message, AbstractAST ast) {
        this(message, ast != null ? ast.getLocation() : null);
    }

    public StaticError(String message, AbstractAST ast, Throwable cause) {
        this(message, ast != null ? ast.getLocation() : null, cause);
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    public void setLocation(ISourceLocation loc) {
        String mod = loc.getPath().replaceAll("^.*/", "").replaceAll("\\..*$", "");
        this.getStackTrace()[0] = new StackTraceElement(mod, "?", loc.getPath(), loc.getBeginLine());
        this.loc = loc;
    }

    private void addStackTraceElement(ISourceLocation loc) {
        StackTraceElement[] oldStackTrace = this.getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[oldStackTrace.length + 1];
        int i = 0;
        String mod = loc.getScheme().equals("rascal") ? loc.getAuthority() : loc.getPath().replaceAll("^.*/", "").replaceAll("\\..*$", "");
        if (mod == null) {
            mod = "<empty>";
        }
        stackTrace[i++] = loc.hasLineColumn() ? new StackTraceElement(mod, "?", loc.getPath(), loc.getBeginLine()) : new StackTraceElement(mod, "?", loc.getPath(), 1);
        for (StackTraceElement elt : oldStackTrace) {
            stackTrace[i++] = elt;
        }
        this.setStackTrace(stackTrace);
    }

    public String getAdvice() {
        String prefix = "https://www.rascal-mpl.org/docs/Rascal/Errors/CompileTimeErrors/";
        String cn = this.getClass().getSimpleName();
        return "Advice: |" + prefix + cn + "|";
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n" + this.getAdvice();
    }
}

