/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.analysis.statistics;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import org.apache.commons.math.MathException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.stat.correlation.Covariance;
import org.apache.commons.math.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math.stat.correlation.SpearmansCorrelation;

public class Correlations {
    private final IValueFactory values;
    double[] xvalues;
    double[] yvalues;
    double[][] xyvalues;

    public Correlations(IValueFactory values) {
        this.values = values;
    }

    void make(IList dataValues) {
        int n = dataValues.length();
        this.xvalues = new double[n];
        this.yvalues = new double[n];
        this.xyvalues = new double[n][n];
        int i = 0;
        for (IValue v : dataValues) {
            ITuple t2 = (ITuple)v;
            INumber x = (INumber)t2.get(0);
            INumber y = (INumber)t2.get(1);
            double d = x.toReal(this.values.getPrecision()).doubleValue();
            this.xyvalues[i][0] = d;
            this.xvalues[i] = d;
            double d2 = y.toReal(this.values.getPrecision()).doubleValue();
            this.xyvalues[i][0] = d2;
            this.yvalues[i] = d2;
            ++i;
        }
    }

    public IValue PearsonsCorrelation(IList dataValues) {
        this.make(dataValues);
        return this.values.real(new PearsonsCorrelation().correlation(this.xvalues, this.yvalues));
    }

    private IList RealMatrix2List(RealMatrix m4) {
        IListWriter w = this.values.listWriter();
        int n = m4.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            w.append(this.values.real(m4.getEntry(i, 0)));
        }
        return (IList)w.done();
    }

    public IValue PearsonsCorrelationStandardErrors(IList dataValues) {
        this.make(dataValues);
        RealMatrix errors = new PearsonsCorrelation(this.xyvalues).getCorrelationStandardErrors();
        return this.RealMatrix2List(errors);
    }

    public IValue PearsonsCorrelationPValues(IList dataValues) {
        this.make(dataValues);
        try {
            RealMatrix errors = new PearsonsCorrelation(this.xyvalues).getCorrelationPValues();
            return this.RealMatrix2List(errors);
        }
        catch (MathException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IValue SpearmansCorrelation(IList dataValues) {
        this.make(dataValues);
        return this.values.real(new SpearmansCorrelation().correlation(this.xvalues, this.yvalues));
    }

    public IValue covariance(IList dataValues) {
        this.make(dataValues);
        return this.values.real(new Covariance().covariance(this.xvalues, this.yvalues, false));
    }
}

