/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.csv;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.DefaultTypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.unicode.UnicodeOutputStreamWriter;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class IO {
    protected static final TypeFactory types = TypeFactory.getInstance();
    protected final IValueFactory values;
    protected final TypeReifier tr;

    public IO(IValueFactory values) {
        this.values = values;
        this.tr = new TypeReifier(values);
    }

    public IValue readCSV(ISourceLocation loc, IBool header, IString separator, IString encoding) {
        return this.read(null, loc, header, separator, encoding);
    }

    public IValue readCSV(IValue result, ISourceLocation loc, IBool header, IString separator, IString encoding) {
        return this.read(result, loc, header, separator, encoding);
    }

    public IValue getCSVType(ISourceLocation loc, IBool header, IString separator, IString encoding) {
        return this.computeType(loc, header, separator, encoding, v -> new TypeReifier(this.values).typeToValue(v.getType(), new TypeStore(new TypeStore[0]), (IMap)this.values.mapWriter().done()));
    }

    public void writeCSV(IValue schema, IValue rel, ISourceLocation loc, IBool header, IString separator, IString encoding) {
        this.writeCSV(rel, loc, header, separator, encoding, this.tr.valueToType((IConstructor)schema, new TypeStore(new TypeStore[0])));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IValue read(IValue resultTypeConstructor, ISourceLocation loc, IBool header, IString separator, IString encoding) {
        CSVReader reader = new CSVReader(header, separator);
        Type resultType = types.valueType();
        TypeStore store = new TypeStore(new TypeStore[0]);
        if (resultTypeConstructor != null && resultTypeConstructor instanceof IConstructor) {
            resultType = this.tr.valueToType((IConstructor)resultTypeConstructor, store);
        }
        Type actualType = resultType;
        while (actualType.isAliased()) {
            actualType = actualType.getAliased();
        }
        try (Reader charReader = URIResolverRegistry.getInstance().getCharacterReader(loc, encoding.getValue());){
            if (actualType.isTop()) {
                IValue iValue2 = reader.readInferAndBuild(charReader, store);
                return iValue2;
            }
            IValue iValue = reader.readAndBuild(charReader, actualType, store);
            return iValue;
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
    }

    protected IValue computeType(ISourceLocation loc, IBool header, IString separator, IString encoding, Function<IValue, IValue> valueToTypeConverter) {
        return valueToTypeConverter.apply(this.read(null, loc, header, separator, encoding));
    }

    protected void writeCSV(IValue rel, ISourceLocation loc, IBool header, IString separator, IString encoding, Type paramType) {
        String sep = separator != null ? separator.getValue() : ",";
        Boolean head = header != null ? header.getValue() : true;
        if (!rel.getType().isRelation() && !rel.getType().isListRelation() || !(rel instanceof IList) && !(rel instanceof ISet)) {
            throw RuntimeExceptionFactory.illegalTypeArgument("A relation type is required instead of " + paramType, null, null);
        }
        try (BufferedWriter out = new BufferedWriter(new UnicodeOutputStreamWriter(URIResolverRegistry.getInstance().getOutputStream(loc, false), encoding.getValue(), false));){
            int nfields;
            int n = nfields = rel instanceof IList ? ((IList)rel).asRelation().arity() : ((ISet)rel).asRelation().arity();
            if (head.booleanValue()) {
                for (int i = 0; i < nfields; ++i) {
                    if (i > 0) {
                        out.write(sep);
                    }
                    out.write((String)(paramType.hasFieldNames() ? paramType.getFieldName(i) : "field" + i));
                }
                ((Writer)out).write(10);
            }
            Pattern escapingNeeded = Pattern.compile("[\\n\\r\"\\x" + Integer.toHexString(separator.charAt(0)) + "]");
            for (IValue v : (ICollection)rel) {
                ITuple tup = (ITuple)v;
                boolean firstTime = true;
                for (IValue w : tup) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        out.write(sep);
                    }
                    String s2 = w.getType().isString() ? ((IString)w).getValue() : w.toString();
                    if (escapingNeeded.matcher(s2).find()) {
                        s2 = s2.replaceAll("\"", "\"\"");
                        ((Writer)out).write(34);
                        out.write(s2);
                        ((Writer)out).write(34);
                        continue;
                    }
                    out.write(s2);
                }
                ((Writer)out).write(10);
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
    }

    private String normalizeLabel(String label, int pos) {
        String normalizedLabel = label.replaceAll("[^a-zA-Z0-9]+", "");
        if (!normalizedLabel.isEmpty()) {
            return normalizedLabel;
        }
        return "field" + pos;
    }

    protected class CSVReader {
        private final StandardTextReader pdbReader;
        private final int separator;
        private final boolean header;

        public CSVReader(IBool header, IString separator) {
            this.separator = separator == null ? 44 : separator.charAt(0);
            this.header = header == null ? true : header.getValue();
            this.pdbReader = new StandardTextReader();
        }

        private String[] readFirstRecord(FieldReader reader) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            if (reader.hasRecord()) {
                while (reader.hasField()) {
                    result.add(reader.getField());
                }
                return result.toArray(new String[0]);
            }
            return new String[0];
        }

        private void collectFields(FieldReader reader, String[] currentRecord, int currentRecordCount) throws IOException {
            int recordIndex = 0;
            while (reader.hasField()) {
                if (recordIndex < currentRecord.length) {
                    currentRecord[recordIndex++] = reader.getField();
                    continue;
                }
                ++recordIndex;
            }
            if (recordIndex != currentRecord.length) {
                throw RuntimeExceptionFactory.illegalTypeArgument("Arities of actual type and requested type are different (expected: " + currentRecord.length + ", found: " + recordIndex + ") at record: " + currentRecordCount, null, null);
            }
        }

        private IValue readInferAndBuild(Reader stream, TypeStore store) throws IOException {
            FieldReader reader = new FieldReader(stream, this.separator);
            boolean first = this.header;
            String[] currentRecord = this.readFirstRecord(reader);
            String[] labels = new String[currentRecord.length];
            for (int l = 0; l < labels.length; ++l) {
                labels[l] = this.header ? IO.this.normalizeLabel(currentRecord[l], l) : "field" + l;
            }
            Object[] expectedTypes = new Type[currentRecord.length];
            Arrays.fill(expectedTypes, types.valueType());
            Object[] currentTypes = new Type[currentRecord.length];
            Arrays.fill(currentTypes, types.voidType());
            LinkedList<IValue[]> records = new LinkedList<IValue[]>();
            int currentRecordCount = 1;
            do {
                if (first) {
                    first = false;
                    continue;
                }
                this.collectFields(reader, currentRecord, currentRecordCount++);
                IValue[] tuple = new IValue[currentRecord.length];
                this.parseRecordFields(currentRecord, (Type[])expectedTypes, store, tuple, false);
                records.add(tuple);
                for (int i = 0; i < currentTypes.length; ++i) {
                    if (tuple[i] == null) continue;
                    currentTypes[i] = ((Type)currentTypes[i]).lub(tuple[i].getType());
                    if (!((Type)currentTypes[i]).isTop()) continue;
                    currentTypes[i] = types.stringType();
                }
            } while (reader.hasRecord());
            for (int i = 0; i < currentTypes.length; ++i) {
                if (!((Type)currentTypes[i]).isBottom()) continue;
                currentTypes[i] = types.stringType();
            }
            Type tupleType = types.tupleType((Type[])currentTypes, labels);
            ISetWriter result = IO.this.values.setWriter();
            for (IValue[] rec : records) {
                result.insert(this.createTuple(tupleType, rec));
            }
            return result.done();
        }

        private IValue createTuple(Type tupleType, IValue[] rec) {
            for (int i = 0; i < rec.length; ++i) {
                if (rec[i] == null) {
                    rec[i] = this.defaultValue(tupleType.getFieldType(i));
                    continue;
                }
                if (!tupleType.getFieldType(i).isString() || rec[i].getType().isString()) continue;
                rec[i] = IO.this.values.string(rec[i].toString());
            }
            return IO.this.values.tuple(rec);
        }

        private IValue readAndBuild(Reader stream, Type actualType, TypeStore store) throws IOException {
            FieldReader reader = new FieldReader(stream, this.separator);
            IWriter<IList> result = actualType.isListRelation() ? IO.this.values.listWriter() : IO.this.values.setWriter();
            boolean first = this.header;
            Type tupleType = actualType.getElementType();
            Type[] expectedTypes = new Type[tupleType.getArity()];
            for (int i = 0; i < expectedTypes.length; ++i) {
                expectedTypes[i] = tupleType.getFieldType(i);
            }
            int currentRecordCount = 1;
            String[] currentRecord = new String[expectedTypes.length];
            IValue[] tuple = new IValue[expectedTypes.length];
            while (reader.hasRecord()) {
                this.collectFields(reader, currentRecord, currentRecordCount++);
                if (first) {
                    first = false;
                    continue;
                }
                this.parseRecordFields(currentRecord, expectedTypes, store, tuple, true);
                if (result instanceof IListWriter) {
                    ((IListWriter)result).append(IO.this.values.tuple(tuple));
                    continue;
                }
                result.insert(IO.this.values.tuple(tuple));
            }
            return result.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseRecordFields(String[] fields, Type[] expectedTypes, TypeStore store, IValue[] result, boolean replaceEmpty) throws IOException {
            for (int i = 0; i < fields.length; ++i) {
                final String field = fields[i];
                final Type currentType = expectedTypes[i];
                if (field.isEmpty()) {
                    if (replaceEmpty) {
                        result[i] = this.defaultValue(currentType);
                        continue;
                    }
                    result[i] = null;
                    continue;
                }
                result[i] = currentType.accept(new DefaultTypeVisitor<IValue, RuntimeException>((IValue)null){

                    @Override
                    public IValue visitString(Type type) throws RuntimeException {
                        return IO.this.values.string(field);
                    }

                    @Override
                    public IValue visitInteger(Type type) throws RuntimeException {
                        try {
                            return IO.this.values.integer(field);
                        }
                        catch (NumberFormatException nfe) {
                            throw RuntimeExceptionFactory.illegalTypeArgument(currentType.toString(), null, null, "Invalid int \"" + field + "\" for requested field " + currentType);
                        }
                    }

                    @Override
                    public IValue visitReal(Type type) throws RuntimeException {
                        try {
                            return IO.this.values.real(field);
                        }
                        catch (NumberFormatException nfe) {
                            throw RuntimeExceptionFactory.illegalTypeArgument("Invalid real \"" + field + "\" for requested field " + currentType, null, null);
                        }
                    }

                    @Override
                    public IValue visitBool(Type type) throws RuntimeException {
                        if (field.equalsIgnoreCase("true")) {
                            return IO.this.values.bool(true);
                        }
                        if (field.equalsIgnoreCase("false")) {
                            return IO.this.values.bool(false);
                        }
                        throw RuntimeExceptionFactory.illegalTypeArgument("Invalid bool \"" + field + "\" for requested field " + currentType, null, null);
                    }
                });
                if (result[i] != null) continue;
                try (StringReader in = new StringReader(field);){
                    result[i] = this.pdbReader.read(IO.this.values, store, currentType, in);
                    if (!currentType.isTop() || !result[i].getType().isString()) continue;
                    result[i] = IO.this.values.string(field);
                    continue;
                }
            }
        }

        private IValue defaultValue(Type targetType) {
            IValue result = targetType.accept(new DefaultTypeVisitor<IValue, RuntimeException>(null){

                @Override
                public IValue visitBool(Type type) throws RuntimeException {
                    return IO.this.values.bool(false);
                }

                @Override
                public IValue visitDateTime(Type type) throws RuntimeException {
                    return IO.this.values.datetime(-1L);
                }

                @Override
                public IValue visitInteger(Type type) throws RuntimeException {
                    return IO.this.values.integer(0);
                }

                @Override
                public IValue visitList(Type type) throws RuntimeException {
                    return IO.this.values.list(new IValue[0]);
                }

                @Override
                public IValue visitMap(Type type) throws RuntimeException {
                    return IO.this.values.mapWriter().done();
                }

                @Override
                public IValue visitNumber(Type type) throws RuntimeException {
                    return IO.this.values.integer(0);
                }

                @Override
                public IValue visitRational(Type type) throws RuntimeException {
                    return IO.this.values.rational(0, 1);
                }

                @Override
                public IValue visitReal(Type type) throws RuntimeException {
                    return IO.this.values.real(0.0);
                }

                @Override
                public IValue visitSet(Type type) throws RuntimeException {
                    return IO.this.values.set(new IValue[0]);
                }

                @Override
                public IValue visitSourceLocation(Type type) throws RuntimeException {
                    return URIUtil.unknownLocation();
                }

                @Override
                public IValue visitString(Type type) throws RuntimeException {
                    return IO.this.values.string("");
                }

                @Override
                public IValue visitTuple(Type type) throws RuntimeException {
                    IValue[] elems = new IValue[type.getArity()];
                    for (int i = 0; i < elems.length; ++i) {
                        elems[i] = type.getFieldType(i).accept(this);
                        if (elems[i] != null) continue;
                        return null;
                    }
                    return IO.this.values.tuple(elems);
                }

                @Override
                public IValue visitValue(Type type) throws RuntimeException {
                    return IO.this.values.string("");
                }
            });
            if (result != null) {
                return result;
            }
            throw RuntimeExceptionFactory.illegalTypeArgument("Cannot create a default value for an empty field of type " + targetType, null, null);
        }

        private class FieldReader {
            int lastChar = 59;
            int separator = 59;
            Reader in;
            boolean startOfLine = true;

            FieldReader(Reader reader, int sep) throws IOException {
                this.in = reader;
                this.separator = sep;
                this.startOfLine = true;
                this.lastChar = reader.read();
            }

            private boolean isEOL(int c) {
                return c == 10 || c == 13;
            }

            boolean hasField() throws IOException {
                if (this.startOfLine) {
                    return true;
                }
                if (this.lastChar == this.separator) {
                    this.lastChar = this.in.read();
                    return true;
                }
                return false;
            }

            boolean hasRecord() throws IOException {
                if (this.startOfLine) {
                    return true;
                }
                while (this.isEOL(this.lastChar)) {
                    this.lastChar = this.in.read();
                }
                this.startOfLine = true;
                return this.lastChar != -1;
            }

            String getField() throws IOException {
                this.startOfLine = false;
                StringWriter sw = new StringWriter();
                if (this.lastChar == 34) {
                    this.lastChar = this.in.read();
                    while (this.lastChar != -1) {
                        if (this.lastChar == 34) {
                            this.lastChar = this.in.read();
                            if (this.lastChar != 34) break;
                            sw.append('\"');
                            this.lastChar = this.in.read();
                            continue;
                        }
                        sw.append((char)this.lastChar);
                        this.lastChar = this.in.read();
                    }
                    assert (this.lastChar == this.separator || this.isEOL(this.lastChar) || this.lastChar == -1);
                    return sw.toString();
                }
                while (this.lastChar != -1 && this.lastChar != this.separator && !this.isEOL(this.lastChar)) {
                    sw.append((char)this.lastChar);
                    this.lastChar = this.in.read();
                }
                return sw.toString();
            }
        }
    }
}

