/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.resource.jdbc;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.library.resource.jdbc.DriverShim;
import org.rascalmpl.values.ValueFactoryFactory;

public class JDBC {
    private static TypeFactory TF = TypeFactory.getInstance();
    public static final TypeStore TS = new TypeStore(new TypeStore[0]);
    public static final Type Connection = TF.abstractDataType(TS, "Connection", new Type[0]);
    public static final Type jdbcConnection = TF.constructor(TS, Connection, "jdbcConnection", TF.integerType(), "id");
    public static final Type JDBCType = TF.abstractDataType(TS, "JDBCType", new Type[0]);
    public static final Type jdbcArray = TF.constructor(TS, JDBCType, "array", new Type[0]);
    public static final Type jdbcBigInt = TF.constructor(TS, JDBCType, "bigInt", new Type[0]);
    public static final Type jdbcBinary = TF.constructor(TS, JDBCType, "binary", new Type[0]);
    public static final Type jdbcBit = TF.constructor(TS, JDBCType, "bit", new Type[0]);
    public static final Type jdbcBlob = TF.constructor(TS, JDBCType, "blob", new Type[0]);
    public static final Type jdbcBoolean = TF.constructor(TS, JDBCType, "boolean", new Type[0]);
    public static final Type jdbcChar = TF.constructor(TS, JDBCType, "char", new Type[0]);
    public static final Type jdbcClob = TF.constructor(TS, JDBCType, "clob", new Type[0]);
    public static final Type jdbcDataLink = TF.constructor(TS, JDBCType, "dataLink", new Type[0]);
    public static final Type jdbcDate = TF.constructor(TS, JDBCType, "date", new Type[0]);
    public static final Type jdbcDecimal = TF.constructor(TS, JDBCType, "decimal", new Type[0]);
    public static final Type jdbcDistinct = TF.constructor(TS, JDBCType, "distinct", new Type[0]);
    public static final Type jdbcDouble = TF.constructor(TS, JDBCType, "double", new Type[0]);
    public static final Type jdbcFloat = TF.constructor(TS, JDBCType, "float", new Type[0]);
    public static final Type jdbcInteger = TF.constructor(TS, JDBCType, "integer", new Type[0]);
    public static final Type jdbcJavaObject = TF.constructor(TS, JDBCType, "javaObject", new Type[0]);
    public static final Type jdbcLongNVarChar = TF.constructor(TS, JDBCType, "longNVarChar", new Type[0]);
    public static final Type jdbcLongVarBinary = TF.constructor(TS, JDBCType, "longVarBinary", new Type[0]);
    public static final Type jdbcLongVarChar = TF.constructor(TS, JDBCType, "longVarChar", new Type[0]);
    public static final Type jdbcNChar = TF.constructor(TS, JDBCType, "nChar", new Type[0]);
    public static final Type jdbcNClob = TF.constructor(TS, JDBCType, "nClob", new Type[0]);
    public static final Type jdbcNull = TF.constructor(TS, JDBCType, "null", new Type[0]);
    public static final Type jdbcNumeric = TF.constructor(TS, JDBCType, "numeric", new Type[0]);
    public static final Type jdbcNVarChar = TF.constructor(TS, JDBCType, "nVarChar", new Type[0]);
    public static final Type jdbcOther = TF.constructor(TS, JDBCType, "other", new Type[0]);
    public static final Type jdbcReal = TF.constructor(TS, JDBCType, "real", new Type[0]);
    public static final Type jdbcRef = TF.constructor(TS, JDBCType, "ref", new Type[0]);
    public static final Type jdbcRowId = TF.constructor(TS, JDBCType, "rowId", new Type[0]);
    public static final Type jdbcSmallInt = TF.constructor(TS, JDBCType, "smallInt", new Type[0]);
    public static final Type jdbcSQLXML = TF.constructor(TS, JDBCType, "sqlXML", new Type[0]);
    public static final Type jdbcStruct = TF.constructor(TS, JDBCType, "struct", new Type[0]);
    public static final Type jdbcTime = TF.constructor(TS, JDBCType, "time", new Type[0]);
    public static final Type jdbcTimeStamp = TF.constructor(TS, JDBCType, "timeStamp", new Type[0]);
    public static final Type jdbcTinyInt = TF.constructor(TS, JDBCType, "tinyInt", new Type[0]);
    public static final Type jdbcVarBinary = TF.constructor(TS, JDBCType, "varBinary", new Type[0]);
    public static final Type jdbcVarChar = TF.constructor(TS, JDBCType, "varChar", new Type[0]);
    public static final Type Column = TF.abstractDataType(TS, "Column", new Type[0]);
    public static final Type column = TF.constructor(TS, Column, "column", TF.stringType(), "columnName", JDBCType, "columnType", TF.boolType(), "nullable");
    public static final Type Table = TF.abstractDataType(TS, "Table", new Type[0]);
    public static final Type table = TF.constructor(TS, Table, "table", TF.stringType(), "tableName", TF.listType(Column), "columns");
    public static final Type nullableT = TF.parameterType("T");
    public static final Type Nullable = TF.abstractDataType(TS, "NULLable", nullableT);
    private final IValueFactory vf;
    private final ClassLoader loader;
    private int connectionCounter = 0;
    private HashMap<IInteger, Connection> connectionMap;

    public JDBC(IValueFactory vf, ClassLoader loader) {
        this.vf = vf;
        this.loader = loader;
        this.connectionMap = new HashMap();
    }

    public void registerJDBCClass(IString className) {
        Class<?> driverClass = null;
        try {
            driverClass = this.loader.loadClass(className.getValue());
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            throw RuntimeExceptionFactory.javaException(new RuntimeException("An appropriate class loader to load class " + className.getValue() + " could not be found, either this class does not exist or the jar containing this class has not been added to the classpath.", e), null, null);
        }
    }

    public IConstructor createConnection(IString connectString) {
        try {
            Connection conn = DriverManager.getConnection(connectString.getValue());
            IInteger newKey = this.vf.integer(++this.connectionCounter);
            this.connectionMap.put(newKey, conn);
            return this.vf.constructor(jdbcConnection, newKey);
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connectString, this.addMessage("Could not connect with given connect string", sqle));
        }
    }

    public void closeConnection(IConstructor connection) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (!this.connectionMap.containsKey(connectionId)) {
                throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
            }
            Connection conn = this.connectionMap.get(connectionId);
            conn.close();
            this.connectionMap.remove(connectionId);
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", sqle));
        }
    }

    public IList getTableTypes(IConstructor connection) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rs = dmd.getTableTypes();
                IListWriter resultWriter = this.vf.listWriter();
                while (rs.next()) {
                    resultWriter.append(this.vf.string(rs.getString(1)));
                }
                rs.close();
                return (IList)resultWriter.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", sqle));
        }
    }

    public ISet getTableNames(IConstructor connection) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rs = dmd.getTables(null, null, null, new String[]{"TABLE"});
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                rs.close();
                ISetWriter setRes = this.vf.setWriter();
                for (String tableName : tables) {
                    setRes.insert(this.vf.string(tableName));
                }
                return (ISet)setRes.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", sqle));
        }
    }

    public ISet getViewNames(IConstructor connection) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rs = dmd.getTables(null, null, null, new String[]{"VIEW"});
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                rs.close();
                ISetWriter setRes = this.vf.setWriter();
                for (String tableName : tables) {
                    setRes.insert(this.vf.string(tableName));
                }
                return (ISet)setRes.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", null));
        }
    }

    public ISet getTables(IConstructor connection) {
        return this.getTablesOrViews(connection, new String[]{"TABLE"});
    }

    public ISet getViews(IConstructor connection) {
        return this.getTablesOrViews(connection, new String[]{"VIEW"});
    }

    private ISet getTablesOrViews(IConstructor connection, String[] tableTypes) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rs = dmd.getTables(null, null, null, tableTypes);
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                rs.close();
                ISetWriter setRes = this.vf.setWriter();
                for (String tableName : tables) {
                    rs = dmd.getColumns(null, null, tableName, null);
                    IListWriter listRes = this.vf.listWriter();
                    while (rs.next()) {
                        String cn = rs.getString("COLUMN_NAME");
                        int dt = rs.getInt("DATA_TYPE");
                        String nullable = rs.getString("IS_NULLABLE");
                        listRes.append(this.vf.constructor(column, this.vf.string(cn), this.vf.constructor(JDBC.jdbc2rascalType(dt)), nullable.equalsIgnoreCase("YES") ? this.vf.bool(true) : this.vf.bool(false)));
                    }
                    setRes.insert(this.vf.constructor(table, new IValue[]{this.vf.string(tableName), listRes.done()}));
                    rs.close();
                }
                return (ISet)setRes.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", sqle));
        }
    }

    public IConstructor getTable(IConstructor connection, IString tableName) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                DatabaseMetaData dmd = conn.getMetaData();
                ResultSet rs = dmd.getColumns(null, null, tableName.getValue(), null);
                IListWriter listRes = this.vf.listWriter();
                while (rs.next()) {
                    String cn = rs.getString("COLUMN_NAME");
                    int dt = rs.getInt("DATA_TYPE");
                    String nullable = rs.getString("IS_NULLABLE");
                    listRes.append(this.vf.constructor(column, this.vf.string(cn), this.vf.constructor(JDBC.jdbc2rascalType(dt)), nullable.equalsIgnoreCase("YES") ? this.vf.bool(true) : this.vf.bool(false)));
                }
                rs.close();
                return this.vf.constructor(table, new IValue[]{tableName, listRes.done()});
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, this.addMessage("Could not close the given connection", sqle));
        }
    }

    private static Type jdbc2rascalType(int columnType) {
        switch (columnType) {
            case 2003: {
                return jdbcArray;
            }
            case -5: {
                return jdbcBigInt;
            }
            case -2: {
                return jdbcBinary;
            }
            case -7: {
                return jdbcBit;
            }
            case 2004: {
                return jdbcBlob;
            }
            case 16: {
                return jdbcBoolean;
            }
            case 1: {
                return jdbcChar;
            }
            case 2005: {
                return jdbcClob;
            }
            case 70: {
                return jdbcDataLink;
            }
            case 91: {
                return jdbcDate;
            }
            case 3: {
                return jdbcDecimal;
            }
            case 2001: {
                return jdbcDistinct;
            }
            case 8: {
                return jdbcDouble;
            }
            case 6: {
                return jdbcFloat;
            }
            case 4: {
                return jdbcInteger;
            }
            case 2000: {
                return jdbcJavaObject;
            }
            case -16: {
                return jdbcLongNVarChar;
            }
            case -4: {
                return jdbcLongVarBinary;
            }
            case -1: {
                return jdbcLongVarChar;
            }
            case -15: {
                return jdbcNChar;
            }
            case 2011: {
                return jdbcNClob;
            }
            case 0: {
                return jdbcNull;
            }
            case 2: {
                return jdbcNumeric;
            }
            case -9: {
                return jdbcNVarChar;
            }
            case 1111: {
                return jdbcOther;
            }
            case 7: {
                return jdbcReal;
            }
            case 2006: {
                return jdbcRef;
            }
            case -8: {
                return jdbcRowId;
            }
            case 5: {
                return jdbcSmallInt;
            }
            case 2009: {
                return jdbcSQLXML;
            }
            case 2002: {
                return jdbcStruct;
            }
            case 92: {
                return jdbcTime;
            }
            case 93: {
                return jdbcTimeStamp;
            }
            case -6: {
                return jdbcTinyInt;
            }
            case -3: {
                return jdbcVarBinary;
            }
            case 12: {
                return jdbcVarChar;
            }
        }
        throw RuntimeExceptionFactory.illegalArgument((IValue)ValueFactoryFactory.getValueFactory().integer(columnType), "Invalid JDBC type id given: " + columnType);
    }

    public static Type jdbc2pdbType(int columnType, boolean nullable) {
        Type res = null;
        switch (columnType) {
            case 2003: {
                throw new UnsupportedOperation("JDBC Array types are currently not supported", null);
            }
            case -5: {
                res = TF.integerType();
                break;
            }
            case -2: {
                res = TF.listType(TF.integerType());
                break;
            }
            case -7: {
                res = TF.boolType();
                break;
            }
            case 2004: {
                res = TF.listType(TF.integerType());
                break;
            }
            case 16: {
                res = TF.boolType();
                break;
            }
            case 1: {
                res = TF.stringType();
                break;
            }
            case 2005: {
                res = TF.stringType();
                break;
            }
            case 70: {
                throw new UnsupportedOperation("JDBC Datalink types are currently not supported", null);
            }
            case 91: {
                res = TF.dateTimeType();
                break;
            }
            case 3: {
                res = TF.realType();
                break;
            }
            case 2001: {
                throw new UnsupportedOperation("JDBC Distinct types are currently not supported", null);
            }
            case 8: {
                res = TF.realType();
                break;
            }
            case 6: {
                res = TF.realType();
                break;
            }
            case 4: {
                res = TF.integerType();
                break;
            }
            case 2000: {
                throw new UnsupportedOperation("JDBC JavaObject types are currently not supported", null);
            }
            case -16: {
                res = TF.stringType();
                break;
            }
            case -4: {
                res = TF.listType(TF.integerType());
                break;
            }
            case -1: {
                res = TF.stringType();
                break;
            }
            case -15: {
                res = TF.stringType();
                break;
            }
            case 2011: {
                res = TF.stringType();
                break;
            }
            case 0: {
                throw new UnsupportedOperation("JDBC Null types are currently not supported", null);
            }
            case 2: {
                res = TF.realType();
                break;
            }
            case -9: {
                res = TF.stringType();
                break;
            }
            case 1111: {
                throw new UnsupportedOperation("JDBC Other types are currently not supported", null);
            }
            case 7: {
                res = TF.realType();
                break;
            }
            case 2006: {
                throw new UnsupportedOperation("JDBC Ref types are currently not supported", null);
            }
            case -8: {
                throw new UnsupportedOperation("JDBC RowID types are currently not supported", null);
            }
            case 5: {
                res = TF.integerType();
                break;
            }
            case 2009: {
                throw new UnsupportedOperation("JDBC SQLXML types are currently not supported", null);
            }
            case 2002: {
                throw new UnsupportedOperation("JDBC Struct types are currently not supported", null);
            }
            case 92: {
                res = TF.dateTimeType();
                break;
            }
            case 93: {
                res = TF.dateTimeType();
                break;
            }
            case -6: {
                res = TF.integerType();
                break;
            }
            case -3: {
                res = TF.listType(TF.integerType());
                break;
            }
            case 12: {
                res = TF.stringType();
                break;
            }
            default: {
                throw new UnsupportedOperation("Unknown column type: " + columnType, null);
            }
        }
        if (nullable) {
            HashMap<Type, Type> bindings = new HashMap<Type, Type>();
            bindings.put(nullableT, res);
            res = Nullable.instantiate(bindings);
        }
        return res;
    }

    public static IValue jdbc2pdbValue(ResultSet rs, int idx, IValueFactory vf) {
        IValue res = null;
        try {
            if (idx == 0 && rs.getInt(0) == 1219) {
                System.err.println(rs.getDate(6));
            }
            int jdbcColumnType = rs.getMetaData().getColumnType(idx);
            Calendar c = Calendar.getInstance();
            IListWriter lw = null;
            InputStream isr = null;
            int isrRes = -1;
            switch (jdbcColumnType) {
                case 2003: {
                    throw new UnsupportedOperation("JDBC Array types are currently not supported", null);
                }
                case -5: {
                    if (rs.getBigDecimal(idx) != null) {
                        res = vf.integer(rs.getBigDecimal(idx).toString());
                        break;
                    }
                    res = vf.integer(0);
                    break;
                }
                case -2: {
                    isr = rs.getBinaryStream(idx);
                    lw = vf.listWriter();
                    if (isr != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case -7: {
                    res = vf.bool(rs.getBoolean(idx));
                    break;
                }
                case 2004: {
                    lw = vf.listWriter();
                    if (rs.getBlob(idx) != null && (isr = rs.getBlob(idx).getBinaryStream()) != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case 16: {
                    res = vf.bool(rs.getBoolean(idx));
                    break;
                }
                case 1: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                case 2005: {
                    lw = vf.listWriter();
                    if (rs.getClob(idx) != null && (isr = rs.getClob(idx).getAsciiStream()) != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case 70: {
                    throw new UnsupportedOperation("JDBC Datalink types are currently not supported", null);
                }
                case 91: {
                    if (rs.getDate(idx) != null) {
                        c = Calendar.getInstance();
                        c.setTimeInMillis(rs.getDate(idx).getTime());
                    }
                    res = vf.date(c.get(1), c.get(2) + 1, c.get(5));
                    break;
                }
                case 3: {
                    if (rs.getBigDecimal(idx) != null) {
                        res = vf.real(rs.getBigDecimal(idx).toString());
                        break;
                    }
                    res = vf.real(0.0);
                    break;
                }
                case 2001: {
                    throw new UnsupportedOperation("JDBC Distinct types are currently not supported", null);
                }
                case 8: {
                    res = vf.real(rs.getDouble(idx));
                    break;
                }
                case 6: {
                    res = vf.real(rs.getFloat(idx));
                    break;
                }
                case 4: {
                    res = vf.integer(rs.getInt(idx));
                    break;
                }
                case 2000: {
                    throw new UnsupportedOperation("JDBC JavaObject types are currently not supported", null);
                }
                case -16: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                case -4: {
                    lw = vf.listWriter();
                    isr = rs.getBinaryStream(idx);
                    if (isr != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case -1: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                case -15: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                case 2011: {
                    lw = vf.listWriter();
                    if (rs.getNClob(idx) != null && (isr = rs.getNClob(idx).getAsciiStream()) != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case 0: {
                    throw new UnsupportedOperation("JDBC Null types are currently not supported", null);
                }
                case 2: {
                    if (rs.getBigDecimal(idx) != null) {
                        res = vf.real(rs.getBigDecimal(idx).toString());
                        break;
                    }
                    res = vf.real(0.0);
                    break;
                }
                case -9: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                case 1111: {
                    throw new UnsupportedOperation("JDBC Other types are currently not supported", null);
                }
                case 7: {
                    res = vf.real(rs.getDouble(idx));
                    break;
                }
                case 2006: {
                    throw new UnsupportedOperation("JDBC Ref types are currently not supported", null);
                }
                case -8: {
                    throw new UnsupportedOperation("JDBC RowID types are currently not supported", null);
                }
                case 5: {
                    res = vf.integer(rs.getInt(idx));
                    break;
                }
                case 2009: {
                    throw new UnsupportedOperation("JDBC SQLXML types are currently not supported", null);
                }
                case 2002: {
                    throw new UnsupportedOperation("JDBC Struct types are currently not supported", null);
                }
                case 92: {
                    if (rs.getTime(idx) != null) {
                        c = Calendar.getInstance();
                        c.setTimeInMillis(rs.getDate(idx).getTime());
                    }
                    res = vf.time(c.get(11), c.get(12), c.get(13), c.get(14));
                    break;
                }
                case 93: {
                    if (rs.getTimestamp(idx) != null) {
                        c = Calendar.getInstance();
                        c.setTimeInMillis(rs.getDate(idx).getTime());
                    }
                    res = vf.datetime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
                    break;
                }
                case -6: {
                    res = vf.integer(rs.getInt(idx));
                    break;
                }
                case -3: {
                    lw = vf.listWriter();
                    isr = rs.getBinaryStream(idx);
                    if (isr != null) {
                        isrRes = isr.read();
                        while (isrRes != -1) {
                            lw.append(vf.integer(isrRes));
                            isrRes = isr.read();
                        }
                    }
                    res = lw.done();
                    break;
                }
                case 12: {
                    if (rs.getString(idx) != null) {
                        res = vf.string(rs.getString(idx));
                        break;
                    }
                    res = vf.string("");
                    break;
                }
                default: {
                    throw new UnsupportedOperation("Unknown column type: " + jdbcColumnType, null);
                }
            }
            if (rs.getMetaData().isNullable(idx) != 0) {
                Type resType = JDBC.jdbc2pdbType(jdbcColumnType, true);
                if (rs.wasNull()) {
                    Type nullT = TF.constructor(TS, resType, "NULL", new Type[0]);
                    res = vf.constructor(nullT);
                } else {
                    Type notnullT = TF.constructor(TS, resType, "notNULL", resType, "item");
                    res = vf.constructor(notnullT, res);
                }
            }
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public IValue loadTable(IValue resultType, IConstructor connection, IString tableName) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + tableName.getValue());
                ResultSet rs = stmt.executeQuery();
                Type elementType = resultType.getType().getTypeParameters().getFieldType(0);
                int columns = elementType.getArity();
                ISetWriter sw = this.vf.setWriter();
                while (rs.next()) {
                    IValue[] tupleValues = new IValue[columns];
                    for (int idx = 0; idx < columns; ++idx) {
                        tupleValues[idx] = JDBC.jdbc2pdbValue(rs, idx + 1, this.vf);
                    }
                    sw.insert(this.vf.tuple(tupleValues));
                }
                rs.close();
                stmt.close();
                return sw.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, sqle.getMessage());
        }
    }

    public IValue loadTable(IConstructor connection, IString tableName) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + tableName.getValue());
                ResultSet rs = stmt.executeQuery();
                ISetWriter sw = this.vf.setWriter();
                int columns = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    IValue[] tupleValues = new IValue[columns];
                    for (int idx = 0; idx < columns; ++idx) {
                        tupleValues[idx] = JDBC.jdbc2pdbValue(rs, idx + 1, this.vf);
                    }
                    sw.insert(this.vf.tuple(tupleValues));
                }
                rs.close();
                stmt.close();
                return sw.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, sqle.getMessage());
        }
    }

    public IValue loadTableOrdered(IValue resultType, IConstructor connection, IString tableName) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + tableName.getValue());
                ResultSet rs = stmt.executeQuery();
                Type elementType = resultType.getType().getTypeParameters().getFieldType(0);
                int columns = elementType.getArity();
                IListWriter lw = this.vf.listWriter();
                while (rs.next()) {
                    IValue[] tupleValues = new IValue[columns];
                    for (int idx = 0; idx < columns; ++idx) {
                        tupleValues[idx] = JDBC.jdbc2pdbValue(rs, idx + 1, this.vf);
                    }
                    lw.append(this.vf.tuple(tupleValues));
                }
                rs.close();
                stmt.close();
                return lw.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, sqle.getMessage());
        }
    }

    public IValue loadTableOrdered(IConstructor connection, IString tableName) {
        try {
            IInteger connectionId = (IInteger)connection.get(0);
            if (this.connectionMap.containsKey(connectionId)) {
                Connection conn = this.connectionMap.get(connectionId);
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM " + tableName.getValue());
                ResultSet rs = stmt.executeQuery();
                int columns = rs.getMetaData().getColumnCount();
                IListWriter lw = this.vf.listWriter();
                while (rs.next()) {
                    IValue[] tupleValues = new IValue[columns];
                    for (int idx = 0; idx < columns; ++idx) {
                        tupleValues[idx] = JDBC.jdbc2pdbValue(rs, idx + 1, this.vf);
                    }
                    lw.append(this.vf.tuple(tupleValues));
                }
                rs.close();
                stmt.close();
                return lw.done();
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, "Connection does not exist.");
        }
        catch (SQLException sqle) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)connection, sqle.getMessage());
        }
    }

    private String addMessage(String msg, SQLException sqle) {
        if (sqle.getMessage() != null) {
            return msg + ": " + sqle.getMessage();
        }
        return msg;
    }
}

