/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class Eval {
    private final IRascalValueFactory values;
    private final TypeReifier tr;
    private final TypeFactory tf = TypeFactory.getInstance();
    private final TypeStore store = new TypeStore(new TypeStore[0]);
    private final Type param = this.tf.parameterType("T");
    public final Type Result = this.tf.abstractDataType(this.store, "Result", this.param);
    public final Type TypeTyp = RascalTypeFactory.getInstance().reifiedType(this.param);
    public final Type Result_void = this.tf.constructor(this.store, this.Result, "ok", new Type[0]);
    public final Type Result_value = this.tf.constructor(this.store, this.Result, "result", this.param, "val");
    public final Type Exception = this.tf.abstractDataType(this.store, "Exception", new Type[0]);
    public final Type Exception_StaticError = this.tf.constructor(this.store, this.Exception, "StaticError", this.tf.stringType(), "messages", this.tf.sourceLocationType(), "location");
    private final Type resetType = this.tf.functionType(this.tf.voidType(), this.tf.tupleEmpty(), this.tf.tupleEmpty());
    private final Type setTimeoutType = this.tf.functionType(this.tf.voidType(), this.tf.tupleType(this.tf.integerType()), this.tf.tupleEmpty());
    private final Type evalType = this.tf.functionType(this.Result_value, this.tf.tupleType(this.TypeTyp, this.tf.stringType()), this.tf.tupleEmpty());
    private final Type staticTypeOfType = this.tf.functionType(this.TypeTyp.instantiate(Map.of(this.param, this.tf.valueType())), this.tf.tupleType(this.tf.stringType()), this.tf.tupleEmpty());
    private final Type execConstructor;
    private final PrintWriter stderr;
    private final PrintWriter stdout;
    private final Reader input;
    private final IDEServices services;

    public Eval(IRascalValueFactory values, PrintWriter out, PrintWriter err, Reader in, ClassLoader loader, IDEServices services, TypeStore ts) {
        this.values = values;
        this.tr = new TypeReifier(values);
        this.stderr = err;
        this.stdout = out;
        this.input = in;
        this.services = services;
        this.execConstructor = ts.lookupConstructor(ts.lookupAbstractDataType("RascalRuntime"), "evaluator").iterator().next();
    }

    public IConstructor createRascalRuntime(IConstructor pathConfigCons) {
        try {
            PathConfig pcfg = new PathConfig(pathConfigCons);
            RascalRuntime runtime = new RascalRuntime(pcfg, this.input, this.stderr, this.stdout, this.services);
            return this.values.constructor(this.execConstructor, pathConfigCons, this.buildResetFunction(runtime), this.buildEvalFunction(runtime), this.buildStaticTypeOfFunction(runtime), this.buildSetTimeOutFunction(runtime));
        }
        catch (IOException | URISyntaxException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    private IFunction buildResetFunction(RascalRuntime exec) {
        return this.values.function(this.resetType, (args, kwargs) -> {
            exec.reset();
            return null;
        });
    }

    private IFunction buildSetTimeOutFunction(RascalRuntime exec) {
        return this.values.function(this.setTimeoutType, (args, kwargs) -> {
            exec.setTimeout(((IInteger)args[0]).intValue());
            return null;
        });
    }

    private IFunction buildStaticTypeOfFunction(RascalRuntime exec) {
        return this.values.function(this.staticTypeOfType, (args, kwargs) -> {
            int duration = exec.getTimeoutDuration();
            EvaluatorInterruptTimer timer = new EvaluatorInterruptTimer(exec.eval, duration);
            IString command = (IString)args[0];
            if (!command.getType().isString()) {
                throw new MatchFailed();
            }
            try {
                if (duration > 0) {
                    timer.start();
                }
                IValue iValue = exec.staticTypeOf(command.getValue());
                return iValue;
            }
            catch (StaticError e) {
                throw new Throw(this.values.constructor(this.Exception_StaticError, this.values.string(e.getMessage()), e.getLocation()), null, null);
            }
            catch (InterruptException e) {
                throw RuntimeExceptionFactory.timeout(null, null);
            }
            finally {
                timer.cancel();
            }
        });
    }

    private IFunction buildEvalFunction(RascalRuntime exec) {
        return this.values.function(this.evalType, (args, kwargs) -> {
            int duration = exec.getTimeoutDuration();
            EvaluatorInterruptTimer timer = new EvaluatorInterruptTimer(exec.eval, duration);
            IConstructor expected = (IConstructor)args[0];
            if (!expected.getType().getName().equals("type")) {
                throw new MatchFailed();
            }
            IString command = (IString)args[1];
            if (!command.getType().isString()) {
                throw new MatchFailed();
            }
            try {
                if (duration > 0) {
                    timer.start();
                }
                Result<IValue> result = exec.eval(this.services, command.getValue());
                Type typ = this.tr.valueToType(expected);
                if (!result.getStaticType().isSubtypeOf(typ)) {
                    throw new UnexpectedType(typ, result.getStaticType(), URIUtil.rootLocation("eval"));
                }
                if (result.getStaticType().isBottom()) {
                    IConstructor iConstructor = this.values.constructor(this.Result_void);
                    return iConstructor;
                }
                HashMap<Type, Type> bindings = new HashMap<Type, Type>();
                bindings.put(this.param, result.getStaticType());
                IConstructor iConstructor = this.values.constructor(this.Result_value.instantiate(bindings), result.getValue());
                return iConstructor;
            }
            catch (StaticError e) {
                throw new Throw(this.values.constructor(this.Exception_StaticError, this.values.string(e.getMessage()), e.getLocation()), null, null);
            }
            catch (InterruptedException | InterruptException e) {
                throw RuntimeExceptionFactory.timeout(null, null);
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
            finally {
                timer.cancel();
            }
        });
    }

    public static class EvaluatorInterruptTimer
    extends Thread {
        private final Evaluator eval;
        private final int timeout;
        private final int sample;
        private volatile boolean running;

        public EvaluatorInterruptTimer(Evaluator eval, int timeout) {
            this.setDaemon(true);
            this.eval = eval;
            this.timeout = timeout;
            this.sample = Math.max(timeout / 10, 1);
            this.running = true;
        }

        @Override
        public void run() {
            this.running = true;
            int elapsed = 0;
            while (this.running) {
                try {
                    EvaluatorInterruptTimer.sleep(this.sample);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((elapsed += this.sample) <= this.timeout || !this.running) continue;
                this.running = false;
                this.eval.interrupt();
            }
        }

        public void cancel() {
            this.running = false;
        }
    }

    private static class RascalRuntime {
        private final Evaluator eval;
        private int duration = -1;

        public RascalRuntime(PathConfig pcfg, Reader input, PrintWriter stderr, PrintWriter stdout, IDEServices services) throws IOException, URISyntaxException {
            this.eval = ShellEvaluatorFactory.getDefaultEvaluatorForPathConfig(URIUtil.rootLocation("cwd"), pcfg, input, stdout, stderr, services);
        }

        public IValue staticTypeOf(String line) {
            Result<IValue> result = this.eval.eval(null, line, IRascalValueFactory.getInstance().sourceLocation(URIUtil.assumeCorrect("eval", "", "", "command=" + line)));
            Type type = result.getStaticType();
            return new TypeReifier(this.eval.getValueFactory()).typeToValue(type, new TypeStore(new TypeStore[0]), this.eval.getValueFactory().map());
        }

        public void setTimeout(int duration) {
            this.duration = duration;
        }

        public int getTimeoutDuration() {
            return this.duration;
        }

        public void reset() {
            this.eval.getCurrentModuleEnvironment().reset();
            this.eval.getHeap().clear();
        }

        public Result<IValue> eval(IRascalMonitor monitor, String line) throws InterruptedException, IOException {
            return this.eval.eval(monitor, line, IRascalValueFactory.getInstance().sourceLocation(URIUtil.assumeCorrect("eval", "", "", "command=" + line)));
        }
    }
}

