/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Function;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.repl.http.REPLContentServer;
import org.rascalmpl.repl.http.REPLContentServerManager;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class IDEServicesLibrary {
    private final REPLContentServerManager contentManager = new REPLContentServerManager();
    private final IDEServices services;

    public IDEServicesLibrary(IDEServices services) {
        this.services = services;
    }

    public void browse(ISourceLocation uri, IString title, IInteger viewColumn) {
        this.services.browse(uri.getURI(), title.getValue(), viewColumn.intValue());
    }

    public void edit(ISourceLocation path, IInteger viewColumn) {
        this.services.edit(path, viewColumn.intValue());
    }

    public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        return this.services.resolveProjectLocation(input);
    }

    public void registerLanguage(IConstructor language) {
        this.services.registerLanguage(language);
    }

    public void applyDocumentsEdits(IList edits) {
        this.applyFileSystemEdits(edits);
    }

    public void applyFileSystemEdits(IList edits) {
        URIResolverRegistry registry = URIResolverRegistry.getInstance();
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        edits.stream().map(IConstructor.class::cast).forEach(c -> {
            try {
                switch (c.getName()) {
                    case "removed": {
                        ISourceLocation file = (ISourceLocation)c.get("file");
                        registry.remove(file.top(), false);
                        break;
                    }
                    case "created": {
                        ISourceLocation file = (ISourceLocation)c.get("file");
                        if (registry.exists(file)) {
                            registry.setLastModified(file, System.currentTimeMillis());
                            break;
                        }
                        try (Writer out = registry.getCharacterWriter(file.top(), registry.detectCharset(file).name(), false);){
                            out.write("");
                            break;
                        }
                    }
                    case "renamed": {
                        ISourceLocation from = (ISourceLocation)c.get("from");
                        ISourceLocation to = (ISourceLocation)c.get("to");
                        registry.rename(from.top(), to.top(), true);
                        break;
                    }
                    case "changed": {
                        ISourceLocation file = (ISourceLocation)c.get("file");
                        if (c.has("edits")) {
                            IList textEdits = (IList)c.get("edits");
                            String charset = registry.detectCharset(file).name();
                            IString contents = Prelude.readFile(vf, false, ((ISourceLocation)c.get("file")).top(), charset, false);
                            for (IValue e : textEdits.reverse()) {
                                IConstructor edit = (IConstructor)e;
                                ISourceLocation range = (ISourceLocation)edit.get("range");
                                IString prefix = contents.substring(0, range.getOffset());
                                IString replacement = (IString)edit.get("replacement");
                                IString postfix = contents.substring(range.getOffset() + range.getLength());
                                contents = prefix.concat(replacement).concat(postfix);
                            }
                            try (Writer writer = registry.getCharacterWriter(file.top(), charset, false);){
                                contents.write(writer);
                                break;
                            }
                        }
                        registry.setLastModified(file, System.currentTimeMillis());
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.services.warning("Could not execute FileSystemChange due to " + e.getMessage(), URIUtil.rootLocation("unknown"));
            }
        });
    }

    public void showInteractiveContent(IConstructor provider, IString title, IInteger viewColumn) {
        try {
            Function<IValue, IValue> target;
            String id;
            if (provider.has("id")) {
                id = ((IString)provider.get("id")).getValue();
                target = r -> ((IFunction)provider.get("callback")).call((IValue)r);
            } else {
                id = "*static content*";
                target = r -> provider.get("response");
            }
            REPLContentServer contentServer = this.contentManager.addServer(id, target);
            this.browse(URIUtil.correctLocation("http", "localhost:" + contentServer.getListeningPort(), "/"), title.length() == 0 ? IRascalValueFactory.getInstance().string(id) : title, viewColumn);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public void showMessage(IConstructor message) {
        this.services.showMessage(message);
    }

    public void logMessage(IConstructor message) {
        this.services.logMessage(message);
    }

    public void registerDiagnostics(IList messages) {
        this.services.registerDiagnostics(messages);
    }

    public void unregisterDiagnostics(IList resources) {
        this.services.unregisterDiagnostics(resources);
    }
}

