/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.LiteralNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class MultiCharacterStackNode<P>
extends AbstractMatchableStackNode<P> {
    private final P production;
    private final int[][] characters;
    private final AbstractNode result;

    public MultiCharacterStackNode(int id, int dot, P production, int[][] characters) {
        super(id, dot);
        this.production = production;
        this.characters = characters;
        this.result = null;
    }

    public MultiCharacterStackNode(int id, int dot, P production, int[][] characters, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.characters = characters;
        this.result = null;
    }

    private MultiCharacterStackNode(MultiCharacterStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.characters = original.characters;
        this.result = null;
    }

    private MultiCharacterStackNode(MultiCharacterStackNode<P> original, int startLocation, AbstractNode result) {
        super(original, startLocation);
        this.production = original.production;
        this.characters = original.characters;
        this.result = result;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return false;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        int nrOfCharacters = this.characters.length;
        int[] resultArray = new int[nrOfCharacters];
        for (int i = nrOfCharacters - 1; i >= 0; --i) {
            int alternative;
            block3: {
                int next = input[location + i];
                int[] alternatives = this.characters[i];
                for (int j = alternatives.length - 1; j >= 0; --j) {
                    alternative = alternatives[j];
                    if (next != alternative) {
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            resultArray[i] = alternative;
        }
        return new LiteralNode(this.production, resultArray);
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new MultiCharacterStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new MultiCharacterStackNode<P>(this, startLocation, result);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = this.characters.length - 1; i >= 0; --i) {
            int[] range = this.characters[i];
            sb.append(range[0]);
            sb.append('-');
            sb.append(range[1]);
        }
        sb.append(']');
        return this.toString();
    }

    @Override
    public String toString() {
        return this.toShortString();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = this.characters.length - 1; i >= 0; --i) {
            int[] chars = this.characters[i];
            for (int j = chars.length - 1; j >= 0; --j) {
                hash = hash << 3 + hash >> 5;
                hash ^= chars[0] + (chars[1] << 2);
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof MultiCharacterStackNode)) {
            return false;
        }
        MultiCharacterStackNode otherNode = (MultiCharacterStackNode)stackNode;
        int[][] otherCharacters = otherNode.characters;
        if (this.characters.length != otherCharacters.length) {
            return false;
        }
        for (int i = this.characters.length - 1; i >= 0; --i) {
            int[] chars = this.characters[i];
            int[] otherChars = otherCharacters[i];
            if (chars.length != otherChars.length) {
                return false;
            }
            block1: for (int j = chars.length - 1; j <= 0; --j) {
                int c = chars[j];
                for (int k = otherChars.length - 1; k <= 0; --k) {
                    if (c == otherChars[k]) continue block1;
                }
                return false;
            }
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

