/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.IdentityHashMap;
import org.rascalmpl.tasks.IFact;
import org.rascalmpl.values.ValueFactoryFactory;

public class GraphBuilder {
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private final IdentityHashMap<Object, IValue> ids = new IdentityHashMap();
    private ISet edges = vf.set(new IValue[0]);
    private int idNum = 0;

    public ITuple getGraph() {
        ISetWriter sw = vf.setWriter();
        sw.insertAll(this.ids.values());
        return vf.tuple(new IValue[]{sw.done(), this.edges});
    }

    public IString addFact(IFact<?> fact, String name, int status) {
        if (!this.ids.containsKey(fact)) {
            String id = "fact" + this.idNum++;
            if (name == null) {
                name = id;
            }
            this.ids.put(fact, vf.tuple(vf.string(id), vf.string((String)name), vf.string(fact.toString()), vf.integer(status)));
            return vf.string(id);
        }
        return (IString)((ITuple)this.ids.get(fact)).get(0);
    }

    private IString getId(IFact<?> fact) {
        return this.addFact(fact, null, 0);
    }

    public void arrow(IFact<?> from, IFact<?> to, String type) {
        this.edges = this.edges.insert(vf.tuple(this.getId(from), this.getId(to), vf.string(type)));
    }
}

