/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.rascalmpl.uri.zip.CompressedFSTree;
import org.rascalmpl.uri.zip.EntryEnumerator;
import org.rascalmpl.uri.zip.IndexedFSEntry;

public class JarInputStreamFileTree
extends CompressedFSTree {
    public JarInputStreamFileTree(InputStream in, long created, long lastModified, long size) {
        super(new IndexedFSEntry(created, lastModified, size), JarInputStreamFileTree.openStream(in));
    }

    private static EntryEnumerator openStream(InputStream jarStream) {
        return () -> {
            final JarInputStream stream = new JarInputStream(jarStream);
            return new EntryEnumerator.CloseableIterator(){
                JarEntry next = null;

                @Override
                public void close() throws IOException {
                    stream.close();
                }

                @Override
                public boolean hasNext() throws IOException {
                    if (this.next == null) {
                        this.next = stream.getNextJarEntry();
                    }
                    return this.next != null;
                }

                @Override
                public ZipEntry next() throws IOException {
                    if (!this.hasNext()) {
                        throw new EOFException("No more entries in the stream");
                    }
                    JarEntry result = this.next;
                    this.next = null;
                    return result;
                }
            };
        };
    }
}

