/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.parsetrees;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public class ProductionAdapter {
    private ProductionAdapter() {
    }

    public static String getConstructorName(IConstructor tree) {
        IConstructor def = ProductionAdapter.getDefined(tree);
        if (SymbolAdapter.isLabel(def)) {
            return SymbolAdapter.getLabel(def);
        }
        return null;
    }

    public static IConstructor getType(IConstructor tree) {
        return SymbolAdapter.delabel(ProductionAdapter.getDefined(tree));
    }

    public static IConstructor getDefined(IConstructor tree) {
        return (IConstructor)tree.get(0);
    }

    public static IConstructor setDefined(IConstructor tree, IConstructor sym) {
        return tree.set(0, (IValue)sym);
    }

    public static IList getSymbols(IConstructor tree) {
        if (ProductionAdapter.isDefault(tree)) {
            return (IList)tree.get(1);
        }
        return null;
    }

    public static IList getASTSymbols(IConstructor tree) {
        if (ProductionAdapter.isLexical(tree)) {
            throw new ImplementationError("This is not a context-free production: " + tree);
        }
        IList children = ProductionAdapter.getSymbols(tree);
        IListWriter writer = ValueFactoryFactory.getValueFactory().listWriter();
        for (int i = 0; i < children.length(); i += 2) {
            IConstructor kid = (IConstructor)children.get(i);
            if (SymbolAdapter.isLiteral(kid) || SymbolAdapter.isCILiteral(kid)) continue;
            writer.append(kid);
        }
        return (IList)writer.done();
    }

    public static int getErrorDot(IConstructor prod) {
        if (!ProductionAdapter.isError(prod)) {
            throw new ImplementationError("This is not an error production: " + prod);
        }
        return ((IInteger)prod.get(2)).intValue();
    }

    public static IConstructor getErrorProduction(IConstructor prod) {
        if (!ProductionAdapter.isError(prod)) {
            throw new ImplementationError("This is not an error production: " + prod);
        }
        return (IConstructor)prod.get(1);
    }

    public static int getAstArgCount(IConstructor prod) {
        int count = 0;
        boolean isLayout = false;
        for (IValue child : ProductionAdapter.getSymbols(prod)) {
            if (isLayout) {
                isLayout = false;
                continue;
            }
            IConstructor symbol = SymbolAdapter.delabel((IConstructor)child);
            if (!SymbolAdapter.isLiteral(symbol) && !SymbolAdapter.isCILiteral(symbol)) {
                ++count;
            }
            isLayout = true;
        }
        return count;
    }

    public static boolean isContextFree(IConstructor tree) {
        IConstructor t2 = ProductionAdapter.getType(tree);
        return SymbolAdapter.isSort(t2) || SymbolAdapter.isParameterizedSort(t2);
    }

    public static boolean isLayout(IConstructor tree) {
        return SymbolAdapter.isLayouts(ProductionAdapter.getType(tree));
    }

    public static String getSortName(IConstructor tree) {
        IConstructor rhs = ProductionAdapter.getType(tree);
        if (SymbolAdapter.isSort(rhs) || SymbolAdapter.isLex(rhs) || SymbolAdapter.isLayouts(rhs) || SymbolAdapter.isParameterizedSort(rhs) || SymbolAdapter.isKeyword(rhs)) {
            return SymbolAdapter.getName(rhs);
        }
        return "";
    }

    public static ISet getAttributes(IConstructor tree) {
        if (ProductionAdapter.isDefault(tree)) {
            return (ISet)tree.get(2);
        }
        return ValueFactoryFactory.getValueFactory().set(new IValue[0]);
    }

    public static boolean isLiteral(IConstructor tree) {
        return SymbolAdapter.isLiteral(ProductionAdapter.getType(tree));
    }

    public static boolean isCILiteral(IConstructor tree) {
        return SymbolAdapter.isCILiteral(ProductionAdapter.getType(tree));
    }

    public static boolean isList(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Regular && SymbolAdapter.isAnyList(ProductionAdapter.getType(tree));
    }

    public static boolean isOpt(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Regular && SymbolAdapter.isOpt(ProductionAdapter.getType(tree));
    }

    public static boolean isDefault(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Default;
    }

    public static boolean isRegular(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Regular;
    }

    public static boolean isSkipped(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Skipped;
    }

    public static boolean isError(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Production_Error;
    }

    public static boolean isSeparatedList(IConstructor tree) {
        IConstructor rhs = ProductionAdapter.getType(tree);
        return SymbolAdapter.isIterPlusSeps(rhs) || SymbolAdapter.isIterStarSeps(rhs);
    }

    public static boolean isLexical(IConstructor tree) {
        return SymbolAdapter.isLex(ProductionAdapter.getType(tree));
    }

    public static boolean isSort(IConstructor tree) {
        return SymbolAdapter.isSort(ProductionAdapter.getType(tree));
    }

    public static boolean isKeyword(IConstructor tree) {
        return SymbolAdapter.isKeyword(ProductionAdapter.getType(tree));
    }

    public static String getCategory(IConstructor tree) {
        return ProductionAdapter.getTagValue(tree, "category");
    }

    public static String getTagValue(IConstructor tree, String name) {
        if (!ProductionAdapter.isRegular(tree)) {
            for (IValue attr : ProductionAdapter.getAttributes(tree)) {
                IValue value;
                if (!attr.getType().isAbstractData() || ((IConstructor)attr).getConstructorType() != RascalValueFactory.Attr_Tag || !(value = ((IConstructor)attr).get("tag")).getType().isNode() || !((INode)value).getName().equals(name)) continue;
                return ((IString)((INode)value).get(0)).getValue();
            }
        }
        return null;
    }

    public static IConstructor getTree(IConstructor tree) {
        return tree;
    }

    public static boolean hasAttribute(IConstructor tree, IValue wanted) {
        return ProductionAdapter.getAttributes(tree).contains(wanted);
    }

    public static boolean shouldFlatten(IConstructor surrounding, IConstructor nested) {
        if (ProductionAdapter.isList(nested)) {
            IConstructor nestedRhs = ProductionAdapter.getType(nested);
            IConstructor surroundingRhs = ProductionAdapter.getType(surrounding);
            if (SymbolAdapter.isEqual(surroundingRhs, nestedRhs)) {
                return true;
            }
            if (SymbolAdapter.isIterPlus(surroundingRhs) && SymbolAdapter.isIterStar(nestedRhs) || SymbolAdapter.isIterStar(surroundingRhs) && SymbolAdapter.isIterPlus(nestedRhs)) {
                return SymbolAdapter.isEqual(SymbolAdapter.getSymbol(surroundingRhs), SymbolAdapter.getSymbol(nestedRhs)) && SymbolAdapter.isEqual(SymbolAdapter.getSeparators(surroundingRhs), SymbolAdapter.getSeparators(nestedRhs));
            }
            if (SymbolAdapter.isIterPlusSeps(surroundingRhs) && SymbolAdapter.isIterStarSeps(nestedRhs) || SymbolAdapter.isIterStarSeps(surroundingRhs) && SymbolAdapter.isIterPlusSeps(nestedRhs)) {
                return SymbolAdapter.isEqual(SymbolAdapter.getSymbol(surroundingRhs), SymbolAdapter.getSymbol(nestedRhs)) && SymbolAdapter.isEqual(SymbolAdapter.getSeparators(surroundingRhs), SymbolAdapter.getSeparators(nestedRhs));
            }
        }
        return false;
    }
}

