/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.util;

import engineering.swat.watch.impl.util.ISubscribable;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class BundledSubscription<Key, Event>
implements ISubscribable<Key, Event> {
    private static final Logger logger = LogManager.getLogger();
    private final ISubscribable<Key, Event> wrapped;
    private final ConcurrentMap<Key, Subscription<Event>> subscriptions = new ConcurrentHashMap<Key, Subscription<Event>>();

    public BundledSubscription(ISubscribable<Key, Event> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Closeable subscribe(Key target, Consumer<Event> eventListener) throws IOException {
        while (true) {
            Subscription active;
            Subscription subscription = active = this.subscriptions.computeIfAbsent(target, t2 -> new Subscription());
            synchronized (subscription) {
                if (!active.closed) {
                    active.add(eventListener);
                    if (active.toBeClosed != null) return () -> {
                        boolean scheduleClose = false;
                        Subscription subscription = active;
                        synchronized (subscription) {
                            active.remove(eventListener);
                            scheduleClose = !active.hasActiveConsumers() && !active.closed;
                        }
                        if (scheduleClose) {
                            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> {
                                Subscription subscription = active;
                                synchronized (subscription) {
                                    if (!active.hasActiveConsumers() && !active.closed) {
                                        active.closed = true;
                                        this.subscriptions.remove(target, active);
                                        if (active.toBeClosed != null) {
                                            try {
                                                active.toBeClosed.close();
                                            }
                                            catch (IOException e) {
                                                logger.error("Unhandled exception while closing the watcher for {} in the background", (Object)target, (Object)e);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    };
                    active.toBeClosed = this.wrapped.subscribe(target, active);
                    return () -> {
                        boolean scheduleClose = false;
                        Subscription subscription = active;
                        synchronized (subscription) {
                            active.remove(eventListener);
                            scheduleClose = !active.hasActiveConsumers() && !active.closed;
                        }
                        if (scheduleClose) {
                            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> {
                                Subscription subscription = active;
                                synchronized (subscription) {
                                    if (!active.hasActiveConsumers() && !active.closed) {
                                        active.closed = true;
                                        this.subscriptions.remove(target, active);
                                        if (active.toBeClosed != null) {
                                            try {
                                                active.toBeClosed.close();
                                            }
                                            catch (IOException e) {
                                                logger.error("Unhandled exception while closing the watcher for {} in the background", (Object)target, (Object)e);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    };
                }
            }
        }
    }

    private static class Subscription<R>
    implements Consumer<R> {
        private final List<Consumer<R>> consumers = new CopyOnWriteArrayList<Consumer<R>>();
        private volatile @MonotonicNonNull Closeable toBeClosed;
        private volatile boolean closed = false;

        Subscription() {
        }

        void add(Consumer<R> newConsumer) {
            this.consumers.add(newConsumer);
        }

        void remove(Consumer<R> existingConsumer) {
            this.consumers.remove(existingConsumer);
        }

        @Override
        public void accept(R t2) {
            for (Consumer<R> child : this.consumers) {
                child.accept(t2);
            }
        }

        boolean hasActiveConsumers() {
            return !this.consumers.isEmpty();
        }
    }
}

