/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rascalmpl.ast.DataTarget;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.MidStringChars;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.NullASTVisitor;
import org.rascalmpl.ast.PostStringChars;
import org.rascalmpl.ast.PreStringChars;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.ast.StringConstant;
import org.rascalmpl.ast.StringLiteral;
import org.rascalmpl.ast.StringMiddle;
import org.rascalmpl.ast.StringTail;
import org.rascalmpl.ast.StringTemplate;
import org.rascalmpl.interpreter.Accumulator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.StringUtils;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.semantics.dynamic.Statement;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class StringTemplateConverter {
    private static int labelCounter = 0;

    private Statement surroundWithSingleIterForLoop(ISourceLocation loc, Name label, Statement body) {
        Name dummy = (Name)ASTBuilder.make("Name", "Lexical", loc, "_");
        Expression var = (Expression)ASTBuilder.make("Expression", "QualifiedName", loc, ASTBuilder.make("QualifiedName", loc, Arrays.asList(dummy)));
        Expression truth = (Expression)ASTBuilder.make("Expression", "Literal", loc, ASTBuilder.make("Literal", "Boolean", loc, ASTBuilder.make("BooleanLiteral", "Lexical", loc, "true")));
        Expression list = (Expression)ASTBuilder.make("Expression", "List", loc, Arrays.asList(truth));
        Expression enumerator = (Expression)ASTBuilder.make("Expression", "Enumerator", loc, var, list);
        Statement stat = (Statement)ASTBuilder.make("Statement", "For", loc, ASTBuilder.make("Label", "Default", loc, label), Arrays.asList(enumerator), body);
        return stat;
    }

    public Statement convert(StringLiteral str) {
        Name label = (Name)ASTBuilder.make("Name", "Lexical", str.getLocation(), "#" + labelCounter);
        ++labelCounter;
        Statement stat = str.accept(new Visitor(label));
        return this.surroundWithSingleIterForLoop(str.getLocation(), label, stat);
    }

    private static class Visitor
    extends NullASTVisitor<Statement> {
        private final Name label;

        public Visitor(Name label) {
            this.label = label;
        }

        private Statement makeBlock(ISourceLocation src, Statement ... stats) {
            return this.makeBlock(src, Arrays.asList(stats));
        }

        private Statement makeBlock(ISourceLocation loc, List<Statement> stats) {
            return (Statement)ASTBuilder.make("Statement", "NonEmptyBlock", loc, ASTBuilder.make("Label", "Empty", loc, new Object[0]), stats);
        }

        private Statement makeConstAppend(ISourceLocation tree, String str) {
            return new ConstAppend(tree, null, (DataTarget)ASTBuilder.make("DataTarget", "Labeled", tree, this.label), str);
        }

        private Statement makePostAppend(ISourceLocation tree, String str) {
            return new PostAppend(tree, null, (DataTarget)ASTBuilder.make("DataTarget", "Labeled", tree, this.label), str);
        }

        private Statement makePreAppend(ISourceLocation tree, String str) {
            return new PreAppend(tree, null, (DataTarget)ASTBuilder.make("DataTarget", "Labeled", tree, this.label), str);
        }

        private Statement makeMidAppend(ISourceLocation tree, String str) {
            return new MidAppend(tree, null, (DataTarget)ASTBuilder.make("DataTarget", "Labeled", tree, this.label), str);
        }

        private Statement makeIndentingAppend(Expression exp) {
            ISourceLocation loc = exp.getLocation();
            return new IndentingAppend(exp.getLocation(), null, (DataTarget)ASTBuilder.make("DataTarget", "Labeled", loc, this.label), (Statement)ASTBuilder.make("Statement", "Expression", loc, exp));
        }

        private Statement combinePreBodyPost(ISourceLocation src, List<Statement> pre, Statement body, List<Statement> post) {
            ArrayList<Statement> stats = new ArrayList<Statement>();
            stats.addAll(pre);
            stats.add(body);
            stats.addAll(post);
            return this.makeBlock(src, stats);
        }

        @Override
        public Statement visitStringLiteralInterpolated(StringLiteral.Interpolated x) {
            Statement pre = x.getPre().accept(this);
            Statement exp = this.makeIndentingAppend(x.getExpression());
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), pre, exp, tail);
        }

        @Override
        public Statement visitStringLiteralNonInterpolated(StringLiteral.NonInterpolated x) {
            return this.makeConstAppend(x.getLocation(), ((StringConstant.Lexical)x.getConstant()).getString());
        }

        @Override
        public Statement visitStringLiteralTemplate(StringLiteral.Template x) {
            Statement pre = x.getPre().accept(this);
            Statement template = x.getTemplate().accept(this);
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), pre, template, tail);
        }

        @Override
        public Statement visitStringTemplateDoWhile(StringTemplate.DoWhile x) {
            Statement body = x.getBody().accept(this);
            return ASTBuilder.makeStat("DoWhile", x.getLocation(), ASTBuilder.make("Label", "Empty", x.getLocation(), new Object[0]), this.combinePreBodyPost(x.getLocation(), x.getPreStats(), body, x.getPostStats()), x.getCondition());
        }

        @Override
        public Statement visitStringTemplateFor(StringTemplate.For x) {
            Statement body = x.getBody().accept(this);
            return ASTBuilder.makeStat("For", x.getLocation(), ASTBuilder.make("Label", "Empty", x.getLocation(), new Object[0]), x.getGenerators(), this.combinePreBodyPost(x.getLocation(), x.getPreStats(), body, x.getPostStats()));
        }

        @Override
        public Statement visitStringTemplateIfThen(StringTemplate.IfThen x) {
            Statement body = x.getBody().accept(this);
            return ASTBuilder.makeStat("IfThen", x.getLocation(), ASTBuilder.make("Label", "Empty", x.getLocation(), new Object[0]), x.getConditions(), this.combinePreBodyPost(x.getLocation(), x.getPreStats(), body, x.getPostStats()));
        }

        @Override
        public Statement visitStringTemplateIfThenElse(StringTemplate.IfThenElse x) {
            Statement t2 = x.getThenString().accept(this);
            Statement e = x.getElseString().accept(this);
            return ASTBuilder.makeStat("IfThenElse", x.getLocation(), ASTBuilder.make("Label", "Empty", x.getLocation(), new Object[0]), x.getConditions(), this.combinePreBodyPost(x.getLocation(), x.getPreStatsThen(), t2, x.getPostStatsThen()), this.combinePreBodyPost(x.getLocation(), x.getPreStatsElse(), e, x.getPostStatsElse()));
        }

        @Override
        public Statement visitStringTemplateWhile(StringTemplate.While x) {
            Statement body = x.getBody().accept(this);
            return ASTBuilder.makeStat("While", x.getLocation(), ASTBuilder.make("Label", "Empty", x.getLocation(), new Object[0]), Collections.singletonList(x.getCondition()), this.combinePreBodyPost(x.getLocation(), x.getPreStats(), body, x.getPostStats()));
        }

        @Override
        public Statement visitStringMiddleInterpolated(StringMiddle.Interpolated x) {
            Statement mid = x.getMid().accept(this);
            Statement exp = this.makeIndentingAppend(x.getExpression());
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), mid, exp, tail);
        }

        @Override
        public Statement visitStringMiddleTemplate(StringMiddle.Template x) {
            Statement mid = x.getMid().accept(this);
            Statement tmp = x.getTemplate().accept(this);
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), mid, tmp, tail);
        }

        @Override
        public Statement visitStringMiddleMid(StringMiddle.Mid x) {
            return x.getMid().accept(this);
        }

        @Override
        public Statement visitMidStringCharsLexical(MidStringChars.Lexical x) {
            return this.makeMidAppend(x.getLocation(), x.getString());
        }

        @Override
        public Statement visitPreStringCharsLexical(PreStringChars.Lexical x) {
            return this.makePreAppend(x.getLocation(), x.getString());
        }

        @Override
        public Statement visitPostStringCharsLexical(PostStringChars.Lexical x) {
            return this.makePostAppend(x.getLocation(), x.getString());
        }

        @Override
        public Statement visitStringTailMidInterpolated(StringTail.MidInterpolated x) {
            Statement mid = x.getMid().accept(this);
            Statement exp = this.makeIndentingAppend(x.getExpression());
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), mid, exp, tail);
        }

        @Override
        public Statement visitStringConstantLexical(StringConstant.Lexical x) {
            return this.makeConstAppend(x.getLocation(), x.getString());
        }

        @Override
        public Statement visitStringTailMidTemplate(StringTail.MidTemplate x) {
            Statement mid = x.getMid().accept(this);
            Statement template = x.getTemplate().accept(this);
            Statement tail = x.getTail().accept(this);
            return this.makeBlock(x.getLocation(), mid, template, tail);
        }

        @Override
        public Statement visitStringTailPost(StringTail.Post x) {
            return x.getPost().accept(this);
        }

        private static class PostAppend
        extends ConstAppend {
            public PostAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, String arg) {
                super(__param1, tree, __param2, arg);
            }

            @Override
            public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
                __eval.unindent();
                return super.interpret(__eval);
            }
        }

        private static class MidAppend
        extends IndentingStringFragmentAppend {
            public MidAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, String arg) {
                super(__param1, tree, __param2, arg);
            }

            @Override
            public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
                __eval.unindent();
                __eval.indent(this.getIndent());
                return super.interpret(__eval);
            }
        }

        private static class PreAppend
        extends IndentingStringFragmentAppend {
            public PreAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, String arg) {
                super(__param1, tree, __param2, arg);
            }

            @Override
            public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
                __eval.indent(this.getIndent());
                return super.interpret(__eval);
            }
        }

        private static abstract class IndentingStringFragmentAppend
        extends ConstAppend {
            private static final Pattern INDENT = Pattern.compile("(?<![\\\\])'([ \t]*)([^']*)$");
            private IString indent;

            public IndentingStringFragmentAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, String arg) {
                super(__param1, tree, __param2, arg);
            }

            @Override
            protected IString initString(IString arg) {
                this.indent = this.computeIndent(arg);
                return super.initString(arg);
            }

            private IString computeIndent(IString arg) {
                Matcher m4 = INDENT.matcher(arg.getValue());
                if (m4.find()) {
                    return VF.string(m4.group(1) + this.replaceEverythingBySpace(m4.group(2)));
                }
                return VF.string("");
            }

            private String replaceEverythingBySpace(String input) {
                StringBuilder sb = new StringBuilder();
                IString is = VF.string(input);
                for (int i = 0; i < is.length(); ++i) {
                    int ch = is.charAt(i);
                    if (ch != 32 && ch != 9) {
                        sb.append(' ');
                        continue;
                    }
                    sb.appendCodePoint(ch);
                }
                return sb.toString();
            }

            protected IString getIndent() {
                return this.indent;
            }
        }

        private static class ConstAppend
        extends Statement.Append {
            protected final IString str;

            public ConstAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, String arg) {
                super(__param1, tree, __param2, new Statement.EmptyStatement(__param1, tree));
                this.str = this.initString(this.preprocess(arg));
            }

            protected IString initString(IString preprocessedString) {
                return this.removeMargins(preprocessedString);
            }

            private IString removeMargins(IString s2) {
                boolean atBeginning = false;
                StringBuffer buf = new StringBuffer();
                StringBuilder sb = new StringBuilder(s2.length());
                PrimitiveIterator.OfInt ofInt = s2.iterator();
                while (ofInt.hasNext()) {
                    int ch = (Integer)ofInt.next();
                    if (atBeginning && (ch == 32 || ch == 9)) {
                        buf.appendCodePoint(ch);
                        continue;
                    }
                    if (atBeginning && ch == 39) {
                        buf = new StringBuffer();
                        atBeginning = false;
                        continue;
                    }
                    if (ch == 10) {
                        sb.append(buf);
                        buf = new StringBuffer();
                        atBeginning = true;
                        sb.appendCodePoint(ch);
                        continue;
                    }
                    if (atBeginning) {
                        sb.append(buf);
                        buf = new StringBuffer();
                        sb.appendCodePoint(ch);
                        atBeginning = false;
                        continue;
                    }
                    sb.appendCodePoint(ch);
                }
                sb.append(buf.toString());
                String jstr = sb.toString();
                return VF.string(StringUtils.unescapeSingleQuoteAndBackslash(jstr));
            }

            private IString preprocess(String arg) {
                arg = StringUtils.unquote(arg);
                arg = StringUtils.unescapeBase(arg);
                return VF.string(arg);
            }

            @Override
            public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
                Result<IValue> result = ResultFactory.makeResult(this.str.getType(), this.str, __eval);
                this.getTarget(__eval).appendString(this.str);
                return result;
            }
        }

        private class IndentingAppend
        extends Statement.Append {
            public IndentingAppend(ISourceLocation __param1, IConstructor tree, DataTarget __param2, Statement __param3) {
                super(__param1, tree, __param2, __param3);
            }

            @Override
            public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
                Accumulator target = this.getTarget(__eval);
                Result<IValue> result = this.getStatement().interpret(__eval);
                IValueFactory vf = ValueFactoryFactory.getValueFactory();
                IValue v = result.getValue();
                if (!(v instanceof IString)) {
                    StringBuilder sb = new StringBuilder(500);
                    this.appendToString(v, sb);
                    v = vf.string(sb.toString());
                }
                IString fill = __eval.getCurrentIndent();
                IString content = (IString)v;
                target.appendString(content.indent(fill, false));
                return result;
            }

            private void appendToString(IValue value, StringBuilder b) {
                if (value.getType().isSubtypeOf(RascalValueFactory.Tree)) {
                    b.append(TreeAdapter.yield((IConstructor)value));
                } else if (value.getType().isSubtypeOf(RascalValueFactory.Type)) {
                    b.append(SymbolAdapter.toString((IConstructor)((IConstructor)value).get("symbol"), false));
                } else if (value.getType().isString()) {
                    b.append((IString)value);
                } else {
                    b.append(value.toString());
                }
            }
        }
    }
}

