/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.CollectionResult;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.ListResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;

public class ListOrRelationResult<T extends IList>
extends CollectionResult<T> {
    ListOrRelationResult(Type type, T value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> slice(Result<?> first, Result<?> second, Result<?> end) {
        return super.slice(first, second, end, ((IList)this.getValue()).length());
    }

    @Override
    public Result<IValue> makeSlice(int first, int second, int end) {
        IListWriter w;
        block5: {
            w = this.getValueFactory().listWriter();
            int increment = second - first;
            if (first == end || increment == 0) break block5;
            if (first <= end) {
                if (increment == 1) {
                    return ResultFactory.makeResult(TypeFactory.getInstance().listType(this.getStaticType().getElementType()), ((IList)this.getValue()).sublist(first, end - first), this.ctx);
                }
                for (int i = first; i >= 0 && i < end; i += increment) {
                    w.append(((IList)this.getValue()).get(i));
                }
            } else {
                for (int j = first; j >= 0 && j > end && j < ((IList)this.getValue()).length(); j += increment) {
                    w.append(((IList)this.getValue()).get(j));
                }
            }
        }
        return ResultFactory.makeResult(TypeFactory.getInstance().listType(this.getStaticType().getElementType()), w.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addList(ListResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((IList)s2.getValue()).concat((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((IList)s2.getValue()).concat((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractList(ListResult s2) {
        return ResultFactory.makeResult(s2.getStaticType(), ((IList)s2.getValue()).subtract((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractListRelation(ListRelationResult s2) {
        return ResultFactory.makeResult(s2.getStaticType(), ((IList)s2.getValue()).subtract((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyListRelation(ListRelationResult that) {
        Type tupleType = this.getTypeFactory().tupleType(that.type.getElementType(), this.type.getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().lrelTypeFromTuple(tupleType), ((IList)that.getValue()).product((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyList(ListResult s2) {
        Type tupleType = this.getTypeFactory().tupleType(s2.type.getElementType(), this.type.getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().lrelTypeFromTuple(tupleType), ((IList)s2.getValue()).product((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectList(ListResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((IList)s2.getValue()).intersect((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectListRelation(ListRelationResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((IList)s2.getValue()).intersect((IList)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> insertElement(Result<V> that) {
        Type newType = this.getTypeFactory().listType(that.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((IList)this.value).insert((IValue)that.getValue()), this.ctx);
    }

    protected <U extends IValue, V extends IValue> Result<U> addElement(ElementResult<V> that) {
        Type newType = this.getTypeFactory().listType(that.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((IList)this.getValue()).append((IValue)that.getValue()), this.ctx);
    }

    protected <U extends IValue, V extends IValue> Result<U> removeElement(ElementResult<V> valueResult) {
        return ResultFactory.makeResult(this.type, ((IList)this.getValue()).delete((IValue)valueResult.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToListRelation(ListRelationResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToListRelation(ListRelationResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> equalToList(ListResult that) {
        return ResultFactory.bool(((IList)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToList(ListResult that) {
        return ResultFactory.bool(!((IList)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanList(ListResult that) {
        LessThanOrEqualResult loe = this.lessThanOrEqualList(that);
        return ResultFactory.bool(loe.getLess() && !loe.getEqual(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualList(ListResult that) {
        IList left = (IList)that.getValue();
        IList right = (IList)this.getValue();
        boolean eq = left.equals(right);
        return new LessThanOrEqualResult(left.isSubListOf(right) && !eq, eq, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanList(ListResult that) {
        return ResultFactory.bool(((IList)this.getValue()).isSubListOf((IList)that.getValue()) && !((IList)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualList(ListResult that) {
        return ResultFactory.bool(((IList)this.getValue()).isSubListOf((IList)that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanListRelation(ListRelationResult that) {
        LessThanOrEqualResult loe = this.lessThanOrEqualListRelation(that);
        return ResultFactory.bool(loe.getLess() && !loe.getEqual(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualListRelation(ListRelationResult that) {
        IList left = (IList)that.getValue();
        IList right = (IList)this.getValue();
        boolean eq = left.equals(right);
        return new LessThanOrEqualResult(left.isSubListOf(right) && !eq, eq, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanListRelation(ListRelationResult that) {
        return ResultFactory.bool(((IList)this.getValue()).isSubListOf((IList)that.getValue()) && !((IList)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualListRelation(ListRelationResult that) {
        return ResultFactory.bool(((IList)this.getValue()).isSubListOf((IList)that.getValue()), this.ctx);
    }
}

