/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.NullASTVisitor;
import org.rascalmpl.ast.Parameters;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.ast.Type;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.Accumulator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.Return;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.NamedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.MissingReturn;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedPattern;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.semantics.dynamic.Tree;

public class RascalFunction
extends NamedFunction {
    private final List<Statement> body;
    private final boolean isVoidFunction;
    private final Stack<Accumulator> accumulators;
    private final List<Expression> formals;
    private final int indexedPosition;
    private final String indexedLabel;
    private final IConstructor indexedProduction;
    private final List<KeywordFormal> initializers;

    public RascalFunction(IEvaluator<Result<IValue>> eval, FunctionDeclaration.Default func, boolean varargs, Environment env, Stack<Accumulator> accumulators) {
        this(func, eval, Names.name(func.getSignature().getName()), func.getSignature().typeOf(env, eval, false), func.getSignature().typeOf(env, eval, false).instantiate(env.getDynamicTypeBindings()), RascalFunction.getFormals(func), varargs, RascalFunction.isDefault(func), RascalFunction.hasTestMod(func.getSignature()), func.getBody().getStatements(), env, accumulators);
    }

    public RascalFunction(IEvaluator<Result<IValue>> eval, FunctionDeclaration.Expression func, boolean varargs, Environment env, Stack<Accumulator> accumulators) {
        this(func, eval, Names.name(func.getSignature().getName()), func.getSignature().typeOf(env, eval, false), func.getSignature().typeOf(env, eval, false).instantiate(env.getDynamicTypeBindings()), RascalFunction.getFormals(func), varargs, RascalFunction.isDefault(func), RascalFunction.hasTestMod(func.getSignature()), Arrays.asList(ASTBuilder.makeStat("Return", func.getLocation(), ASTBuilder.makeStat("Expression", func.getLocation(), func.getExpression()))), env, accumulators);
    }

    public RascalFunction(AbstractAST ast, IEvaluator<Result<IValue>> eval, String name, io.usethesource.vallang.type.Type staticType, io.usethesource.vallang.type.Type dynamicType, List<KeywordFormal> initializers, boolean varargs, boolean isDefault, boolean isTest, List<Statement> body, Environment env, Stack<Accumulator> accumulators) {
        super(ast, eval, staticType, dynamicType, initializers, name, varargs, isDefault, isTest, env);
        this.body = body;
        this.isVoidFunction = this.staticFunctionType.getReturnType().isSubtypeOf(TF.voidType());
        this.accumulators = (Stack)accumulators.clone();
        this.formals = this.cacheFormals();
        this.indexedPosition = this.computeIndexedPosition(ast);
        this.indexedLabel = this.computeIndexedLabel(this.indexedPosition, ast);
        this.indexedProduction = this.computeIndexedProduction(this.indexedPosition, ast);
        this.initializers = initializers;
    }

    @Override
    public RascalFunction cloneInto(Environment env) {
        AbstractAST clone = this.cloneAst();
        List<Statement> clonedBody = this.cloneBody();
        return new RascalFunction(clone, this.getEval(), this.getName(), this.getFunctionType(), this.getType(), this.initializers, this.hasVarArgs(), this.isDefault(), this.isTest(), clonedBody, env, this.accumulators);
    }

    private AbstractAST cloneAst() {
        return (AbstractAST)this.getAst().clone();
    }

    private List<Statement> cloneBody() {
        return this.getAst().clone(this.body);
    }

    private String computeIndexedLabel(final int pos, AbstractAST ast) {
        return ast.accept(new NullASTVisitor<String>(){

            @Override
            public String visitFunctionDeclarationDefault(FunctionDeclaration.Default x) {
                return this.extract(x);
            }

            @Override
            public String visitFunctionDeclarationExpression(FunctionDeclaration.Expression x) {
                return this.extract(x);
            }

            @Override
            public String visitFunctionDeclarationConditional(FunctionDeclaration.Conditional x) {
                return this.extract(x);
            }

            private String extract(FunctionDeclaration x) {
                List<Expression> formals = x.getSignature().getParameters().getFormals().getFormals();
                return this.processFormals(formals);
            }

            private String processFormals(List<Expression> formals) {
                if (formals.size() > pos) {
                    Expression first = formals.get(pos);
                    if (first.isAsType()) {
                        first = first.getArgument();
                    } else if (first.isTypedVariableBecomes() || first.isVariableBecomes()) {
                        first = first.getPattern();
                    }
                    if (first.isCallOrTree() && first.getExpression().isQualifiedName()) {
                        return ((QualifiedName.Default)first.getExpression().getQualifiedName()).lastName();
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String getIndexedLabel() {
        return this.indexedLabel;
    }

    @Override
    public int getIndexedArgumentPosition() {
        return this.indexedPosition;
    }

    @Override
    public IConstructor getIndexedProduction() {
        return this.indexedProduction;
    }

    private List<Expression> cacheFormals() throws ImplementationError {
        Parameters params;
        if (this.ast instanceof FunctionDeclaration) {
            params = ((FunctionDeclaration)this.ast).getSignature().getParameters();
        } else if (this.ast instanceof Expression.Closure) {
            params = ((Expression.Closure)this.ast).getParameters();
        } else if (this.ast instanceof Expression.VoidClosure) {
            params = ((Expression.VoidClosure)this.ast).getParameters();
        } else {
            throw new ImplementationError("Unexpected kind of Rascal function: " + this.ast);
        }
        List<Expression> formals = params.getFormals().getFormals();
        if (params.isVarArgs() && formals.size() > 0) {
            Expression last = formals.get(formals.size() - 1);
            if (last.isTypedVariable()) {
                Type oldType = last.getType();
                ISourceLocation origin = last.getLocation();
                Type.Structured newType = (Type.Structured)ASTBuilder.make("Type", "Structured", origin, ASTBuilder.make("StructuredType", origin, ASTBuilder.make("BasicType", "List", origin, new Object[0]), Arrays.asList(ASTBuilder.make("TypeArg", "Default", origin, oldType))));
                last = (Expression)ASTBuilder.make("Expression", "TypedVariable", origin, newType, last.getName());
                formals = this.replaceLast(formals, last);
            } else if (last.isQualifiedName()) {
                ISourceLocation origin = last.getLocation();
                Type newType = (Type)ASTBuilder.make("Type", "Structured", origin, ASTBuilder.make("StructuredType", origin, ASTBuilder.make("BasicType", "List", origin, new Object[0]), Arrays.asList(ASTBuilder.make("TypeArg", origin, ASTBuilder.make("Type", "Basic", origin, ASTBuilder.make("BasicType", "Value", origin, new Object[0]))))));
                last = ASTBuilder.makeExp("TypedVariable", origin, newType, Names.lastName(last.getQualifiedName()));
                formals = this.replaceLast(formals, last);
            } else {
                throw new UnsupportedPattern("...", last);
            }
        }
        return formals;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAnonymous() {
        return this.getName() == null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Result<IValue> call(io.usethesource.vallang.type.Type[] actualStaticTypes, IValue[] actuals, Map<String, IValue> keyArgValues) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Result<IValue> runBody() {
        for (Statement stat : this.body) {
            this.eval.setCurrentAST(stat);
            stat.interpret(this.eval);
        }
        if (!this.isVoidFunction) {
            throw new MissingReturn(this.ast);
        }
        return ResultFactory.makeResult(TF.voidType(), null, this.eval);
    }

    private Result<IValue> computeReturn(Return e, Map<io.usethesource.vallang.type.Type, io.usethesource.vallang.type.Type> renamings, Map<io.usethesource.vallang.type.Type, io.usethesource.vallang.type.Type> dynamicRenamings) {
        Result<IValue> result = e.getValue();
        io.usethesource.vallang.type.Type returnType = this.getReturnType();
        if (!result.getStaticType().isSubtypeOf(this.getReturnType())) {
            throw new UnexpectedType(returnType, result.getStaticType(), e.getLocation());
        }
        if (!returnType.isBottom() && result.getStaticType().isBottom()) {
            throw new UnexpectedType(returnType, result.getStaticType(), e.getLocation());
        }
        Map<io.usethesource.vallang.type.Type, io.usethesource.vallang.type.Type> bindings = this.ctx.getCurrentEnvt().getStaticTypeBindings();
        io.usethesource.vallang.type.Type instantiatedReturnType = returnType.instantiate(bindings);
        if (instantiatedReturnType.isOpen()) {
            instantiatedReturnType = RascalFunction.unrenameType(renamings, instantiatedReturnType);
        }
        return ResultFactory.makeResult(instantiatedReturnType, result.getValue(), this.eval);
    }

    private IMatchingResult[] prepareFormals(IEvaluatorContext ctx) {
        int size = this.formals.size();
        IMatchingResult[] matchers = new IMatchingResult[size];
        for (int i = 0; i < size; ++i) {
            matchers[i] = this.formals.get(i).getMatcher(ctx, true);
        }
        return matchers;
    }

    private List<Expression> replaceLast(List<Expression> formals, Expression last) {
        ArrayList<Expression> tmp = new ArrayList<Expression>(formals.size());
        tmp.addAll(formals);
        tmp.set(formals.size() - 1, last);
        formals = tmp;
        return formals;
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToRascalFunction(this);
    }

    @Override
    public Result<IBool> equalToRascalFunction(RascalFunction that) {
        return ResultFactory.bool(this == that, this.ctx);
    }

    private IConstructor computeIndexedProduction(final int pos, AbstractAST ast) {
        return ast.accept(new NullASTVisitor<IConstructor>(){

            @Override
            public IConstructor visitFunctionDeclarationDefault(FunctionDeclaration.Default x) {
                return this.extract(x);
            }

            @Override
            public IConstructor visitFunctionDeclarationExpression(FunctionDeclaration.Expression x) {
                return this.extract(x);
            }

            @Override
            public IConstructor visitFunctionDeclarationConditional(FunctionDeclaration.Conditional x) {
                return this.extract(x);
            }

            private IConstructor extract(FunctionDeclaration x) {
                List<Expression> formals = x.getSignature().getParameters().getFormals().getFormals();
                return this.processFormals(formals);
            }

            private IConstructor processFormals(List<Expression> formals) {
                if (formals.size() > pos) {
                    Expression first = formals.get(pos);
                    if (first.isAsType()) {
                        first = first.getArgument();
                    } else if (first.isTypedVariableBecomes() || first.isVariableBecomes()) {
                        first = first.getPattern();
                    }
                    if (first instanceof Tree.Appl) {
                        Tree.Appl appl = (Tree.Appl)first;
                        return appl.getProduction();
                    }
                }
                return null;
            }
        });
    }

    @Override
    protected io.usethesource.vallang.type.Type computeVarArgsActualTypes(io.usethesource.vallang.type.Type[] actualTypes, io.usethesource.vallang.type.Type formals) {
        if (formals.getArity() == actualTypes.length && actualTypes[actualTypes.length - 1].isSubtypeOf(formals.getFieldType(formals.getArity() - 1))) {
            return TF.tupleType(actualTypes);
        }
        int arity = formals.getArity();
        io.usethesource.vallang.type.Type[] types = new io.usethesource.vallang.type.Type[arity];
        for (int i = 0; i < arity - 1; ++i) {
            types[i] = actualTypes[i];
        }
        io.usethesource.vallang.type.Type lub = TF.voidType();
        for (int j = i; j < actualTypes.length; ++j) {
            lub = lub.lub(actualTypes[j]);
        }
        types[i] = TF.listType(lub);
        return TF.tupleType(types);
    }
}

