/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import org.rascalmpl.ast.Field;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetOrRelationResult;
import org.rascalmpl.interpreter.result.SetResult;
import org.rascalmpl.interpreter.result.TupleResult;
import org.rascalmpl.interpreter.staticErrors.Arity;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.values.ValueFactoryFactory;

public class RelationResult
extends SetOrRelationResult<ISet> {
    public RelationResult(Type type, ISet rel, IEvaluatorContext ctx) {
        super(type, rel, ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        int len = this.getStaticType().getElementType().getArity();
        if (subscripts.length >= len) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), len, this.ctx.getCurrentAST());
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addRelation(this);
    }

    @Override
    public Result<IBool> has(Name name) {
        return ResultFactory.bool(this.getStaticType().hasField(Names.name(name)), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> intersect(Result<V> result) {
        return result.intersectRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanRelation(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> that) {
        return that.multiplyRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> join(Result<V> that) {
        return that.joinRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> in(Result<V> that) {
        return that.inRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> notIn(Result<V> that) {
        return that.notInRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (this.getStaticType().getElementType().isBottom()) {
            return ResultFactory.makeResult(this.getStaticType(), this.ctx.getValueFactory().set(new IValue[0]), this.ctx);
        }
        int nSubs = subscripts.length;
        if (nSubs >= this.getStaticType().getArity()) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), nSubs, this.ctx.getCurrentAST());
        }
        int relArity = this.getStaticType().getArity();
        Type[] subscriptType = new Type[nSubs];
        boolean[] subscriptIsSet = new boolean[nSubs];
        Type valueType = TypeFactory.getInstance().valueType();
        for (int i = 0; i < nSubs; ++i) {
            subscriptType[i] = subscripts[i] == null ? valueType : subscripts[i].getStaticType();
        }
        boolean yieldSet = relArity - nSubs == 1;
        Type[] resFieldType = new Type[relArity - nSubs];
        for (int i = 0; i < relArity; ++i) {
            Type relFieldType = this.getStaticType().getFieldType(i);
            if (i < nSubs) {
                if (subscriptType[i].isSet() && relFieldType.comparable(subscriptType[i].getElementType())) {
                    subscriptIsSet[i] = true;
                    continue;
                }
                if (subscripts[i] == null || relFieldType.comparable(subscriptType[i])) {
                    subscriptIsSet[i] = false;
                    continue;
                }
                throw new UnexpectedType(relFieldType, subscriptType[i], this.ctx.getCurrentAST());
            }
            resFieldType[i - nSubs] = relFieldType;
        }
        Type resultType = yieldSet ? this.getTypeFactory().setType(resFieldType[0]) : this.getTypeFactory().relType(resFieldType);
        if (nSubs == 1) {
            ISet result;
            IRelation<ISet> relation = ((ISet)this.getValue()).asRelation();
            if (subscripts[0] == null) {
                int[] restSubScripts = new int[relArity - 1];
                for (int i = 1; i < relArity; ++i) {
                    restSubScripts[i - 1] = i;
                }
                result = relation.project(restSubScripts);
            } else if (subscriptIsSet[0]) {
                ISet subScriptSet = (ISet)subscripts[0].getValue();
                if (subScriptSet.size() * 2 < relation.asContainer().size() && relArity == 2) {
                    result = this.getValueFactory().set(new IValue[0]);
                    for (IValue v : subScriptSet) {
                        result = result.union(relation.index(v));
                    }
                } else {
                    ISetWriter resultWriter = this.getValueFactory().setWriter();
                    int[] restSubScripts = new int[relArity - 1];
                    for (int i = 1; i < relArity; ++i) {
                        restSubScripts[i - 1] = i;
                    }
                    for (IValue v : relation) {
                        ITuple tup = (ITuple)v;
                        if (!subScriptSet.contains(tup.get(0))) continue;
                        resultWriter.append(tup.select(restSubScripts));
                    }
                    result = (ISet)resultWriter.done();
                }
            } else {
                result = relation.index((IValue)subscripts[0].getValue());
            }
            return ResultFactory.makeResult(resultType, result, this.ctx);
        }
        ISetWriter result = this.getValueFactory().setWriter();
        for (IValue v : (ISet)this.getValue()) {
            ITuple tup = (ITuple)v;
            boolean allEqual = true;
            for (int k = 0; k < nSubs && allEqual; ++k) {
                if (subscriptIsSet[k] && (subscripts[k] == null || ((ISet)subscripts[k].getValue()).contains(tup.get(k))) || subscripts[k] == null || tup.get(k).equals(subscripts[k].getValue())) continue;
                allEqual = false;
            }
            if (!allEqual) continue;
            if (yieldSet) {
                result.insert(tup.get(nSubs));
                continue;
            }
            IValue[] args = new IValue[relArity - nSubs];
            for (int i = nSubs; i < relArity; ++i) {
                args[i - nSubs] = tup.get(i);
            }
            result.insert(this.getValueFactory().tuple(args));
        }
        return ResultFactory.makeResult(resultType, result.done(), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((ISet)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((ISet)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> transitiveClosure() {
        if (((ISet)this.getValue()).asRelation().arity() == 0 || ((ISet)this.getValue()).asRelation().arity() == 2) {
            return ResultFactory.makeResult(this.type, ((ISet)this.getValue()).asRelation().closure(), this.ctx);
        }
        throw new Arity(2, ((ISet)this.getValue()).asRelation().arity(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue> Result<U> transitiveReflexiveClosure() {
        if (((ISet)this.getValue()).asRelation().arity() == 0 || ((ISet)this.getValue()).asRelation().arity() == 2) {
            return ResultFactory.makeResult(this.type, ((ISet)this.getValue()).asRelation().closureStar(), this.ctx);
        }
        throw new Arity(2, ((ISet)this.getValue()).asRelation().arity(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        Type tupleType = this.getStaticType().getFieldTypes();
        if (!this.getStaticType().hasFieldNames()) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        if (!this.getStaticType().hasField(name, store)) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        try {
            ISetWriter w = this.getValueFactory().setWriter();
            for (IValue e : (ISet)this.getValue()) {
                w.insert(((ITuple)e).get(tupleType.getFieldIndex(name)));
            }
            return ResultFactory.makeResult(this.getTypeFactory().setType(tupleType.getFieldType(name)), w.done(), this.ctx);
        }
        catch (UndeclaredFieldException e) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
    }

    @Override
    protected <U extends IValue> Result<U> composeRelation(RelationResult that) {
        RelationResult left = that;
        RelationResult right = this;
        Type leftrelType = left.getStaticType();
        Type rightrelType = right.getStaticType();
        int leftArity = leftrelType.getArity();
        int rightArity = rightrelType.getArity();
        if (leftArity != 0 && leftArity != 2) {
            throw new Arity(2, leftArity, this.ctx.getCurrentAST());
        }
        if (rightArity != 0 && rightArity != 2) {
            throw new Arity(2, rightArity, this.ctx.getCurrentAST());
        }
        Type resultType = leftrelType.compose(rightrelType);
        return ResultFactory.makeResult(resultType, ((ISet)left.getValue()).asRelation().compose(((ISet)right.getValue()).asRelation()), this.ctx);
    }

    <U extends IValue, V extends IValue> Result<U> insertTuple(TupleResult tuple) {
        Type newType = this.getTypeFactory().setType(tuple.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((ISet)this.getValue()).insert((IValue)tuple.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinRelation(RelationResult that) {
        int i;
        int arity1 = ((ISet)that.getValue()).asRelation().arity();
        int arity2 = ((ISet)this.getValue()).asRelation().arity();
        Type tupleType1 = that.getStaticType().getElementType();
        Type tupleType2 = this.getStaticType().getElementType();
        Type[] fieldTypes = new Type[arity1 + arity2];
        for (i = 0; i < arity1; ++i) {
            fieldTypes[i] = tupleType1.getFieldType(i);
        }
        for (i = arity1; i < arity1 + arity2; ++i) {
            fieldTypes[i] = tupleType2.getFieldType(i - arity1);
        }
        Type tupleType = this.getTypeFactory().tupleType(fieldTypes);
        ISetWriter writer = this.getValueFactory().setWriter();
        IValue[] fieldValues = new IValue[arity1 + arity2];
        for (IValue tuple1 : (ISet)that.getValue()) {
            for (IValue tuple2 : (ISet)this.getValue()) {
                int i2;
                for (i2 = 0; i2 < arity1; ++i2) {
                    fieldValues[i2] = ((ITuple)tuple1).get(i2);
                }
                for (i2 = arity1; i2 < arity1 + arity2; ++i2) {
                    fieldValues[i2] = ((ITuple)tuple2).get(i2 - arity1);
                }
                writer.insert(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().relTypeFromTuple(tupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinSet(SetResult that) {
        int arity2 = ((ISet)this.getValue()).asRelation().arity();
        Type eltType = that.getStaticType().getElementType();
        Type tupleType = this.getStaticType().getElementType();
        Type[] fieldTypes = new Type[1 + arity2];
        fieldTypes[0] = eltType;
        for (int i = 1; i < 1 + arity2; ++i) {
            fieldTypes[i] = tupleType.getFieldType(i);
        }
        Type resultTupleType = this.getTypeFactory().tupleType(fieldTypes);
        ISetWriter writer = this.getValueFactory().setWriter();
        IValue[] fieldValues = new IValue[1 + arity2];
        for (IValue setValue : (ISet)that.getValue()) {
            for (IValue relValue : (ISet)this.getValue()) {
                fieldValues[0] = setValue;
                for (int i = 1; i < 1 + arity2; ++i) {
                    fieldValues[i] = ((ITuple)relValue).get(i);
                }
                writer.insert(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().relTypeFromTuple(resultTupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    public Result<IValue> fieldSelect(int[] selectedFields) {
        if (!this.getStaticType().getElementType().isBottom()) {
            for (int i : selectedFields) {
                if (i >= 0 && i < this.getStaticType().getArity()) continue;
                throw RuntimeExceptionFactory.indexOutOfBounds(this.ctx.getValueFactory().integer(i), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
        }
        return ResultFactory.makeResult(this.type.select(selectedFields), ((ISet)this.value).asRelation().project(selectedFields), this.ctx);
    }

    @Override
    public Result<IValue> fieldSelect(Field[] selectedFields) {
        int nFields = selectedFields.length;
        int[] fieldIndices = new int[nFields];
        Type baseType = this.getStaticType();
        for (int i = 0; i < nFields; ++i) {
            Field f = selectedFields[i];
            if (f.isIndex()) {
                fieldIndices[i] = ((IInteger)f.getFieldIndex().interpret(this.ctx.getEvaluator()).getValue()).intValue();
            } else {
                String fieldName = Names.name(f.getFieldName());
                if (!baseType.hasFieldNames()) {
                    throw new UndeclaredField(fieldName, baseType, this.ctx.getCurrentAST());
                }
                try {
                    fieldIndices[i] = baseType.getFieldIndex(fieldName);
                }
                catch (UndeclaredFieldException e) {
                    throw new UndeclaredField(fieldName, baseType, this.ctx.getCurrentAST());
                }
            }
            if (fieldIndices[i] >= 0 && (fieldIndices[i] <= baseType.getArity() || this.getStaticType().getElementType().isBottom())) continue;
            throw RuntimeExceptionFactory.indexOutOfBounds(ValueFactoryFactory.getValueFactory().integer(fieldIndices[i]), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return this.fieldSelect(fieldIndices);
    }
}

