/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.java;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.rascalmpl.interpreter.utils.JavaCompiler;
import org.rascalmpl.interpreter.utils.JavaCompilerException;
import org.rascalmpl.interpreter.utils.JavaFileObjectImpl;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;

public class JavaCompilerForRascal {
    private final IValueFactory vf;

    public JavaCompilerForRascal(IValueFactory vf) {
        this.vf = vf;
    }

    public IList compileJava(ISet sourcesMap, ISourceLocation bin, IList classpath) {
        SourceLocationClassLoader cl = new SourceLocationClassLoader(classpath, System.class.getClassLoader());
        try {
            List<String> commandline = Arrays.asList("-proc:none");
            JavaCompiler javaCompiler = new JavaCompiler(cl, null, commandline);
            DiagnosticCollector<JavaFileObject> errors = new DiagnosticCollector<JavaFileObject>();
            javaCompiler.compileTo(sourcesMap, cl, bin, errors);
            return this.convertDiagnostics(errors);
        }
        catch (JavaCompilerException e) {
            return this.convertDiagnostics(e.getDiagnostics());
        }
        catch (URISyntaxException e) {
            return this.vf.list(Messages.error(e.getMessage(), URIUtil.unknownLocation()));
        }
    }

    private IList convertDiagnostics(DiagnosticCollector<JavaFileObject> errors) {
        return errors.getDiagnostics().stream().map(this::convertDiagnostic).collect(this.vf.listWriter());
    }

    private IValue convertDiagnostic(Diagnostic<? extends JavaFileObject> d) {
        ISourceLocation loc = this.convertToLoc(d);
        switch (d.getKind()) {
            case ERROR: {
                return Messages.error(d.getMessage(null), loc);
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Messages.warning(d.getMessage(null), loc);
            }
        }
        return Messages.info(d.getMessage(null), loc);
    }

    private ISourceLocation convertToLoc(Diagnostic<? extends JavaFileObject> d) {
        ISourceLocation uri = ((JavaFileObjectImpl)d.getSource()).getSloc();
        int offset = (int)d.getStartPosition();
        if (offset >= 0) {
            return this.vf.sourceLocation(uri, offset, (int)d.getEndPosition() - offset);
        }
        return uri;
    }
}

