/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.util.function.Function;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.repl.http.REPLContentServer;
import org.rascalmpl.repl.http.REPLContentServerManager;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class IDEServicesLibrary {
    private final REPLContentServerManager contentManager = new REPLContentServerManager();
    private final IDEServices services;

    public IDEServicesLibrary(IDEServices services) {
        this.services = services;
    }

    public void browse(ISourceLocation uri, IString title, IInteger viewColumn) {
        this.services.browse(uri.getURI(), title.getValue(), viewColumn.intValue());
    }

    public void edit(ISourceLocation path, IInteger viewColumn) {
        this.services.edit(path, viewColumn.intValue());
    }

    public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        return this.services.resolveProjectLocation(input);
    }

    public void registerLanguage(IConstructor language) {
        this.services.registerLanguage(language);
    }

    public void applyDocumentsEdits(IList edits) {
        this.applyFileSystemEdits(edits);
    }

    public void applyFileSystemEdits(IList edits) {
        this.services.applyFileSystemEdits(edits);
    }

    public void showInteractiveContent(IConstructor provider, IString title, IInteger viewColumn) {
        try {
            Function<IValue, IValue> target;
            String id;
            if (provider.has("id")) {
                id = ((IString)provider.get("id")).getValue();
                target = r -> ((IFunction)provider.get("callback")).call((IValue)r);
            } else {
                id = "*static content*";
                target = r -> provider.get("response");
            }
            REPLContentServer contentServer = this.contentManager.addServer(id, target);
            this.browse(URIUtil.correctLocation("http", "localhost:" + contentServer.getListeningPort(), "/"), title.length() == 0 ? IRascalValueFactory.getInstance().string(id) : title, viewColumn);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public void showMessage(IConstructor message) {
        this.services.showMessage(message);
    }

    public void logMessage(IConstructor message) {
        this.services.logMessage(message);
    }

    public void registerDiagnostics(IList messages) {
        this.services.registerDiagnostics(messages);
    }

    public void unregisterDiagnostics(IList resources) {
        this.services.unregisterDiagnostics(resources);
    }
}

