/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.load.RascalSearchPath;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.lang.rascal.syntax.RascalParser;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.library.util.ToplevelType;
import org.rascalmpl.parser.gtd.io.InputConverter;
import org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener;
import org.rascalmpl.parser.uptr.UPTRNodeFactory;
import org.rascalmpl.parser.uptr.action.NoActionExecutor;
import org.rascalmpl.repl.streams.LimitedLineWriter;
import org.rascalmpl.repl.streams.LimitedWriter;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class Reflective {
    protected final IValueFactory values;
    private final IRascalMonitor monitor;
    private RascalSearchPath resolver;
    private static final int LINE_LIMIT = 200;
    private static final int CHAR_LIMIT = 4000;

    public Reflective(IValueFactory values, IRascalMonitor monitor, RascalSearchPath resolver) {
        this.values = values;
        this.monitor = monitor;
        this.resolver = resolver;
    }

    public IString getRascalVersion() {
        return this.values.string(RascalManifest.getRascalVersionNumber());
    }

    public ISourceLocation resolveProjectOnClasspath(IString projectName) {
        try {
            return PathConfig.resolveProjectOnClasspath(projectName.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public ISourceLocation resolveModuleOnCurrentInterpreterSearchPath(IString moduleName) {
        ISourceLocation result = this.resolver.resolveModule(moduleName.getValue());
        if (result == null) {
            throw RuntimeExceptionFactory.moduleNotFound(moduleName);
        }
        return result;
    }

    public IString getLineSeparator() {
        return this.values.string(System.lineSeparator());
    }

    public IConstructor getProjectPathConfig(ISourceLocation projectRoot, IConstructor mode) {
        try {
            if (URIResolverRegistry.getInstance().exists(projectRoot)) {
                return PathConfig.fromSourceProjectRascalManifest(projectRoot, mode.getName().equals("compiler") ? PathConfig.RascalConfigMode.COMPILER : PathConfig.RascalConfigMode.INTERPRETER, true).asConstructor();
            }
            throw new FileNotFoundException(projectRoot.toString());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
    }

    IEvaluator<?> getDefaultEvaluator(PrintWriter stdout, PrintWriter stderr) {
        return ShellEvaluatorFactory.getBasicEvaluator(Reader.nullReader(), stdout, stderr, this.monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IList evalCommands(IList commands, ISourceLocation loc) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        PrintWriter outStream = new PrintWriter(out);
        PrintWriter errStream = new PrintWriter(err);
        IListWriter result = this.values.listWriter();
        IEvaluator<?> evaluator = this.getDefaultEvaluator(outStream, errStream);
        int outOffset = 0;
        int errOffset = 0;
        for (IValue v : commands) {
            Object errOut = "";
            boolean exc = false;
            Result<IValue> x = null;
            try {
                x = evaluator.eval(evaluator.getMonitor(), ((IString)v).getValue(), loc);
            }
            catch (Throwable e) {
                errStream.flush();
                errOut = err.toString().substring(errOffset);
                errOffset += ((String)errOut).length();
                errOut = (String)errOut + e.getMessage();
                exc = true;
            }
            finally {
                outStream.flush();
                errStream.flush();
            }
            String output = out.toString().substring(outOffset);
            outOffset += output.length();
            if (!exc) {
                errOut = (String)errOut + err.toString().substring(errOffset);
                errOffset += ((String)errOut).length();
            }
            try {
                String s2 = this.printResult(x);
                ITuple tuple = this.values.tuple(this.values.string(s2), this.values.string(output), this.values.string((String)errOut));
                result.append(tuple);
            }
            catch (IOException e) {}
        }
        IList results = (IList)result.done();
        return results;
    }

    private String printResult(IRascalResult result) throws IOException {
        if (result == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        IValue value = result.getValue();
        if (value == null) {
            return "";
        }
        Type type = result.getStaticType();
        StandardTextWriter indentedPrettyPrinter = new StandardTextWriter();
        if (type.isAbstractData() && type.isSubtypeOf(RascalValueFactory.Tree)) {
            out.print(type.toString());
            out.print(": ");
            out.print("`");
            TreeAdapter.yield((IConstructor)result.getValue(), true, out);
            out.println("`");
            out.print("Tree: ");
            StandardTextWriter singleLinePrettyPrinter = new StandardTextWriter(false);
            try (LimitedWriter wrt = new LimitedWriter(out, 4000L);){
                singleLinePrettyPrinter.write(value, wrt);
            }
            catch (RuntimeException runtimeException) {}
        } else {
            out.print(type.toString());
            out.print(": ");
            try (LimitedWriter wrt = new LimitedWriter(new LimitedLineWriter(out, 200L), 4000L);){
                indentedPrettyPrinter.write(value, wrt);
            }
            catch (LimitedResultWriter.IOLimitReachedException iOLimitReachedException) {
                // empty catch block
            }
        }
        out.flush();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static char[] getResourceContent(ISourceLocation location) throws IOException {
        char[] data;
        URIResolverRegistry resolverRegistry = URIResolverRegistry.getInstance();
        try (Reader textStream = null;){
            textStream = resolverRegistry.getCharacterReader(location);
            data = InputConverter.toChar(textStream);
        }
        return data;
    }

    public static ITree parseModuleWithSpaces(ISourceLocation loc) {
        try {
            return new RascalParser().parse("start__Module", loc.getURI(), Reflective.getResourceContent(loc), Integer.MAX_VALUE, new NoActionExecutor(), new DefaultNodeFlattener(), new UPTRNodeFactory(true));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public IBool inCompiledMode() {
        return this.values.bool(false);
    }

    protected String stripQuotes(IValue suffixVal) {
        String s1 = suffixVal.toString();
        if (s1.startsWith("\"")) {
            s1 = s1.substring(1, s1.length() - 1);
        }
        return s1;
    }

    public IString diff(IValue oldVal, IValue newVal) {
        return this.values.string(this.idiff("", oldVal, newVal));
    }

    private String preview(IValue v) {
        String s2 = v.toString();
        if (s2.length() < 80) {
            return s2;
        }
        return s2.substring(0, 76) + " ...";
    }

    protected String idiff(String indent, IValue oldVal, IValue newVal) {
        Object sNew;
        Object sOld;
        int i;
        String ldiff;
        IValue nv;
        IValue ov;
        if (!oldVal.getType().equals(newVal.getType())) {
            return indent + "old " + oldVal.getType() + ",  new " + newVal.getType();
        }
        if (oldVal.equals(newVal)) {
            return "no diff";
        }
        if (oldVal.getType().isString()) {
            ov = (IString)oldVal;
            nv = (IString)newVal;
            ldiff = ov.length() == nv.length() ? "" : "string length " + ov.length() + " vs " + nv.length() + "; ";
            for (i = 0; i < ov.length() && i < nv.length(); ++i) {
                if (ov.charAt(i) == nv.charAt(i)) continue;
                return indent + ldiff + "diff at index " + i + " in " + this.preview(ov) + ": " + ov.charAt(i) + " vs " + nv.charAt(i) + "\n" + indent + "old: " + (IString)ov + "\n" + indent + "new: " + (IString)nv;
            }
        }
        if (oldVal.getType().isSourceLocation()) {
            return indent + "old " + oldVal + "\n" + indent + "new " + newVal;
        }
        if (oldVal.getType().isList()) {
            ov = (IList)oldVal;
            nv = (IList)newVal;
            ldiff = ov.length() == nv.length() ? "" : "size " + ov.length() + " vs " + nv.length() + "; ";
            for (i = 0; i < ov.length() && i < nv.length(); ++i) {
                if (ov.get(i).equals(nv.get(i))) continue;
                return indent + ldiff + "diff at index " + i + " in list " + this.preview(ov) + ":\n" + this.idiff(indent + " ", ov.get(i), nv.get(i));
            }
        }
        if (oldVal.getType().isTuple()) {
            ov = (ITuple)oldVal;
            nv = (ITuple)newVal;
            for (int i2 = 0; i2 < ov.arity(); ++i2) {
                if (ov.get(i2).equals(nv.get(i2))) continue;
                return indent + "diff at index " + i2 + " in tuple " + this.preview(ov) + ":\n" + this.idiff(indent + " ", ov.get(i2), nv.get(i2));
            }
        }
        if (oldVal.getType().isSet()) {
            ov = (ISet)oldVal;
            nv = (ISet)newVal;
            String ldiff2 = ov.size() == nv.size() ? "" : "size " + ov.size() + " vs " + nv.size() + "; ";
            ISet diff1 = ov.subtract((ISet)nv);
            String msg1 = diff1.size() == 0 ? "" : indent + "only in old set: " + diff1 + "\n";
            ISet diff2 = nv.subtract((ISet)ov);
            String msg2 = diff2.size() == 0 ? "" : indent + "only in new set: " + diff2;
            return ldiff2 + msg1 + msg2 + "\n";
        }
        if (oldVal.getType().isMap()) {
            ov = (IMap)oldVal;
            nv = (IMap)newVal;
            String ldiff3 = ov.size() == nv.size() ? "" : "size " + ov.size() + " vs " + nv.size() + "; ";
            IMap all = ov.join((IMap)nv);
            Object onlyInOld = "";
            Object onlyInOldCurrent = "";
            Object onlyInNew = "";
            Object onlyInNewCurrent = "";
            Object diffVal = "";
            Object diffValCurrent = "";
            int nDiff = 0;
            for (IValue key : all) {
                if (!nv.containsKey(key)) {
                    if (((String)onlyInOldCurrent).length() > 80) {
                        onlyInOld = (String)onlyInOld + (String)onlyInOldCurrent + "\n" + indent + key;
                        onlyInOldCurrent = "";
                        continue;
                    }
                    onlyInOldCurrent = (String)onlyInOldCurrent + " " + key;
                    continue;
                }
                if (!ov.containsKey(key)) {
                    if (((String)onlyInNewCurrent).length() > 80) {
                        onlyInNew = (String)onlyInNew + (String)onlyInNewCurrent + "\n" + indent + key;
                        onlyInNewCurrent = "";
                        continue;
                    }
                    onlyInNewCurrent = (String)onlyInNewCurrent + " " + key;
                    continue;
                }
                if (ov.get(key).equals(nv.get(key)) || nDiff >= 10) continue;
                if (((String)diffValCurrent).length() > 80) {
                    diffVal = (String)diffVal + (String)diffValCurrent + "\n" + indent + key;
                    diffValCurrent = "";
                } else {
                    diffValCurrent = (String)diffValCurrent + " " + key;
                }
                ++nDiff;
            }
            onlyInOld = (String)onlyInOld + (String)onlyInOldCurrent;
            onlyInNew = (String)onlyInNew + (String)onlyInNewCurrent;
            diffVal = (String)diffVal + (String)diffValCurrent;
            Object msg1 = ((String)onlyInOld).length() == 0 ? "" : "keys only in old map:" + (String)onlyInOld + "; ";
            Object msg2 = ((String)onlyInNew).length() == 0 ? "" : "keys only in new map:" + (String)onlyInNew + "; ";
            Object msg3 = ((String)diffVal).length() == 0 ? "" : "some keys with different values:" + (String)diffVal;
            return indent + ldiff3 + (String)msg1 + (String)msg2 + (String)msg3;
        }
        if (oldVal.getType().isNode()) {
            int newArity;
            String newName;
            ov = (INode)oldVal;
            nv = (INode)newVal;
            String oldName = ov.getName();
            if (!oldName.equals(newName = nv.getName())) {
                return indent + "diff in function symbol: " + oldName + " vs " + newName;
            }
            int oldArity = ov.arity();
            if (oldArity != (newArity = nv.arity())) {
                return indent + "diff in arity for function symbol " + oldName + ": " + oldArity + " vs " + newArity;
            }
            for (int i3 = 0; i3 < oldArity; ++i3) {
                if (ov.get(i3).equals(nv.get(i3))) continue;
                String argId = Integer.toString(i3);
                if (ov instanceof IConstructor) {
                    IConstructor cov = (IConstructor)ov;
                    argId = cov.getChildrenTypes().getFieldName(i3);
                }
                return indent + "diff at arg " + argId + " for function symbol " + oldName + ": " + this.preview(ov) + "\n" + this.idiff(indent + " ", ov.get(i3), nv.get(i3));
            }
        }
        if (((String)(sOld = oldVal.toString())).length() > 20) {
            sOld = ((String)sOld).substring(0, 20) + "...";
        }
        if (((String)(sNew = newVal.toString())).length() > 20) {
            sNew = ((String)sNew).substring(0, 20) + "...";
        }
        return indent + "old " + (String)sOld + ", new " + (String)sNew;
    }

    public IInteger getFingerprint(IValue val, IBool concretePatterns) {
        return this.values.integer(ToplevelType.getFingerprint(val, concretePatterns.getValue()));
    }

    public IInteger getFingerprint(IValue val, IInteger arity, IBool concretePatterns) {
        return this.values.integer(ToplevelType.getFingerprint(val, concretePatterns.getValue()) << 2 + arity.intValue());
    }

    public IInteger getFingerprintNode(INode nd) {
        return this.values.integer(ToplevelType.getFingerprintNode(nd));
    }

    public IInteger getHashCode(IValue v) {
        return this.values.integer(v.hashCode());
    }

    public void throwNullPointerException() {
        throw new NullPointerException();
    }
}

