/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.stack.AbstractExpandableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class OptionalStackNode<P>
extends AbstractExpandableStackNode<P> {
    private final P production;
    private final String name;
    private final AbstractStackNode<P>[] children;
    private final AbstractStackNode<P> emptyChild;

    public OptionalStackNode(int id, int dot, P production, AbstractStackNode<P> optional) {
        super(id, dot);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateChildren(optional);
        this.emptyChild = this.generateEmptyChild();
    }

    public OptionalStackNode(int id, int dot, P production, AbstractStackNode<P> optional, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateChildren(optional);
        this.emptyChild = this.generateEmptyChild();
    }

    private OptionalStackNode(OptionalStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.name = original.name;
        this.children = original.children;
        this.emptyChild = original.emptyChild;
    }

    private AbstractStackNode<P>[] generateChildren(AbstractStackNode<P> optional) {
        AbstractStackNode<P> child = optional.getCleanCopy(-1);
        child.setAlternativeProduction(this.production);
        return new AbstractStackNode[]{child};
    }

    private AbstractStackNode<P> generateEmptyChild() {
        AbstractStackNode<P> empty = EMPTY.getCleanCopy(-1);
        empty.setAlternativeProduction(this.production);
        return empty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new OptionalStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P>[] getChildren() {
        return this.children;
    }

    @Override
    public boolean canBeEmpty() {
        return true;
    }

    @Override
    public AbstractStackNode<P> getEmptyChild() {
        return this.emptyChild;
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.production.hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof OptionalStackNode)) {
            return false;
        }
        OptionalStackNode otherNode = (OptionalStackNode)stackNode;
        if (!this.production.equals(otherNode.production)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

