/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.NonVoidTypeRequired;
import org.rascalmpl.semantics.dynamic.Comprehension;
import org.rascalmpl.semantics.dynamic.ComprehensionWriter;

public class ListComprehensionWriter
extends ComprehensionWriter {
    public ListComprehensionWriter(List<Expression> resultExprs, IEvaluator<Result<IValue>> __eval) {
        super(resultExprs, __eval);
        this.writer = this.VF.listWriter();
        this.elementType1 = this.TF.voidType();
    }

    @Override
    public void append() {
        for (Expression resExpr : this.resultExprs) {
            if (resExpr.isSplice() || resExpr.isSplicePlus()) {
                Result<IValue> list = resExpr.getArgument().interpret(this.ev);
                if (list.getStaticType().isList() || list.getStaticType().isSet()) {
                    this.elementType1 = this.elementType1.lub(list.getStaticType().getElementType());
                    ((IListWriter)this.writer).appendAll((Iterable)((Object)list.getValue()));
                    continue;
                }
                this.elementType1 = this.elementType1.lub(list.getStaticType());
                ((IListWriter)this.writer).append(list.getValue());
                continue;
            }
            Result<IValue> res = resExpr.interpret(this.ev);
            if (res == null || res.getStaticType().isBottom()) {
                throw new NonVoidTypeRequired(this.ev.getCurrentAST());
            }
            this.elementType1 = this.elementType1.lub(res.getStaticType());
            ((IListWriter)this.writer).append(res.getValue());
        }
    }

    @Override
    public Result<IValue> done() {
        return this.writer == null ? Comprehension.makeResult(this.TF.listType(this.TF.voidType()), this.VF.list(new IValue[0]), this.getContext((AbstractAST)this.resultExprs.get(0))) : Comprehension.makeResult(this.TF.listType(this.elementType1), this.writer.done(), this.getContext((AbstractAST)this.resultExprs.get(0)));
    }
}

