/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.ISourceLocationOutput;

public abstract class AbstractSourceLocationInputOutputAdapter
implements ISourceLocationInputOutput {
    private final ISourceLocationInput input;
    private final ISourceLocationOutput output;

    protected AbstractSourceLocationInputOutputAdapter(ISourceLocationInput input) {
        this.input = input;
        this.output = input instanceof ISourceLocationOutput ? (ISourceLocationOutput)((Object)input) : null;
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        return this.input.getInputStream(uri);
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return this.input.getCharset(uri);
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.input.exists(uri);
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        return this.input.lastModified(uri);
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return this.input.isDirectory(uri);
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return this.input.isFile(uri);
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        return this.input.list(uri);
    }

    @Override
    public String scheme() {
        return this.input.scheme();
    }

    @Override
    public boolean supportsHost() {
        return this.input.supportsHost();
    }

    @Override
    public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        if (this.output != null) {
            return this.output.getOutputStream(uri, append);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void mkDirectory(ISourceLocation uri) throws IOException {
        if (this.output == null) {
            throw new UnsupportedOperationException();
        }
        this.output.mkDirectory(uri);
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        if (this.output == null) {
            throw new UnsupportedOperationException();
        }
        this.output.setLastModified(uri, timestamp);
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        if (this.output == null) {
            throw new UnsupportedOperationException();
        }
        this.output.remove(uri);
    }
}

