/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.locations.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.rascalmpl.util.locations.LineColumnOffsetMap;

public class ArrayLineOffsetMap
implements LineColumnOffsetMap {
    private final IntArray lines;
    private final ArrayList<IntArray> wideColumnOffsets;
    private final ArrayList<IntArray> wideColumnOffsetsInverse;
    private final IntArray lineStartOffsets;

    public ArrayLineOffsetMap(IntArray lines, ArrayList<IntArray> wideColumnOffsets, ArrayList<IntArray> wideColumnOffsetsInverse, IntArray lineStartOffsets) {
        this.lines = lines;
        this.wideColumnOffsets = wideColumnOffsets;
        this.wideColumnOffsetsInverse = wideColumnOffsetsInverse;
        this.lineStartOffsets = lineStartOffsets;
    }

    @Override
    public int translateColumn(int line, int column, boolean isEnd) {
        int lineIndex = this.lines.search(line);
        if (lineIndex < 0) {
            return column;
        }
        return column + this.translateColumnForLine(this.wideColumnOffsets.get(lineIndex), column, isEnd);
    }

    private int translateColumnForLine(IntArray lineOffsets, int column, boolean isEnd) {
        int columnIndex = lineOffsets.search(column);
        if (columnIndex >= 0) {
            if (isEnd) {
                return columnIndex + 1;
            }
            return columnIndex;
        }
        return Math.abs(columnIndex + 1);
    }

    @Override
    public int translateInverseColumn(int line, int column, boolean isEnd) {
        int lineIndex = this.lines.search(line);
        if (lineIndex < 0) {
            return column;
        }
        return column - this.translateColumnForLine(this.wideColumnOffsetsInverse.get(lineIndex), column, isEnd);
    }

    @Override
    public Pair<Integer, Integer> calculateInverseOffsetLength(int beginLine, int beginColumn, int endLine, int endColumn) {
        if (beginLine > endLine || beginLine == endLine && beginColumn > endColumn) {
            throw new IllegalArgumentException(String.format("Begin position must be before end position [(%d,%d), (%d,%d)]", beginLine, beginColumn, endLine, endColumn));
        }
        int startOffset = this.lineStartOffsets.get(beginLine) + this.translateInverseColumn(beginLine, beginColumn, false);
        int endOffset = this.lineStartOffsets.get(endLine) + this.translateInverseColumn(endLine, endColumn, true);
        return Pair.of(startOffset, endOffset - startOffset);
    }

    public static LineColumnOffsetMap build(String contents) {
        int line = 0;
        int column = 0;
        char prev = '\u0000';
        GrowingIntArray linesWithSurrogate = new GrowingIntArray();
        ArrayList<IntArray> linesMap = new ArrayList<IntArray>(0);
        ArrayList<IntArray> inverseLinesMap = new ArrayList<IntArray>(0);
        GrowingIntArray currentLine = new GrowingIntArray();
        GrowingIntArray lineStartOffsets = new GrowingIntArray();
        lineStartOffsets.add(0);
        int n = contents.length();
        for (int i = 0; i < n; ++i) {
            char c = contents.charAt(i);
            if (c == '\n' || c == '\r') {
                if (c != prev && (prev == '\r' || prev == '\n')) continue;
                if (!currentLine.isEmpty()) {
                    linesWithSurrogate.add(line);
                    linesMap.add(currentLine.build());
                    inverseLinesMap.add(currentLine.buildInverse());
                    currentLine = new GrowingIntArray();
                }
                ++line;
                column = 0;
                lineStartOffsets.add(i + 1);
            } else {
                ++column;
                if (Character.isHighSurrogate(c) && i + 1 < n && Character.isLowSurrogate(contents.charAt(i + 1))) {
                    currentLine.add(column);
                    ++i;
                }
            }
            prev = c;
        }
        if (!currentLine.isEmpty()) {
            linesWithSurrogate.add(line);
            linesMap.add(currentLine.build());
            inverseLinesMap.add(currentLine.buildInverse());
        }
        return new ArrayLineOffsetMap(linesWithSurrogate.build(), linesMap, inverseLinesMap, lineStartOffsets.build());
    }

    private static class IntArray {
        private final int[] data;
        private final int length;

        public IntArray(int[] data, int length) {
            this.data = data;
            this.length = length;
        }

        public int get(int i) {
            if (i < 0 || i >= this.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot get element at %d; IntArray has %d elements", i, this.length));
            }
            return this.data[i];
        }

        public int search(int key) {
            if (this.length == 0) {
                return -1;
            }
            if (this.length <= 8) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data[i] < key) continue;
                    if (this.data[i] == key) {
                        return i;
                    }
                    return -i - 1;
                }
                return -(this.length + 1);
            }
            return Arrays.binarySearch(this.data, 0, this.length, key);
        }
    }

    private static class GrowingIntArray {
        private int[] data = new int[0];
        private int filled = 0;

        private GrowingIntArray() {
        }

        public void add(int v) {
            this.growIfNeeded();
            this.data[this.filled] = v;
            ++this.filled;
        }

        public IntArray buildInverse() {
            int[] result = new int[this.filled];
            for (int i = 0; i < this.filled; ++i) {
                result[i] = this.data[i] + i;
            }
            return new IntArray(result, this.filled);
        }

        public boolean isEmpty() {
            return this.filled == 0;
        }

        public IntArray build() {
            return new IntArray(this.data, this.filled);
        }

        private void growIfNeeded() {
            if (this.filled >= this.data.length) {
                this.data = this.data.length == 0 ? new int[4] : Arrays.copyOf(this.data, this.data.length + this.data.length / 2);
            }
        }
    }
}

