---
title: "module Exception"
id: Exception
slug: /Library//Exception
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Exceptions thrown by the Rascal run-time
#### Usage

```rascal
import Exception;
```



## data RuntimeException {#Exception-RuntimeException}
The `Exception` datatype used in all Rascal exceptions.

```rascal
data RuntimeException  
     = Ambiguity(loc location, str nonterminal, str sentence)
     | ArithmeticException(str message)
     | AssertionFailed()
     | AssertionFailed(str label)
     | CallFailed(list[value] arguments)
     | DateTimeParsingError(str message)
     | DateTimePrintingError(str message)
     | EmptyList()
     | EmptyMap()
     | EmptySet()
     | IndexOutOfBounds(int index)
     | IllegalArgument()
     | IllegalArgument(value v)
     | IllegalArgument(value v, str message)
     | IllegalTypeArgument(str cls, str message)
     | ImplodeError(str message)
     | InvalidURI(str uri)
     | InvalidUseOfDate(str message)
     | InvalidUseOfDateTime(str message)
     | InvalidUseOfLocation(str message)
     | InvalidUseOfTime(str message)
     | IO(str message)
     | Java(str class, str message)
     | Java(str class, str message, RuntimeException cause)
     | JavaException(str class, str message)
     | JavaException(str class, str message, RuntimeException cause)
     | JavaCompilation(str message, int line, int column, str source, list[loc] classpath)
     | MalFormedURI(str uri)
     | ModuleNotFound(str name)
     | MultipleKey(value key, value first, value second)
     | NoMainFunction()
     | NoParent(loc location)
     | NoSuchAnnotation(str label)
     | NoSuchElement(value v)
     | NoSuchField(str name)
     | NoSuchKey(value key)
     | NotImplemented(str message)
     | ParseError(loc location)
     | PathNotFound(loc location)
     | PathNotFound(set[loc] locs)
     | PermissionDenied()
     | PermissionDenied(str message)
     | RegExpSyntaxError(str message)
     | SchemeNotSupported(loc location)
     | StackOverflow()
     | Timeout()
     | UnavailableInformation()
     ;
```


This data type declares all exceptions that are thrown by the
Rascal run-time environment which can be caught by a Rascal program.

Since declarations for data types are extensible, the user can add new exceptions when needed.
However, this is not necessary. The throw statement can throw any value.

Exceptions are either generated by the Rascal run-time (e.g., `IndexOutOfBounds`) or they
are generated by a throw statement. They can all be caught with a try-catch using pattern matching.

#### Examples


Import relevant libraries:

```rascal-shell ,continue
rascal>import Exception;
ok
rascal>import IO;
ok
```
Define the map `weekend` and do a subscription with a non-existing key:

```rascal-shell ,continue,error
rascal>weekend = ("saturday": 1, "sunday": 2);
map[str, int]: ("sunday":2,"saturday":1)
rascal>weekend["monday"];
|prompt:///|(8,8,<1,8>,<1,16>): NoSuchKey("monday")
	at $(|prompt:///|(0,18,<1,0>,<1,18>))
```
Repeat this, but catch the exception. We use variable `N` to track what happened:

```rascal-shell ,continue
rascal>N = 1;
int: 1
rascal>try {
|1 >>>>   N = weekend["monday"];
|2 >>>>} catch NoSuchKey(v):
|3 >>>>  N = 100;
ok
rascal>println(N);
100
ok
```

