---
title: "module lang::c90::\\syntax::C"
id: C
slug: /Library/lang/c90/syntax/C
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import lang::c90::\syntax::C;
```



## syntax Statement {#lang-c90-\syntax-C-Statement}

```rascal
syntax Statement 
	= "{" Declaration* Statement* "}" 
	| Identifier ":" Statement 
	| "case" Expression ":" Statement 
	| "default" ":" Statement 
	| ";" 
	| Expression ";" 
	| "if" "(" Expression ")" Statement 
	| "if" "(" Expression ")" Statement "else" Statement 
	| "switch" "(" Expression ")" Statement 
	| "while" "(" Expression ")" Statement 
	| "do" Statement "while" "(" Expression ")" ";" 
	| "for" "(" Expression? ";" Expression? ";" Expression? ")" Statement 
	| "goto" Identifier ";" 
	| "continue" ";" 
	| "break" ";" 
	| "return" ";" 
	| "return" Expression ";"
	;
```

## syntax Expression {#lang-c90-\syntax-C-Expression}

```rascal
syntax Expression 
	= variable: Identifier 
	| @category="number" HexadecimalConstant 
	| @category="number" IntegerConstant 
	| @category="string" CharacterConstant 
	| @category="number" FloatingPointConstant 
	| @category="string" StringConstant 
	| Expression "[" Expression "]" 
	| Expression "(" {NonCommaExpression ","}* ")" 
	| "sizeof" "(" TypeName ")" 
	| bracket \bracket: "(" Expression ")" 
	| Expression "." Identifier 
	| Expression "-\>" Identifier 
	| Expression "++" 
	| Expression "--" 
	> [+] !<< "++" Expression 
	| [\-] !<< "--" Expression 
	| "&" Expression 
	| "*" Expression 
	| "+" Expression 
	| "-" Expression 
	| "~" Expression 
	| "!" Expression 
	| sizeOfExpression: "sizeof" Expression exp // May be ambiguous with "sizeof(TypeName)".
	| "(" TypeName ")" Expression 
	> left ( multiplicationExpression: Expression lexp "*" Expression rexp // May be ambiguous with "TypeName *Declarator".
	       | Expression "/" Expression 
	       | Expression "%" Expression
	       ) 
	> left ( Expression "+" Expression 
	       | Expression "-" Expression
	       )
	> left ( Expression "\<\<" Expression 
	       | Expression "\>\>" Expression
		   )
	> left ( Expression "\<" Expression 
	       | Expression "\>" Expression 
	       | Expression "\<=" Expression 
	       | Expression "\>=" Expression
	       )
	> left ( Expression "==" Expression 
	       | Expression "!=" Expression
	       )
    > left Expression "&" Expression 
	> left Expression "^" Expression 
	> left Expression "|" Expression 
	> left Expression "&&" Expression 
	> left Expression "||" Expression 
	> right Expression "?" Expression ":" Expression 
	> right ( Expression "=" Expression 
	        | Expression "*=" Expression 
	        | Expression "/=" Expression 
	        | Expression "%=" Expression 
	        | Expression "+=" Expression 
	        | Expression "-=" Expression 
	        | Expression "\<\<=" Expression 
	        | Expression "\>\>=" Expression 
	        | Expression "&=" Expression 
	        | Expression "^=" Expression 
	        | Expression "
	        | =" Expression
			)
	> left commaExpression: Expression "," Expression
	;
```

## syntax NonCommaExpression {#lang-c90-\syntax-C-NonCommaExpression}

```rascal
syntax NonCommaExpression = nonCommaExpression: Expression expr;
```

## syntax Identifier {#lang-c90-\syntax-C-Identifier}

```rascal
lexical Identifier = ([a-zA-Z_] [a-zA-Z0-9_]* !>> [a-zA-Z0-9_]) \ Keyword;
```

## syntax AnonymousIdentifier {#lang-c90-\syntax-C-AnonymousIdentifier}

```rascal
syntax AnonymousIdentifier = ;
```

## syntax Keyword {#lang-c90-\syntax-C-Keyword}

```rascal
keyword Keyword 
	= "auto" 
	| "break" 
	| "case" 
	| "char" 
	| "const" 
	| "continue" 
	| "default" 
	| "do" 
	| "double" 
	| "else" 
	| "enum" 
	| "extern" 
	| "float" 
	| "for" 
	| "goto" 
	| "if" 
	| "int" 
	| "long" 
	| "register" 
	| "return" 
	| "short" 
	| "signed" 
	| "sizeof" 
	| "static" 
	| "struct" 
	| "switch" 
	| "typedef" 
	| "union" 
	| "unsigned" 
	| "void" 
	| "volatile" 
	| "while"
	;
```

## syntax Declaration {#lang-c90-\syntax-C-Declaration}

```rascal
syntax Declaration 
	= declarationWithInitDecls: Specifier+ specs {InitDeclarator ","}+ initDeclarators ";" 
	| declarationWithoutInitDecls: Specifier+ specs ";" // Avoid.
	;
```

## syntax GlobalDeclaration {#lang-c90-\syntax-C-GlobalDeclaration}

```rascal
syntax GlobalDeclaration 
	= globalDeclarationWithInitDecls: Specifier* specs0 {InitDeclarator ","}+ initDeclarators ";" 
	| globalDeclarationWithoutInitDecls: Specifier+ specs1 ";" // Avoid.
	;
```

## syntax InitDeclarator {#lang-c90-\syntax-C-InitDeclarator}

```rascal
syntax InitDeclarator 
	= Declarator decl 
	| Declarator decl "=" Initializer
	;
```

## syntax Specifier {#lang-c90-\syntax-C-Specifier}

```rascal
syntax Specifier 
	= storageClass: StorageClass 
	| typeSpecifier: TypeSpecifier 
	| typeQualifier: TypeQualifier
	;
```

## syntax StorageClass {#lang-c90-\syntax-C-StorageClass}

```rascal
syntax StorageClass 
	= typeDef: "typedef" 
	| "extern" 
	| "static" 
	| "auto" 
	| "register"
	;
```

## syntax TypeSpecifier {#lang-c90-\syntax-C-TypeSpecifier}

```rascal
syntax TypeSpecifier 
	= identifier: Identifier 
	| \void: "void" 
	| char: "char" 
	| short: "short" 
	| \int: "int" 
	| long: "long" 
	| \float: "float" 
	| \double: "double" 
	| "signed" 
	| "unsigned" 
	| struct: "struct" Identifier 
	| structDecl: "struct" Identifier "{" StructDeclaration* "}" 
	| structAnonDecl: "struct" "{" StructDeclaration* "}" 
	| union: "union" Identifier 
	| unionDecl: "union" Identifier "{" StructDeclaration* "}" 
	| unionAnonDecl: "union" "{" StructDeclaration* "}" 
	| enum: "enum" Identifier 
	| enumDecl: "enum" Identifier "{" {Enumerator ","}+ "}" 
	| enumAnonDecl: "enum" "{" {Enumerator ","}+ "}"
	;
```

## syntax TypeQualifier {#lang-c90-\syntax-C-TypeQualifier}

```rascal
syntax TypeQualifier 
	= "const" 
	| "volatile"
	;
```

## syntax StructDeclaration {#lang-c90-\syntax-C-StructDeclaration}

```rascal
syntax StructDeclaration 
	= structDeclWithDecl: Specifier+ specs {StructDeclarator ","}+ ";" // TODO: Disallow store class specifiers.
	| structDeclWithoutDecl: Specifier+ specs ";" // TODO: Disallow store class specifiers. Avoid.
	;
```

## syntax StructDeclarator {#lang-c90-\syntax-C-StructDeclarator}

```rascal
syntax StructDeclarator 
	= Declarator 
	| Declarator? ":" Expression // Prefer the one where 'Declarator' is filled.
	;
```

## syntax Parameters {#lang-c90-\syntax-C-Parameters}

```rascal
syntax Parameters 
	= {Parameter ","}+ MoreParameters? 
	| "void"
	;
```

## syntax MoreParameters {#lang-c90-\syntax-C-MoreParameters}

```rascal
syntax MoreParameters = "," "...";
```

## syntax Parameter {#lang-c90-\syntax-C-Parameter}

```rascal
syntax Parameter = Specifier* Declarator;
```

## syntax PrototypeParameter {#lang-c90-\syntax-C-PrototypeParameter}

```rascal
syntax PrototypeParameter = Specifier* AbstractDeclarator;
```

## syntax PrototypeParameters {#lang-c90-\syntax-C-PrototypeParameters}

```rascal
syntax PrototypeParameters 
	= {PrototypeParameter ","}+ MoreParameters? 
	| "void"
	;
```

## syntax Initializer {#lang-c90-\syntax-C-Initializer}

```rascal
syntax Initializer 
	= NonCommaExpression 
	| "{" {Initializer ","}+ ","?  "}"
	;
```

## syntax TypeName {#lang-c90-\syntax-C-TypeName}

```rascal
syntax TypeName = Specifier+ AbstractDeclarator;
```

## syntax Enumerator {#lang-c90-\syntax-C-Enumerator}

```rascal
syntax Enumerator 
	= Identifier 
	| Identifier "=" NonCommaExpression
	;
```

## syntax AbstractDeclarator {#lang-c90-\syntax-C-AbstractDeclarator}

```rascal
syntax AbstractDeclarator 
	= identifier: AnonymousIdentifier 
	| bracket \bracket: "(" AbstractDeclarator decl ")" 
	| arrayDeclarator: AbstractDeclarator decl "[" Expression? exp "]" 
	| functionDeclarator: AbstractDeclarator decl "(" Parameters? params ")" 
	> pointerDeclarator: "*" TypeQualifier* qualifiers AbstractDeclarator decl
	;
```

## syntax PrototypeDeclarator {#lang-c90-\syntax-C-PrototypeDeclarator}

```rascal
syntax PrototypeDeclarator 
	= identifier: Identifier 
	| bracket \bracket: "(" AbstractDeclarator abs_decl ")" 
	| arrayDeclarator: PrototypeDeclarator proto_decl "[" Expression? exp "]" 
	| functionDeclarator: PrototypeDeclarator proto_decl "(" PrototypeParameters? params ")" 
	> pointerDeclarator: "*" TypeQualifier* qualifiers PrototypeDeclarator decl
	;
```

## syntax Declarator {#lang-c90-\syntax-C-Declarator}

```rascal
syntax Declarator 
	= identifier: Identifier 
	| bracket \bracket: "(" Declarator decl ")" 
	| arrayDeclarator: Declarator decl "[" Expression? exp "]" 
	| functionDeclarator: Declarator decl "(" Parameters? params ")" 
	> pointerDeclarator: "*" TypeQualifier* qualifiers Declarator decl
	;
```

## syntax IntegerConstant {#lang-c90-\syntax-C-IntegerConstant}

```rascal
lexical IntegerConstant = [0-9]+ [uUlL]* !>> [0-9];
```

## syntax HexadecimalConstant {#lang-c90-\syntax-C-HexadecimalConstant}

```rascal
lexical HexadecimalConstant = [0] [xX] [a-fA-F0-9]+ [uUlL]* !>> [a-fA-F0-9];
```

## syntax FloatingPointConstant {#lang-c90-\syntax-C-FloatingPointConstant}

```rascal
lexical FloatingPointConstant 
	= [0-9]+ Exponent [fFlL]? 
	| [0-9]* [.] [0-9]+ !>> [0-9] Exponent? [fFlL]? 
	| [0-9]+ [.] Exponent? [fFlL]?
	;
```

## syntax Exponent {#lang-c90-\syntax-C-Exponent}

```rascal
lexical Exponent = [Ee] [+\-]? [0-9]+ !>> [0-9];
```

## syntax CharacterConstant {#lang-c90-\syntax-C-CharacterConstant}

```rascal
lexical CharacterConstant = [L]? [\'] CharacterConstantContent+ [\'];
```

## syntax CharacterConstantContent {#lang-c90-\syntax-C-CharacterConstantContent}

```rascal
lexical CharacterConstantContent 
	= [\\] ![] 
	| ![\\\']
	;
```

## syntax StringConstant {#lang-c90-\syntax-C-StringConstant}

```rascal
lexical StringConstant = [L]? [\"] StringConstantContent* [\"];
```

## syntax StringConstantContent {#lang-c90-\syntax-C-StringConstantContent}

```rascal
lexical StringConstantContent 
	= [\\] ![] 
	| ![\\\"]
	;
```

## syntax FunctionDefinition {#lang-c90-\syntax-C-FunctionDefinition}

```rascal
syntax FunctionDefinition = defaultFunctionDefinition: Specifier* specs Declarator Declaration* "{" Declaration* Statement* "}";
```

## syntax FunctionPrototype {#lang-c90-\syntax-C-FunctionPrototype}

```rascal
syntax FunctionPrototype = defaultFunctionPrototype: Specifier* specs PrototypeDeclarator decl ";";
```

## syntax ExternalDeclaration {#lang-c90-\syntax-C-ExternalDeclaration}

```rascal
syntax ExternalDeclaration 
	= FunctionDefinition 
	| FunctionPrototype 
	| GlobalDeclaration
	;
```

## syntax TranslationUnit {#lang-c90-\syntax-C-TranslationUnit}

```rascal
start syntax TranslationUnit = ExternalDeclaration+;
```

## syntax Comment {#lang-c90-\syntax-C-Comment}

```rascal
lexical Comment 
	= [/][*] MultiLineCommentBodyToken* [*][/] 
	| "//" ![\n]* [\n]
	;
```

## syntax MultiLineCommentBodyToken {#lang-c90-\syntax-C-MultiLineCommentBodyToken}

```rascal
lexical MultiLineCommentBodyToken 
	= ![*] 
	| Asterisk
	;
```

## syntax Asterisk {#lang-c90-\syntax-C-Asterisk}

```rascal
lexical Asterisk = [*] !>> [/];
```

## syntax LAYOUTLIST {#lang-c90-\syntax-C-LAYOUTLIST}

```rascal
layout LAYOUTLIST = LAYOUT* !>> [\ \t\n\r];
```

## syntax LAYOUT {#lang-c90-\syntax-C-LAYOUT}

```rascal
lexical LAYOUT 
	= whitespace: [\ \t\n\r] 
	| @category="comment" comment: Comment
	;
```

