/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.CacheFactory;
import io.usethesource.vallang.io.binary.util.ClearableWindow;
import io.usethesource.vallang.io.binary.util.LinearCircularLookupWindow;
import io.usethesource.vallang.io.binary.util.OpenAddressingLastWritten;
import io.usethesource.vallang.io.binary.util.TrackLastRead;
import io.usethesource.vallang.io.binary.util.TrackLastWritten;
import java.util.concurrent.TimeUnit;

public class WindowCacheFactory {
    private final CacheFactory<TrackLastRead<Object>> lastReads = new CacheFactory<TrackLastRead>(60, TimeUnit.SECONDS, WindowCacheFactory::clear);
    private final CacheFactory<TrackLastWritten<Object>> lastWrittenReference = new CacheFactory<TrackLastWritten>(60, TimeUnit.SECONDS, WindowCacheFactory::clear);
    private final CacheFactory<TrackLastWritten<Object>> lastWrittenObject = new CacheFactory<TrackLastWritten>(60, TimeUnit.SECONDS, WindowCacheFactory::clear);
    private final TrackLastRead<Object> disabledReadWindow = new TrackLastRead<Object>(){

        @Override
        public Object lookBack(int howLongBack) {
            throw new IllegalArgumentException();
        }

        @Override
        public void read(Object obj) {
        }
    };
    private TrackLastWritten<Object> disabledWriteWindow = new TrackLastWritten<Object>(){

        @Override
        public void write(Object obj) {
        }

        @Override
        public int howLongAgo(Object obj) {
            return -1;
        }
    };

    public static WindowCacheFactory getInstance() {
        return InstanceHolder.sInstance;
    }

    public <T> TrackLastRead<T> getTrackLastRead(int size) {
        if (size == 0) {
            return this.disabledReadWindow;
        }
        return this.lastReads.get(size, LinearCircularLookupWindow::new);
    }

    public <T> TrackLastWritten<T> getTrackLastWrittenReferenceEquality(int size) {
        if (size == 0) {
            return this.disabledWriteWindow;
        }
        return this.lastWrittenReference.get(size, OpenAddressingLastWritten::referenceEquality);
    }

    public <T> TrackLastWritten<T> getTrackLastWrittenObjectEquality(int size) {
        if (size == 0) {
            return this.disabledWriteWindow;
        }
        return this.lastWrittenObject.get(size, OpenAddressingLastWritten::objectEquality);
    }

    public <T> void returnTrackLastRead(TrackLastRead<T> returned) {
        if (returned != this.disabledReadWindow) {
            this.doReturn(this.lastReads, returned);
        }
    }

    public <T> void returnTrackLastWrittenReferenceEquality(TrackLastWritten<T> returned) {
        if (returned != this.disabledWriteWindow) {
            this.doReturn(this.lastWrittenReference, returned);
        }
    }

    public <T> void returnTrackLastWrittenObjectEquality(TrackLastWritten<T> returned) {
        if (returned != this.disabledWriteWindow) {
            this.doReturn(this.lastWrittenObject, returned);
        }
    }

    private <T> void doReturn(CacheFactory<T> target, T returned) {
        int windowSize;
        if (returned instanceof ClearableWindow && (windowSize = ((ClearableWindow)returned).size()) >= 1000) {
            target.put(windowSize, returned);
        }
    }

    private static TrackLastRead<Object> clear(TrackLastRead<Object> c) {
        if (c instanceof ClearableWindow) {
            ((ClearableWindow)((Object)c)).clear();
        }
        return c;
    }

    private static TrackLastWritten<Object> clear(TrackLastWritten<Object> c) {
        if (c instanceof ClearableWindow) {
            ((ClearableWindow)((Object)c)).clear();
        }
        return c;
    }

    private static class InstanceHolder {
        static final WindowCacheFactory sInstance = new WindowCacheFactory();

        private InstanceHolder() {
        }
    }
}

