/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.random.util.RandomUtil;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SourceLocationType
extends DefaultSubtypeOfValue {
    SourceLocationType() {
    }

    public static SourceLocationType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj == SourceLocationType.getInstance();
    }

    @Override
    public int hashCode() {
        return 61547;
    }

    @Override
    public String toString() {
        return "loc";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitSourceLocation(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfSourceLocation(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithSourceLocation(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithSourceLocation(this);
    }

    @Override
    protected boolean intersectsWithSourceLocation(Type type) {
        return true;
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithSourceLocation(this);
    }

    @Override
    protected boolean isSubtypeOfSourceLocation(Type type) {
        return true;
    }

    @Override
    protected Type lubWithSourceLocation(Type type) {
        return this;
    }

    @Override
    protected Type glbWithSourceLocation(Type type) {
        return this;
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        try {
            String scheme = RandomUtil.stringAlpha(random, 1 + random.nextInt(Math.max(1, maxDepth)));
            String authority = "";
            Object path = "";
            Object query = "";
            String fragment = "";
            while (!RandomUtil.oneEvery(random, 3) && maxDepth > 0) {
                path = (String)path + "/" + (random.nextDouble() < 0.9 ? RandomUtil.stringAlphaNumeric(random, 1 + random.nextInt(5)) : RandomUtil.string(random, 1 + random.nextInt(5)));
            }
            if (((String)path).isEmpty()) {
                path = "/";
            }
            if (RandomUtil.oneEvery(random, 4)) {
                authority = RandomUtil.stringAlphaNumeric(random, 1 + random.nextInt(6));
            }
            if (RandomUtil.oneEvery(random, 30) && maxDepth > 0) {
                while (!RandomUtil.oneEvery(random, 3)) {
                    if (!((String)query).isEmpty()) {
                        query = (String)query + "&";
                    }
                    query = (String)query + RandomUtil.stringAlpha(random, 1 + random.nextInt(4)) + "=" + RandomUtil.stringAlphaNumeric(random, 1 + random.nextInt(4));
                }
            }
            if (RandomUtil.oneEvery(random, 5) && maxDepth > 0) {
                fragment = RandomUtil.stringAlphaNumeric(random, 1 + random.nextInt(5));
            }
            ISourceLocation result = vf.sourceLocation(scheme, authority, (String)path, (String)query, fragment);
            if (RandomUtil.oneEvery(random, 10) && maxDepth > 0) {
                try {
                    int bound;
                    int n = bound = RandomUtil.oneEvery(random, 10) ? Integer.MAX_VALUE : 512;
                    if (RandomUtil.oneEvery(random, 3)) {
                        int startLine = random.nextInt(bound);
                        int endLine = Math.addExact(startLine, random.nextInt(bound));
                        result = vf.sourceLocation(result, random.nextInt(bound), random.nextInt(bound), startLine, endLine, random.nextInt(bound), random.nextInt(bound));
                    } else {
                        result = vf.sourceLocation(result, random.nextInt(bound), random.nextInt(bound));
                    }
                }
                catch (ArithmeticException | IllegalArgumentException runtimeException) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            try {
                return vf.sourceLocation("tmp", "", "/");
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException("fallback source location should always be correct");
            }
        }
    }

    @Override
    public boolean isSourceLocation() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("loc", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return SourceLocationType.getInstance();
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().sourceLocationType();
        }
    }

    private static final class InstanceKeeper {
        public static final SourceLocationType sInstance = new SourceLocationType();

        private InstanceKeeper() {
        }
    }
}

