/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Assoc
extends AbstractAST {
    public Assoc(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean isAssociative() {
        return false;
    }

    public boolean isLeft() {
        return false;
    }

    public boolean isNonAssociative() {
        return false;
    }

    public boolean isRight() {
        return false;
    }

    public static class Right
    extends Assoc {
        public Right(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssocRight(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Right)) {
                return false;
            }
            Right tmp = (Right)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 839;
        }

        @Override
        public Object clone() {
            return Right.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class NonAssociative
    extends Assoc {
        public NonAssociative(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isNonAssociative() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssocNonAssociative(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NonAssociative)) {
                return false;
            }
            NonAssociative tmp = (NonAssociative)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 433;
        }

        @Override
        public Object clone() {
            return NonAssociative.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Left
    extends Assoc {
        public Left(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssocLeft(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Left)) {
                return false;
            }
            Left tmp = (Left)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 751;
        }

        @Override
        public Object clone() {
            return Left.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Associative
    extends Assoc {
        public Associative(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isAssociative() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssocAssociative(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Associative)) {
                return false;
            }
            Associative tmp = (Associative)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 229;
        }

        @Override
        public Object clone() {
            return Associative.newInstance(this.getClass(), this.src, null);
        }
    }
}

