/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Range;

public abstract class Class
extends AbstractAST {
    public Class(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasRanges() {
        return false;
    }

    public List<Range> getRanges() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasCharClass() {
        return false;
    }

    public Class getCharClass() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasLhs() {
        return false;
    }

    public Class getLhs() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasRhs() {
        return false;
    }

    public Class getRhs() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isBracket() {
        return false;
    }

    public boolean isComplement() {
        return false;
    }

    public boolean isDifference() {
        return false;
    }

    public boolean isIntersection() {
        return false;
    }

    public boolean isSimpleCharclass() {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public static class Union
    extends Class {
        private final Class lhs;
        private final Class rhs;

        public Union(ISourceLocation src, IConstructor node, Class lhs, Class rhs) {
            super(src, node);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean isUnion() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassUnion(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.lhs.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.lhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.rhs.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Union)) {
                return false;
            }
            Union tmp = (Union)o;
            return tmp.lhs.equals(this.lhs) && tmp.rhs.equals(this.rhs);
        }

        @Override
        public int hashCode() {
            return 829 + 937 * this.lhs.hashCode() + 409 * this.rhs.hashCode();
        }

        @Override
        public Class getLhs() {
            return this.lhs;
        }

        @Override
        public boolean hasLhs() {
            return true;
        }

        @Override
        public Class getRhs() {
            return this.rhs;
        }

        @Override
        public boolean hasRhs() {
            return true;
        }

        @Override
        public Object clone() {
            return Union.newInstance(this.getClass(), this.src, null, this.clone(this.lhs), this.clone(this.rhs));
        }
    }

    public static class SimpleCharclass
    extends Class {
        private final List<Range> ranges;

        public SimpleCharclass(ISourceLocation src, IConstructor node, List<Range> ranges) {
            super(src, node);
            this.ranges = ranges;
        }

        @Override
        public boolean isSimpleCharclass() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassSimpleCharclass(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.ranges) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SimpleCharclass)) {
                return false;
            }
            SimpleCharclass tmp = (SimpleCharclass)o;
            return tmp.ranges.equals(this.ranges);
        }

        @Override
        public int hashCode() {
            return 733 + 491 * this.ranges.hashCode();
        }

        @Override
        public List<Range> getRanges() {
            return this.ranges;
        }

        @Override
        public boolean hasRanges() {
            return true;
        }

        @Override
        public Object clone() {
            return SimpleCharclass.newInstance(this.getClass(), this.src, null, this.clone(this.ranges));
        }
    }

    public static class Intersection
    extends Class {
        private final Class lhs;
        private final Class rhs;

        public Intersection(ISourceLocation src, IConstructor node, Class lhs, Class rhs) {
            super(src, node);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean isIntersection() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassIntersection(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.lhs.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.lhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.rhs.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Intersection)) {
                return false;
            }
            Intersection tmp = (Intersection)o;
            return tmp.lhs.equals(this.lhs) && tmp.rhs.equals(this.rhs);
        }

        @Override
        public int hashCode() {
            return 433 + 47 * this.lhs.hashCode() + 131 * this.rhs.hashCode();
        }

        @Override
        public Class getLhs() {
            return this.lhs;
        }

        @Override
        public boolean hasLhs() {
            return true;
        }

        @Override
        public Class getRhs() {
            return this.rhs;
        }

        @Override
        public boolean hasRhs() {
            return true;
        }

        @Override
        public Object clone() {
            return Intersection.newInstance(this.getClass(), this.src, null, this.clone(this.lhs), this.clone(this.rhs));
        }
    }

    public static class Difference
    extends Class {
        private final Class lhs;
        private final Class rhs;

        public Difference(ISourceLocation src, IConstructor node, Class lhs, Class rhs) {
            super(src, node);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean isDifference() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassDifference(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.lhs.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.lhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.rhs.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Difference)) {
                return false;
            }
            Difference tmp = (Difference)o;
            return tmp.lhs.equals(this.lhs) && tmp.rhs.equals(this.rhs);
        }

        @Override
        public int hashCode() {
            return 79 + 367 * this.lhs.hashCode() + 587 * this.rhs.hashCode();
        }

        @Override
        public Class getLhs() {
            return this.lhs;
        }

        @Override
        public boolean hasLhs() {
            return true;
        }

        @Override
        public Class getRhs() {
            return this.rhs;
        }

        @Override
        public boolean hasRhs() {
            return true;
        }

        @Override
        public Object clone() {
            return Difference.newInstance(this.getClass(), this.src, null, this.clone(this.lhs), this.clone(this.rhs));
        }
    }

    public static class Complement
    extends Class {
        private final Class charClass;

        public Complement(ISourceLocation src, IConstructor node, Class charClass) {
            super(src, node);
            this.charClass = charClass;
        }

        @Override
        public boolean isComplement() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassComplement(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.charClass.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.charClass.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Complement)) {
                return false;
            }
            Complement tmp = (Complement)o;
            return tmp.charClass.equals(this.charClass);
        }

        @Override
        public int hashCode() {
            return 109 + 61 * this.charClass.hashCode();
        }

        @Override
        public Class getCharClass() {
            return this.charClass;
        }

        @Override
        public boolean hasCharClass() {
            return true;
        }

        @Override
        public Object clone() {
            return Complement.newInstance(this.getClass(), this.src, null, this.clone(this.charClass));
        }
    }

    public static class Bracket
    extends Class {
        private final Class charClass;

        public Bracket(ISourceLocation src, IConstructor node, Class charClass) {
            super(src, node);
            this.charClass = charClass;
        }

        @Override
        public boolean isBracket() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitClassBracket(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.charClass.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.charClass.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bracket)) {
                return false;
            }
            Bracket tmp = (Bracket)o;
            return tmp.charClass.equals(this.charClass);
        }

        @Override
        public int hashCode() {
            return 13 + 103 * this.charClass.hashCode();
        }

        @Override
        public Class getCharClass() {
            return this.charClass;
        }

        @Override
        public boolean hasCharClass() {
            return true;
        }

        @Override
        public Object clone() {
            return Bracket.newInstance(this.getClass(), this.src, null, this.clone(this.charClass));
        }
    }
}

