/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.FunctionBody;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Signature;
import org.rascalmpl.ast.Tags;
import org.rascalmpl.ast.Visibility;

public abstract class FunctionDeclaration
extends AbstractAST {
    public FunctionDeclaration(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasConditions() {
        return false;
    }

    public List<org.rascalmpl.ast.Expression> getConditions() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasExpression() {
        return false;
    }

    public org.rascalmpl.ast.Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasBody() {
        return false;
    }

    public FunctionBody getBody() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasSignature() {
        return false;
    }

    public Signature getSignature() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTags() {
        return false;
    }

    public Tags getTags() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasVisibility() {
        return false;
    }

    public Visibility getVisibility() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isConditional() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public static class Expression
    extends FunctionDeclaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Signature signature;
        private final org.rascalmpl.ast.Expression expression;

        public Expression(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.signature = signature;
            this.expression = expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionDeclarationExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.signature.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.signature.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression tmp = (Expression)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.signature.equals(this.signature) && tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 313 + 463 * this.tags.hashCode() + 257 * this.visibility.hashCode() + 211 * this.signature.hashCode() + 179 * this.expression.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public boolean hasSignature() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Expression.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.signature), this.clone(this.expression));
        }
    }

    public static class Default
    extends FunctionDeclaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Signature signature;
        private final FunctionBody body;

        public Default(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature, FunctionBody body) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.signature = signature;
            this.body = body;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionDeclarationDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.signature.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.signature.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.signature.equals(this.signature) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 163 + 71 * this.tags.hashCode() + 503 * this.visibility.hashCode() + 31 * this.signature.hashCode() + 181 * this.body.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public boolean hasSignature() {
            return true;
        }

        @Override
        public FunctionBody getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.signature), this.clone(this.body));
        }
    }

    public static class Conditional
    extends FunctionDeclaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Signature signature;
        private final org.rascalmpl.ast.Expression expression;
        private final List<org.rascalmpl.ast.Expression> conditions;

        public Conditional(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature, org.rascalmpl.ast.Expression expression, List<org.rascalmpl.ast.Expression> conditions) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.signature = signature;
            this.expression = expression;
            this.conditions = conditions;
        }

        @Override
        public boolean isConditional() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionDeclarationConditional(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.signature.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.signature.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.conditions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Conditional)) {
                return false;
            }
            Conditional tmp = (Conditional)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.signature.equals(this.signature) && tmp.expression.equals(this.expression) && tmp.conditions.equals(this.conditions);
        }

        @Override
        public int hashCode() {
            return 811 + 199 * this.tags.hashCode() + 5 * this.visibility.hashCode() + 157 * this.signature.hashCode() + 389 * this.expression.hashCode() + 163 * this.conditions.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public boolean hasSignature() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Expression> getConditions() {
            return this.conditions;
        }

        @Override
        public boolean hasConditions() {
            return true;
        }

        @Override
        public Object clone() {
            return Conditional.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.signature), this.clone(this.expression), this.clone(this.conditions));
        }
    }

    public static class Abstract
    extends FunctionDeclaration {
        private final Tags tags;
        private final Visibility visibility;
        private final Signature signature;

        public Abstract(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature) {
            super(src, node);
            this.tags = tags;
            this.visibility = visibility;
            this.signature = signature;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionDeclarationAbstract(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visibility.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visibility.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.signature.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.signature.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Abstract)) {
                return false;
            }
            Abstract tmp = (Abstract)o;
            return tmp.tags.equals(this.tags) && tmp.visibility.equals(this.visibility) && tmp.signature.equals(this.signature);
        }

        @Override
        public int hashCode() {
            return 211 + 727 * this.tags.hashCode() + 251 * this.visibility.hashCode() + 131 * this.signature.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean hasVisibility() {
            return true;
        }

        @Override
        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public boolean hasSignature() {
            return true;
        }

        @Override
        public Object clone() {
            return Abstract.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.visibility), this.clone(this.signature));
        }
    }
}

