/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Assignable;
import org.rascalmpl.ast.Bound;
import org.rascalmpl.ast.Case;
import org.rascalmpl.ast.Catch;
import org.rascalmpl.ast.DataTarget;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Label;
import org.rascalmpl.ast.LocalVariableDeclaration;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.Target;
import org.rascalmpl.ast.Type;

public abstract class Statement
extends AbstractAST {
    public Statement(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasCases() {
        return false;
    }

    public List<Case> getCases() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasHandlers() {
        return false;
    }

    public List<Catch> getHandlers() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasConditions() {
        return false;
    }

    public List<org.rascalmpl.ast.Expression> getConditions() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasGenerators() {
        return false;
    }

    public List<org.rascalmpl.ast.Expression> getGenerators() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasNames() {
        return false;
    }

    public List<QualifiedName> getNames() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasVariables() {
        return false;
    }

    public List<QualifiedName> getVariables() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStatements() {
        return false;
    }

    public List<Statement> getStatements() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasAssignable() {
        return false;
    }

    public Assignable getAssignable() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasOperator() {
        return false;
    }

    public org.rascalmpl.ast.Assignment getOperator() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasBound() {
        return false;
    }

    public Bound getBound() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasDataTarget() {
        return false;
    }

    public DataTarget getDataTarget() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasCondition() {
        return false;
    }

    public org.rascalmpl.ast.Expression getCondition() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasExpression() {
        return false;
    }

    public org.rascalmpl.ast.Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasMessage() {
        return false;
    }

    public org.rascalmpl.ast.Expression getMessage() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasFunctionDeclaration() {
        return false;
    }

    public org.rascalmpl.ast.FunctionDeclaration getFunctionDeclaration() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasLabel() {
        return false;
    }

    public Label getLabel() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasDeclaration() {
        return false;
    }

    public LocalVariableDeclaration getDeclaration() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasBody() {
        return false;
    }

    public Statement getBody() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasElseStatement() {
        return false;
    }

    public Statement getElseStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasFinallyBody() {
        return false;
    }

    public Statement getFinallyBody() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStatement() {
        return false;
    }

    public Statement getStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasThenStatement() {
        return false;
    }

    public Statement getThenStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTarget() {
        return false;
    }

    public Target getTarget() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasVisit() {
        return false;
    }

    public org.rascalmpl.ast.Visit getVisit() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isAppend() {
        return false;
    }

    public boolean isAssert() {
        return false;
    }

    public boolean isAssertWithMessage() {
        return false;
    }

    public boolean isAssignment() {
        return false;
    }

    public boolean isBreak() {
        return false;
    }

    public boolean isContinue() {
        return false;
    }

    public boolean isDoWhile() {
        return false;
    }

    public boolean isEmptyStatement() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isFail() {
        return false;
    }

    public boolean isFilter() {
        return false;
    }

    public boolean isFor() {
        return false;
    }

    public boolean isFunctionDeclaration() {
        return false;
    }

    public boolean isGlobalDirective() {
        return false;
    }

    public boolean isIfThen() {
        return false;
    }

    public boolean isIfThenElse() {
        return false;
    }

    public boolean isInsert() {
        return false;
    }

    public boolean isNonEmptyBlock() {
        return false;
    }

    public boolean isReturn() {
        return false;
    }

    public boolean isSolve() {
        return false;
    }

    public boolean isSwitch() {
        return false;
    }

    public boolean isThrow() {
        return false;
    }

    public boolean isTry() {
        return false;
    }

    public boolean isTryFinally() {
        return false;
    }

    public boolean isVariableDeclaration() {
        return false;
    }

    public boolean isVisit() {
        return false;
    }

    public boolean isWhile() {
        return false;
    }

    public static class While
    extends Statement {
        private final Label label;
        private final List<org.rascalmpl.ast.Expression> conditions;
        private final Statement body;

        public While(ISourceLocation src, IConstructor node, Label label, List<org.rascalmpl.ast.Expression> conditions, Statement body) {
            super(src, node);
            this.label = label;
            this.conditions = conditions;
            this.body = body;
        }

        @Override
        public boolean isWhile() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementWhile(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.conditions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof While)) {
                return false;
            }
            While tmp = (While)o;
            return tmp.label.equals(this.label) && tmp.conditions.equals(this.conditions) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 787 + 37 * this.label.hashCode() + 131 * this.conditions.hashCode() + 331 * this.body.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Expression> getConditions() {
            return this.conditions;
        }

        @Override
        public boolean hasConditions() {
            return true;
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return While.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.conditions), this.clone(this.body));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Visit
    extends Statement {
        private final Label label;
        private final org.rascalmpl.ast.Visit visit;

        public Visit(ISourceLocation src, IConstructor node, Label label, org.rascalmpl.ast.Visit visit) {
            super(src, node);
            this.label = label;
            this.visit = visit;
        }

        @Override
        public boolean isVisit() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementVisit(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.visit.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.visit.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Visit)) {
                return false;
            }
            Visit tmp = (Visit)o;
            return tmp.label.equals(this.label) && tmp.visit.equals(this.visit);
        }

        @Override
        public int hashCode() {
            return 941 + 653 * this.label.hashCode() + 13 * this.visit.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Visit getVisit() {
            return this.visit;
        }

        @Override
        public boolean hasVisit() {
            return true;
        }

        @Override
        public Object clone() {
            return Visit.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.visit));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class VariableDeclaration
    extends Statement {
        private final LocalVariableDeclaration declaration;

        public VariableDeclaration(ISourceLocation src, IConstructor node, LocalVariableDeclaration declaration) {
            super(src, node);
            this.declaration = declaration;
        }

        @Override
        public boolean isVariableDeclaration() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementVariableDeclaration(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof VariableDeclaration)) {
                return false;
            }
            VariableDeclaration tmp = (VariableDeclaration)o;
            return tmp.declaration.equals(this.declaration);
        }

        @Override
        public int hashCode() {
            return 541 + 509 * this.declaration.hashCode();
        }

        @Override
        public LocalVariableDeclaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean hasDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return VariableDeclaration.newInstance(this.getClass(), this.src, null, this.clone(this.declaration));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class TryFinally
    extends Statement {
        private final Statement body;
        private final List<Catch> handlers;
        private final Statement finallyBody;

        public TryFinally(ISourceLocation src, IConstructor node, Statement body, List<Catch> handlers, Statement finallyBody) {
            super(src, node);
            this.body = body;
            this.handlers = handlers;
            this.finallyBody = finallyBody;
        }

        @Override
        public boolean isTryFinally() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementTryFinally(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.body.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.handlers) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.finallyBody.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.finallyBody.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TryFinally)) {
                return false;
            }
            TryFinally tmp = (TryFinally)o;
            return tmp.body.equals(this.body) && tmp.handlers.equals(this.handlers) && tmp.finallyBody.equals(this.finallyBody);
        }

        @Override
        public int hashCode() {
            return 541 + 103 * this.body.hashCode() + 619 * this.handlers.hashCode() + 421 * this.finallyBody.hashCode();
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public List<Catch> getHandlers() {
            return this.handlers;
        }

        @Override
        public boolean hasHandlers() {
            return true;
        }

        @Override
        public Statement getFinallyBody() {
            return this.finallyBody;
        }

        @Override
        public boolean hasFinallyBody() {
            return true;
        }

        @Override
        public Object clone() {
            return TryFinally.newInstance(this.getClass(), this.src, null, this.clone(this.body), this.clone(this.handlers), this.clone(this.finallyBody));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Try
    extends Statement {
        private final Statement body;
        private final List<Catch> handlers;

        public Try(ISourceLocation src, IConstructor node, Statement body, List<Catch> handlers) {
            super(src, node);
            this.body = body;
            this.handlers = handlers;
        }

        @Override
        public boolean isTry() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementTry(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.body.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.handlers) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Try)) {
                return false;
            }
            Try tmp = (Try)o;
            return tmp.body.equals(this.body) && tmp.handlers.equals(this.handlers);
        }

        @Override
        public int hashCode() {
            return 157 + 283 * this.body.hashCode() + 947 * this.handlers.hashCode();
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public List<Catch> getHandlers() {
            return this.handlers;
        }

        @Override
        public boolean hasHandlers() {
            return true;
        }

        @Override
        public Object clone() {
            return Try.newInstance(this.getClass(), this.src, null, this.clone(this.body), this.clone(this.handlers));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Throw
    extends Statement {
        private final Statement statement;

        public Throw(ISourceLocation src, IConstructor node, Statement statement) {
            super(src, node);
            this.statement = statement;
        }

        @Override
        public boolean isThrow() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementThrow(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.statement.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw tmp = (Throw)o;
            return tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 389 + 229 * this.statement.hashCode();
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Throw.newInstance(this.getClass(), this.src, null, this.clone(this.statement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Switch
    extends Statement {
        private final Label label;
        private final org.rascalmpl.ast.Expression expression;
        private final List<Case> cases;

        public Switch(ISourceLocation src, IConstructor node, Label label, org.rascalmpl.ast.Expression expression, List<Case> cases) {
            super(src, node);
            this.label = label;
            this.expression = expression;
            this.cases = cases;
        }

        @Override
        public boolean isSwitch() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementSwitch(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.cases) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch tmp = (Switch)o;
            return tmp.label.equals(this.label) && tmp.expression.equals(this.expression) && tmp.cases.equals(this.cases);
        }

        @Override
        public int hashCode() {
            return 593 + 109 * this.label.hashCode() + 53 * this.expression.hashCode() + 839 * this.cases.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public List<Case> getCases() {
            return this.cases;
        }

        @Override
        public boolean hasCases() {
            return true;
        }

        @Override
        public Object clone() {
            return Switch.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.expression), this.clone(this.cases));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Solve
    extends Statement {
        private final List<QualifiedName> variables;
        private final Bound bound;
        private final Statement body;

        public Solve(ISourceLocation src, IConstructor node, List<QualifiedName> variables, Bound bound, Statement body) {
            super(src, node);
            this.variables = variables;
            this.bound = bound;
            this.body = body;
        }

        @Override
        public boolean isSolve() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementSolve(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.variables) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.bound.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.bound.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Solve)) {
                return false;
            }
            Solve tmp = (Solve)o;
            return tmp.variables.equals(this.variables) && tmp.bound.equals(this.bound) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 643 + 619 * this.variables.hashCode() + 631 * this.bound.hashCode() + 151 * this.body.hashCode();
        }

        @Override
        public List<QualifiedName> getVariables() {
            return this.variables;
        }

        @Override
        public boolean hasVariables() {
            return true;
        }

        @Override
        public Bound getBound() {
            return this.bound;
        }

        @Override
        public boolean hasBound() {
            return true;
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return Solve.newInstance(this.getClass(), this.src, null, this.clone(this.variables), this.clone(this.bound), this.clone(this.body));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Return
    extends Statement {
        private final Statement statement;

        public Return(ISourceLocation src, IConstructor node, Statement statement) {
            super(src, node);
            this.statement = statement;
        }

        @Override
        public boolean isReturn() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementReturn(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.statement.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Return)) {
                return false;
            }
            Return tmp = (Return)o;
            return tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 389 + 367 * this.statement.hashCode();
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Return.newInstance(this.getClass(), this.src, null, this.clone(this.statement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class NonEmptyBlock
    extends Statement {
        private final Label label;
        private final List<Statement> statements;

        public NonEmptyBlock(ISourceLocation src, IConstructor node, Label label, List<Statement> statements) {
            super(src, node);
            this.label = label;
            this.statements = statements;
        }

        @Override
        public boolean isNonEmptyBlock() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementNonEmptyBlock(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.statements) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NonEmptyBlock)) {
                return false;
            }
            NonEmptyBlock tmp = (NonEmptyBlock)o;
            return tmp.label.equals(this.label) && tmp.statements.equals(this.statements);
        }

        @Override
        public int hashCode() {
            return 641 + 227 * this.label.hashCode() + 269 * this.statements.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public List<Statement> getStatements() {
            return this.statements;
        }

        @Override
        public boolean hasStatements() {
            return true;
        }

        @Override
        public Object clone() {
            return NonEmptyBlock.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.statements));
        }
    }

    public static class Insert
    extends Statement {
        private final DataTarget dataTarget;
        private final Statement statement;

        public Insert(ISourceLocation src, IConstructor node, DataTarget dataTarget, Statement statement) {
            super(src, node);
            this.dataTarget = dataTarget;
            this.statement = statement;
        }

        @Override
        public boolean isInsert() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementInsert(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.dataTarget.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.dataTarget.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.statement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Insert)) {
                return false;
            }
            Insert tmp = (Insert)o;
            return tmp.dataTarget.equals(this.dataTarget) && tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 757 + 439 * this.dataTarget.hashCode() + 239 * this.statement.hashCode();
        }

        @Override
        public DataTarget getDataTarget() {
            return this.dataTarget;
        }

        @Override
        public boolean hasDataTarget() {
            return true;
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Insert.newInstance(this.getClass(), this.src, null, this.clone(this.dataTarget), this.clone(this.statement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class IfThenElse
    extends Statement {
        private final Label label;
        private final List<org.rascalmpl.ast.Expression> conditions;
        private final Statement thenStatement;
        private final Statement elseStatement;

        public IfThenElse(ISourceLocation src, IConstructor node, Label label, List<org.rascalmpl.ast.Expression> conditions, Statement thenStatement, Statement elseStatement) {
            super(src, node);
            this.label = label;
            this.conditions = conditions;
            this.thenStatement = thenStatement;
            this.elseStatement = elseStatement;
        }

        @Override
        public boolean isIfThenElse() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementIfThenElse(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.conditions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.thenStatement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.thenStatement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.elseStatement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.elseStatement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IfThenElse)) {
                return false;
            }
            IfThenElse tmp = (IfThenElse)o;
            return tmp.label.equals(this.label) && tmp.conditions.equals(this.conditions) && tmp.thenStatement.equals(this.thenStatement) && tmp.elseStatement.equals(this.elseStatement);
        }

        @Override
        public int hashCode() {
            return 149 + 569 * this.label.hashCode() + 617 * this.conditions.hashCode() + 389 * this.thenStatement.hashCode() + 757 * this.elseStatement.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Expression> getConditions() {
            return this.conditions;
        }

        @Override
        public boolean hasConditions() {
            return true;
        }

        @Override
        public Statement getThenStatement() {
            return this.thenStatement;
        }

        @Override
        public boolean hasThenStatement() {
            return true;
        }

        @Override
        public Statement getElseStatement() {
            return this.elseStatement;
        }

        @Override
        public boolean hasElseStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return IfThenElse.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.conditions), this.clone(this.thenStatement), this.clone(this.elseStatement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class IfThen
    extends Statement {
        private final Label label;
        private final List<org.rascalmpl.ast.Expression> conditions;
        private final Statement thenStatement;

        public IfThen(ISourceLocation src, IConstructor node, Label label, List<org.rascalmpl.ast.Expression> conditions, Statement thenStatement) {
            super(src, node);
            this.label = label;
            this.conditions = conditions;
            this.thenStatement = thenStatement;
        }

        @Override
        public boolean isIfThen() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementIfThen(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.conditions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.thenStatement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.thenStatement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IfThen)) {
                return false;
            }
            IfThen tmp = (IfThen)o;
            return tmp.label.equals(this.label) && tmp.conditions.equals(this.conditions) && tmp.thenStatement.equals(this.thenStatement);
        }

        @Override
        public int hashCode() {
            return 461 + 929 * this.label.hashCode() + 199 * this.conditions.hashCode() + 569 * this.thenStatement.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Expression> getConditions() {
            return this.conditions;
        }

        @Override
        public boolean hasConditions() {
            return true;
        }

        @Override
        public Statement getThenStatement() {
            return this.thenStatement;
        }

        @Override
        public boolean hasThenStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return IfThen.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.conditions), this.clone(this.thenStatement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class GlobalDirective
    extends Statement {
        private final Type type;
        private final List<QualifiedName> names;

        public GlobalDirective(ISourceLocation src, IConstructor node, Type type, List<QualifiedName> names) {
            super(src, node);
            this.type = type;
            this.names = names;
        }

        @Override
        public boolean isGlobalDirective() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementGlobalDirective(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.names) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof GlobalDirective)) {
                return false;
            }
            GlobalDirective tmp = (GlobalDirective)o;
            return tmp.type.equals(this.type) && tmp.names.equals(this.names);
        }

        @Override
        public int hashCode() {
            return 73 + 457 * this.type.hashCode() + 719 * this.names.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public List<QualifiedName> getNames() {
            return this.names;
        }

        @Override
        public boolean hasNames() {
            return true;
        }

        @Override
        public Object clone() {
            return GlobalDirective.newInstance(this.getClass(), this.src, null, this.clone(this.type), this.clone(this.names));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class FunctionDeclaration
    extends Statement {
        private final org.rascalmpl.ast.FunctionDeclaration functionDeclaration;

        public FunctionDeclaration(ISourceLocation src, IConstructor node, org.rascalmpl.ast.FunctionDeclaration functionDeclaration) {
            super(src, node);
            this.functionDeclaration = functionDeclaration;
        }

        @Override
        public boolean isFunctionDeclaration() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementFunctionDeclaration(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.functionDeclaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.functionDeclaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FunctionDeclaration)) {
                return false;
            }
            FunctionDeclaration tmp = (FunctionDeclaration)o;
            return tmp.functionDeclaration.equals(this.functionDeclaration);
        }

        @Override
        public int hashCode() {
            return 691 + 691 * this.functionDeclaration.hashCode();
        }

        @Override
        public org.rascalmpl.ast.FunctionDeclaration getFunctionDeclaration() {
            return this.functionDeclaration;
        }

        @Override
        public boolean hasFunctionDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return FunctionDeclaration.newInstance(this.getClass(), this.src, null, this.clone(this.functionDeclaration));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class For
    extends Statement {
        private final Label label;
        private final List<org.rascalmpl.ast.Expression> generators;
        private final Statement body;

        public For(ISourceLocation src, IConstructor node, Label label, List<org.rascalmpl.ast.Expression> generators, Statement body) {
            super(src, node);
            this.label = label;
            this.generators = generators;
            this.body = body;
        }

        @Override
        public boolean isFor() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementFor(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.generators) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof For)) {
                return false;
            }
            For tmp = (For)o;
            return tmp.label.equals(this.label) && tmp.generators.equals(this.generators) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 113 + 607 * this.label.hashCode() + 151 * this.generators.hashCode() + 409 * this.body.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public List<org.rascalmpl.ast.Expression> getGenerators() {
            return this.generators;
        }

        @Override
        public boolean hasGenerators() {
            return true;
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return For.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.generators), this.clone(this.body));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Filter
    extends Statement {
        public Filter(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isFilter() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementFilter(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter tmp = (Filter)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 193;
        }

        @Override
        public Object clone() {
            return Filter.newInstance(this.getClass(), this.src, null);
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Fail
    extends Statement {
        private final Target target;

        public Fail(ISourceLocation src, IConstructor node, Target target) {
            super(src, node);
            this.target = target;
        }

        @Override
        public boolean isFail() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementFail(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.target.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.target.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Fail)) {
                return false;
            }
            Fail tmp = (Fail)o;
            return tmp.target.equals(this.target);
        }

        @Override
        public int hashCode() {
            return 479 + 691 * this.target.hashCode();
        }

        @Override
        public Target getTarget() {
            return this.target;
        }

        @Override
        public boolean hasTarget() {
            return true;
        }

        @Override
        public Object clone() {
            return Fail.newInstance(this.getClass(), this.src, null, this.clone(this.target));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Expression
    extends Statement {
        private final org.rascalmpl.ast.Expression expression;

        public Expression(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.expression = expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.expression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression tmp = (Expression)o;
            return tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 67 + 757 * this.expression.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Expression.newInstance(this.getClass(), this.src, null, this.clone(this.expression));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class EmptyStatement
    extends Statement {
        public EmptyStatement(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isEmptyStatement() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementEmptyStatement(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof EmptyStatement)) {
                return false;
            }
            EmptyStatement tmp = (EmptyStatement)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 433;
        }

        @Override
        public Object clone() {
            return EmptyStatement.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class DoWhile
    extends Statement {
        private final Label label;
        private final Statement body;
        private final org.rascalmpl.ast.Expression condition;

        public DoWhile(ISourceLocation src, IConstructor node, Label label, Statement body, org.rascalmpl.ast.Expression condition) {
            super(src, node);
            this.label = label;
            this.body = body;
            this.condition = condition;
        }

        @Override
        public boolean isDoWhile() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementDoWhile(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.label.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.condition.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.condition.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DoWhile)) {
                return false;
            }
            DoWhile tmp = (DoWhile)o;
            return tmp.label.equals(this.label) && tmp.body.equals(this.body) && tmp.condition.equals(this.condition);
        }

        @Override
        public int hashCode() {
            return 823 + 859 * this.label.hashCode() + 181 * this.body.hashCode() + 677 * this.condition.hashCode();
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getCondition() {
            return this.condition;
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Object clone() {
            return DoWhile.newInstance(this.getClass(), this.src, null, this.clone(this.label), this.clone(this.body), this.clone(this.condition));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Continue
    extends Statement {
        private final Target target;

        public Continue(ISourceLocation src, IConstructor node, Target target) {
            super(src, node);
            this.target = target;
        }

        @Override
        public boolean isContinue() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementContinue(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.target.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.target.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue tmp = (Continue)o;
            return tmp.target.equals(this.target);
        }

        @Override
        public int hashCode() {
            return 193 + 881 * this.target.hashCode();
        }

        @Override
        public Target getTarget() {
            return this.target;
        }

        @Override
        public boolean hasTarget() {
            return true;
        }

        @Override
        public Object clone() {
            return Continue.newInstance(this.getClass(), this.src, null, this.clone(this.target));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Break
    extends Statement {
        private final Target target;

        public Break(ISourceLocation src, IConstructor node, Target target) {
            super(src, node);
            this.target = target;
        }

        @Override
        public boolean isBreak() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementBreak(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.target.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.target.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Break)) {
                return false;
            }
            Break tmp = (Break)o;
            return tmp.target.equals(this.target);
        }

        @Override
        public int hashCode() {
            return 3 + 757 * this.target.hashCode();
        }

        @Override
        public Target getTarget() {
            return this.target;
        }

        @Override
        public boolean hasTarget() {
            return true;
        }

        @Override
        public Object clone() {
            return Break.newInstance(this.getClass(), this.src, null, this.clone(this.target));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Assignment
    extends Statement {
        private final Assignable assignable;
        private final org.rascalmpl.ast.Assignment operator;
        private final Statement statement;

        public Assignment(ISourceLocation src, IConstructor node, Assignable assignable, org.rascalmpl.ast.Assignment operator, Statement statement) {
            super(src, node);
            this.assignable = assignable;
            this.operator = operator;
            this.statement = statement;
        }

        @Override
        public boolean isAssignment() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementAssignment(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.assignable.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.assignable.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.operator.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.operator.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.statement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Assignment)) {
                return false;
            }
            Assignment tmp = (Assignment)o;
            return tmp.assignable.equals(this.assignable) && tmp.operator.equals(this.operator) && tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 73 + 677 * this.assignable.hashCode() + 89 * this.operator.hashCode() + 599 * this.statement.hashCode();
        }

        @Override
        public Assignable getAssignable() {
            return this.assignable;
        }

        @Override
        public boolean hasAssignable() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Assignment getOperator() {
            return this.operator;
        }

        @Override
        public boolean hasOperator() {
            return true;
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Assignment.newInstance(this.getClass(), this.src, null, this.clone(this.assignable), this.clone(this.operator), this.clone(this.statement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class AssertWithMessage
    extends Statement {
        private final org.rascalmpl.ast.Expression expression;
        private final org.rascalmpl.ast.Expression message;

        public AssertWithMessage(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression, org.rascalmpl.ast.Expression message) {
            super(src, node);
            this.expression = expression;
            this.message = message;
        }

        @Override
        public boolean isAssertWithMessage() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementAssertWithMessage(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.expression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.message.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.message.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AssertWithMessage)) {
                return false;
            }
            AssertWithMessage tmp = (AssertWithMessage)o;
            return tmp.expression.equals(this.expression) && tmp.message.equals(this.message);
        }

        @Override
        public int hashCode() {
            return 547 + 97 * this.expression.hashCode() + 607 * this.message.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getMessage() {
            return this.message;
        }

        @Override
        public boolean hasMessage() {
            return true;
        }

        @Override
        public Object clone() {
            return AssertWithMessage.newInstance(this.getClass(), this.src, null, this.clone(this.expression), this.clone(this.message));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Assert
    extends Statement {
        private final org.rascalmpl.ast.Expression expression;

        public Assert(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.expression = expression;
        }

        @Override
        public boolean isAssert() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementAssert(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.expression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert tmp = (Assert)o;
            return tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 283 + 739 * this.expression.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Assert.newInstance(this.getClass(), this.src, null, this.clone(this.expression));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }

    public static class Append
    extends Statement {
        private final DataTarget dataTarget;
        private final Statement statement;

        public Append(ISourceLocation src, IConstructor node, DataTarget dataTarget, Statement statement) {
            super(src, node);
            this.dataTarget = dataTarget;
            this.statement = statement;
        }

        @Override
        public boolean isAppend() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStatementAppend(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.dataTarget.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.dataTarget.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.statement.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Append)) {
                return false;
            }
            Append tmp = (Append)o;
            return tmp.dataTarget.equals(this.dataTarget) && tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 19 + 787 * this.dataTarget.hashCode() + 457 * this.statement.hashCode();
        }

        @Override
        public DataTarget getDataTarget() {
            return this.dataTarget;
        }

        @Override
        public boolean hasDataTarget() {
            return true;
        }

        @Override
        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Append.newInstance(this.getClass(), this.src, null, this.clone(this.dataTarget), this.clone(this.statement));
        }

        @Override
        public boolean isBreakable() {
            return true;
        }
    }
}

