/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.matching.IBooleanResult;

public class EquivalenceResult
extends AbstractBooleanResult {
    private final IBooleanResult left;
    private final IBooleanResult right;
    private boolean firstMatch = true;
    private boolean leftResult;

    public EquivalenceResult(IEvaluatorContext ctx, IBooleanResult left, IBooleanResult right) {
        super(ctx);
        this.left = left;
        this.right = right;
    }

    @Override
    public void init() {
        super.init();
        this.left.init();
        this.right.init();
        this.firstMatch = true;
        this.leftResult = false;
    }

    @Override
    public boolean hasNext() {
        if (this.firstMatch) {
            return this.left.hasNext() && this.right.hasNext();
        }
        return this.right.hasNext() || this.left.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        if (this.firstMatch) {
            boolean rightResult;
            this.firstMatch = false;
            Environment old = this.ctx.getCurrentEnvt();
            try {
                this.ctx.pushEnv();
                this.leftResult = this.left.next();
            }
            finally {
                this.ctx.unwind(old);
            }
            try {
                this.ctx.pushEnv();
                rightResult = this.right.next();
            }
            finally {
                this.ctx.unwind(old);
            }
            return this.leftResult == rightResult;
        }
        if (this.right.hasNext()) {
            Environment old = this.ctx.getCurrentEnvt();
            try {
                this.ctx.pushEnv();
                boolean bl = this.leftResult == this.right.next();
                return bl;
            }
            finally {
                this.ctx.unwind(old);
            }
        }
        Environment old = this.ctx.getCurrentEnvt();
        try {
            this.ctx.pushEnv();
            this.leftResult = this.left.next();
        }
        finally {
            this.ctx.unwind(old);
        }
        try {
            this.right.init();
            boolean bl = this.leftResult == this.right.next();
            return bl;
        }
        finally {
            this.ctx.unwind(old);
        }
    }
}

