/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.ConcreteListVariablePattern;
import org.rascalmpl.interpreter.matching.DesignatedTypedMultiVariablePattern;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.MultiVariablePattern;
import org.rascalmpl.interpreter.matching.QualifiedNamePattern;
import org.rascalmpl.interpreter.matching.TypedMultiVariablePattern;
import org.rascalmpl.interpreter.matching.VariableBecomesPattern;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public class ListPattern
extends AbstractMatchingResult {
    private List<IMatchingResult> patternChildren;
    private int patternSize;
    private int delta = 1;
    private int reducedPatternSize;
    private IList listSubject;
    private Type listSubjectType;
    private int subjectSize;
    private int reducedSubjectSize;
    private boolean[] isListVar;
    private boolean[] isBindingVar;
    private boolean[] plusList;
    private String[] varName;
    private HashSet<String> allVars;
    private int[] listVarStart;
    private int[] listVarLength;
    private int[] listVarMinLength;
    private int[] listVarMaxLength;
    private int[] listVarOccurrences;
    private int subjectCursor;
    private int patternCursor;
    private boolean firstMatch;
    private boolean forward;
    private boolean debug = false;
    private Type staticListSubjectElementType;
    private Type staticListSubjectType;
    private final boolean bindTypeParameters;

    public ListPattern(IEvaluatorContext ctx, AbstractAST x, List<IMatchingResult> list, boolean bindTypeParameters) {
        this(ctx, x, list, 1, bindTypeParameters);
    }

    ListPattern(IEvaluatorContext ctx, AbstractAST x, List<IMatchingResult> list, int delta, boolean bindTypeParameters) {
        super(ctx, x);
        if (delta < 1) {
            throw new ImplementationError("Wrong delta");
        }
        this.bindTypeParameters = bindTypeParameters;
        this.delta = delta;
        this.patternChildren = list;
        this.patternSize = list.size();
        this.reducedPatternSize = (this.patternSize + delta - 1) / delta;
        if (this.debug) {
            System.err.println("patternSize=" + this.patternSize);
            System.err.println("reducedPatternSize=" + this.reducedPatternSize);
        }
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        for (int i = 0; i < this.patternChildren.size(); i += this.delta) {
            res.addAll(this.patternChildren.get(i).getVariables());
        }
        return res;
    }

    public static boolean isAnyListType(Type type) {
        return type.isList() || ListPattern.isConcreteListType(type);
    }

    public static boolean isConcreteListType(Type type) {
        if (type instanceof NonTerminalType) {
            IConstructor sym = ((NonTerminalType)type).getSymbol();
            return SymbolAdapter.isAnyList(sym);
        }
        return false;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        int i;
        if (this.debug) {
            System.err.println("List: initMatch: subject=" + subject);
        }
        super.initMatch(subject);
        if (!subject.getValue().getType().isList()) {
            this.hasNext = false;
            return;
        }
        this.listSubject = (IList)subject.getValue();
        this.listSubjectType = this.listSubject.getType();
        this.staticListSubjectType = subject.getStaticType();
        this.staticListSubjectElementType = this.staticListSubjectType.isList() ? subject.getStaticType().getElementType() : this.tf.valueType();
        this.subjectCursor = 0;
        this.patternCursor = 0;
        this.subjectSize = ((IList)subject.getValue()).length();
        this.reducedSubjectSize = (this.subjectSize + this.delta - 1) / this.delta;
        if (this.debug) {
            System.err.println("reducedPatternSize=" + this.reducedPatternSize);
            System.err.println("reducedSubjectSize=" + this.reducedSubjectSize);
        }
        this.isListVar = new boolean[this.patternSize];
        this.plusList = new boolean[this.patternSize];
        this.isBindingVar = new boolean[this.patternSize];
        this.varName = new String[this.patternSize];
        this.allVars = new HashSet();
        this.listVarStart = new int[this.patternSize];
        this.listVarLength = new int[this.patternSize];
        this.listVarMinLength = new int[this.patternSize];
        this.listVarMaxLength = new int[this.patternSize];
        this.listVarOccurrences = new int[this.patternSize];
        int nListVar = 0;
        for (i = 0; i < this.patternSize; i += this.delta) {
            List<IVarPattern> childVars;
            Type varType;
            IRascalResult varRes;
            String name;
            IMatchingResult child = this.patternChildren.get(i);
            this.isListVar[i] = false;
            this.plusList[i] = false;
            this.isBindingVar[i] = false;
            Environment env = this.ctx.getCurrentEnvt();
            if (child instanceof TypedMultiVariablePattern) {
                TypedMultiVariablePattern tmv = (TypedMultiVariablePattern)child;
                child = new DesignatedTypedMultiVariablePattern(this.ctx, (Expression)tmv.getAST(), this.tf.listType(tmv.getType(env, null)), tmv.getName(), this.bindTypeParameters);
                this.patternChildren.set(i, child);
            }
            if (child instanceof DesignatedTypedMultiVariablePattern) {
                String name2;
                DesignatedTypedMultiVariablePattern tmvVar = (DesignatedTypedMultiVariablePattern)child;
                Type tmvType = child.getType(env, null);
                this.varName[i] = name2 = tmvVar.getName();
                this.isListVar[i] = true;
                this.listVarOccurrences[i] = 1;
                ++nListVar;
                if (!tmvVar.isAnonymous() && this.allVars.contains(name2)) {
                    throw new RedeclaredVariable(name2, this.getAST());
                }
                if (tmvType.comparable(this.listSubject.getType())) {
                    if (!tmvVar.isAnonymous()) {
                        this.allVars.add(name2);
                    }
                    this.isBindingVar[i] = true;
                    continue;
                }
                this.hasNext = false;
                return;
            }
            if (child instanceof MultiVariablePattern) {
                MultiVariablePattern multiVar = (MultiVariablePattern)child;
                this.varName[i] = name = multiVar.getName();
                this.isListVar[i] = true;
                ++nListVar;
                if (!multiVar.isAnonymous() && this.allVars.contains(name)) {
                    this.isBindingVar[i] = false;
                    continue;
                }
                if (multiVar.isAnonymous()) {
                    this.isBindingVar[i] = true;
                    continue;
                }
                this.allVars.add(name);
                varRes = env.getFrameVariable(name);
                if (varRes == null || multiVar.bindingInstance()) {
                    this.isBindingVar[i] = true;
                    continue;
                }
                this.isBindingVar[i] = false;
                varType = ((Result)varRes).getStaticType();
                if (!ListPattern.isAnyListType(varType) || varType.comparable(this.listSubjectType)) continue;
                this.hasNext = false;
                return;
            }
            if (child instanceof ConcreteListVariablePattern) {
                ConcreteListVariablePattern listVar = (ConcreteListVariablePattern)child;
                this.varName[i] = name = listVar.getName();
                this.isListVar[i] = true;
                if (!listVar.isAnonymous()) {
                    this.allVars.add(name);
                }
                this.plusList[i] = listVar.isPlusList();
                this.isBindingVar[i] = true;
                this.listVarOccurrences[i] = 1;
                ++nListVar;
                continue;
            }
            if (child instanceof QualifiedNamePattern) {
                QualifiedNamePattern qualName = (QualifiedNamePattern)child;
                this.varName[i] = name = qualName.getName();
                if (!qualName.isAnonymous() && this.allVars.contains(name)) {
                    this.isListVar[i] = true;
                    ++nListVar;
                    int n = i;
                    this.listVarOccurrences[n] = this.listVarOccurrences[n] + 1;
                    continue;
                }
                if (qualName.isAnonymous() || (varRes = env.getFrameVariable(name)) == null || qualName.bindingInstance()) continue;
                varType = ((Result)varRes).getStaticType();
                if (ListPattern.isAnyListType(varType)) {
                    if (varType.comparable(this.listSubjectType)) {
                        this.isListVar[i] = true;
                        this.isBindingVar[i] = ((Result)varRes).getValue() == null;
                        ++nListVar;
                        continue;
                    }
                    this.hasNext = false;
                    return;
                }
                if (varType instanceof NonTerminalType || varType.comparable(this.staticListSubjectElementType)) continue;
                this.hasNext = false;
                return;
            }
            if (child instanceof VariableBecomesPattern) continue;
            if (this.debug) {
                System.err.println("List: child " + child);
                System.err.println("List: child is a" + child.getClass());
            }
            if ((childVars = child.getVariables()).isEmpty()) continue;
            for (IVarPattern vp : childVars) {
                this.allVars.add(vp.name());
            }
            this.isListVar[i] = false;
            ++nListVar;
        }
        for (i = 0; i < this.patternSize; i += this.delta) {
            if (!this.isListVar[i]) continue;
            this.listVarLength[i] = this.plusList[i] ? 1 : 0;
            this.listVarMaxLength[i] = this.delta * Math.max(this.reducedSubjectSize - (this.reducedPatternSize - nListVar), 0);
            this.listVarMinLength[i] = this.delta * (nListVar == 1 ? Math.max(this.reducedSubjectSize - this.reducedPatternSize - 1, this.listVarLength[i]) : this.listVarLength[i]);
            if (!this.debug) continue;
            System.err.println("listvar " + i + " min= " + this.listVarMinLength[i] + " max=" + this.listVarMaxLength[i]);
        }
        this.firstMatch = true;
        boolean bl = this.hasNext = subject.getValue().getType().isList() && this.reducedSubjectSize >= this.reducedPatternSize - nListVar;
        if (this.debug) {
            System.err.println("List: hasNext=" + this.hasNext);
        }
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        if (this.patternSize == 0) {
            return this.tf.listType(this.tf.voidType());
        }
        Type elemType = this.tf.voidType();
        for (int i = 0; i < this.patternSize; i += this.delta) {
            IMatchingResult child = this.patternChildren.get(i);
            Type childType = child.getType(env, patternVars);
            patternVars = this.merge(patternVars, this.patternChildren.get(i).getVariables());
            boolean isMultiVar = child instanceof MultiVariablePattern || child instanceof DesignatedTypedMultiVariablePattern;
            elemType = childType.isList() && isMultiVar ? elemType.lub(childType.getElementType()) : elemType.lub(childType);
        }
        if (this.debug) {
            System.err.println("ListPattern.getType: " + this.tf.listType(elemType));
        }
        return this.tf.listType(elemType);
    }

    @Override
    public boolean hasNext() {
        if (this.debug) {
            System.err.println("List: hasNext=" + (this.initialized && this.hasNext));
        }
        return this.initialized && this.hasNext;
    }

    private void matchBoundListVar(IList previousBinding) {
        if (this.debug) {
            System.err.println("matchBoundListVar: " + previousBinding);
        }
        assert (this.isListVar[this.patternCursor]);
        int start = this.listVarStart[this.patternCursor];
        int length = this.listVarLength[this.patternCursor];
        for (int i = 0; i < previousBinding.length(); i += this.delta) {
            if (this.debug) {
                System.err.println("comparing: " + previousBinding.get(i) + " and " + this.listSubject.get(this.subjectCursor + i));
            }
            if (previousBinding.get(i).equals(this.listSubject.get(this.subjectCursor + i))) continue;
            this.forward = false;
            this.listVarLength[this.patternCursor] = 0;
            this.patternCursor -= this.delta;
            if (this.debug) {
                System.err.println("child fails");
            }
            return;
        }
        this.subjectCursor = start + length;
        if (this.debug) {
            System.err.println("child matches, subjectCursor=" + this.subjectCursor);
        }
        this.patternCursor += this.delta;
    }

    private IList makeSubList(int start, int length) {
        assert (this.isListVar[this.patternCursor]);
        if (start > this.subjectSize) {
            return this.listSubject.sublist(0, 0);
        }
        return this.listSubject.sublist(start, length);
    }

    private void matchBindingListVar(IMatchingResult child) {
        int reducedLength;
        assert (this.isListVar[this.patternCursor]);
        int start = this.listVarStart[this.patternCursor];
        int length = this.listVarLength[this.patternCursor];
        int n = reducedLength = length <= 1 ? length : length - (length - 1) % this.delta;
        if (this.debug) {
            System.err.println("length=" + length);
            System.err.println("reducedLength=" + reducedLength);
        }
        IList sublist = this.makeSubList(start, reducedLength);
        if (this.debug) {
            System.err.println("matchBindingListVar: init child #" + this.patternCursor + " (" + child + ") with " + sublist);
        }
        child.initMatch(ResultFactory.makeResult(sublist.getType(), sublist, this.ctx));
        if (child.next()) {
            this.subjectCursor = start + length;
            if (this.debug) {
                System.err.println("child matches, subjectCursor=" + this.subjectCursor);
            }
            this.patternCursor += this.delta;
        } else {
            this.forward = false;
            this.listVarLength[this.patternCursor] = 0;
            this.patternCursor -= this.delta;
            if (this.debug) {
                System.err.println("child fails, subjectCursor=" + this.subjectCursor);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.debug) {
            System.err.println("List.next: entering");
        }
        this.checkInitialized();
        if (this.debug) {
            System.err.println("AbstractPatternList.match: " + this.subject);
        }
        if (!this.hasNext) {
            return false;
        }
        this.forward = this.firstMatch;
        this.firstMatch = false;
        while (true) {
            if (this.debug) {
                System.err.println("List.do: patternCursor=" + this.patternCursor + ", subjectCursor=" + this.subjectCursor);
            }
            if (this.forward) {
                if (this.patternCursor >= this.patternSize) {
                    if (this.subjectCursor >= this.subjectSize) {
                        if (this.debug) {
                            System.err.println(">>> match returns true");
                        }
                        return true;
                    }
                    this.forward = false;
                    this.patternCursor -= this.delta;
                }
            } else if (this.patternCursor >= this.patternSize) {
                this.patternCursor -= this.delta;
                this.subjectCursor -= this.delta;
            }
            if (this.patternCursor < 0 || this.subjectCursor < 0) {
                this.hasNext = false;
                if (this.debug) {
                    System.err.println(">>> match returns false: patternCursor=" + this.patternCursor + ", forward=" + this.forward + ", subjectCursor=" + this.subjectCursor);
                }
                return false;
            }
            IMatchingResult child = this.patternChildren.get(this.patternCursor);
            if (this.debug) {
                System.err.println(this);
                System.err.println("loop: patternCursor=" + this.patternCursor + ", forward=" + this.forward + ", subjectCursor= " + this.subjectCursor + ", child=" + child + ", isListVar=" + this.isListVar[this.patternCursor] + ", class=" + child.getClass());
            }
            if (this.isListVar[this.patternCursor] && this.isBindingVar[this.patternCursor]) {
                if (this.forward) {
                    this.listVarStart[this.patternCursor] = this.subjectCursor;
                    if (this.patternCursor == this.patternSize - 1) {
                        if (this.debug) {
                            System.err.println("subjectSize=" + this.subjectSize);
                            System.err.println("subjectCursor=" + this.subjectCursor);
                        }
                        this.listVarLength[this.patternCursor] = Math.max(this.subjectSize - this.subjectCursor, 0);
                    } else {
                        this.listVarLength[this.patternCursor] = this.listVarMinLength[this.patternCursor];
                    }
                } else {
                    int n = this.patternCursor;
                    this.listVarLength[n] = this.listVarLength[n] + this.delta;
                    this.forward = true;
                }
                if (this.debug) {
                    System.err.println("list var: start: " + this.listVarStart[this.patternCursor] + ", len=" + this.listVarLength[this.patternCursor] + ", minlen=" + this.listVarMinLength[this.patternCursor] + ", maxlen=" + this.listVarMaxLength[this.patternCursor]);
                }
                if (this.listVarLength[this.patternCursor] > this.listVarMaxLength[this.patternCursor] || this.listVarStart[this.patternCursor] + this.listVarLength[this.patternCursor] >= this.subjectSize + this.delta) {
                    this.subjectCursor = this.listVarStart[this.patternCursor];
                    if (this.debug) {
                        System.err.println("Length failure, subjectCursor=" + this.subjectCursor);
                    }
                    this.forward = false;
                    this.listVarLength[this.patternCursor] = 0;
                    this.patternCursor -= this.delta;
                    continue;
                }
                this.matchBindingListVar(child);
                continue;
            }
            if (this.isListVar[this.patternCursor] && !this.isBindingVar[this.patternCursor] && ((Result)this.ctx.getCurrentEnvt().getFrameVariable(this.varName[this.patternCursor])).getStaticType().isList()) {
                if (this.forward) {
                    int varLength;
                    this.listVarStart[this.patternCursor] = this.subjectCursor;
                    IRascalResult varRes = this.ctx.getCurrentEnvt().getFrameVariable(this.varName[this.patternCursor]);
                    Object varVal = ((Result)varRes).getValue();
                    if (!((Result)varRes).getStaticType().isList()) continue;
                    assert (varVal != null && varVal.getType().isList());
                    this.listVarLength[this.patternCursor] = varLength = ((IList)varVal).length();
                    if (this.subjectCursor + varLength > this.subjectSize) {
                        this.forward = false;
                        this.patternCursor -= this.delta;
                        continue;
                    }
                    this.matchBoundListVar((IList)varVal);
                    continue;
                }
                this.subjectCursor = this.listVarStart[this.patternCursor];
                this.patternCursor -= this.delta;
                continue;
            }
            if (this.forward && this.subjectCursor < this.subjectSize) {
                if (this.debug) {
                    System.err.println("AbstractPatternList.match: init child " + this.patternCursor + " with " + this.listSubject.get(this.subjectCursor));
                }
                IValue childValue = this.listSubject.get(this.subjectCursor);
                child.initMatch(ResultFactory.makeResult(childValue.getType(), childValue, this.ctx));
                if (child.next()) {
                    this.subjectCursor += this.delta;
                    this.patternCursor += this.delta;
                    if (!this.debug) continue;
                    System.err.println("AbstractPatternList.match: child matches, subjectCursor=" + this.subjectCursor);
                    continue;
                }
                this.forward = false;
                this.patternCursor -= this.delta;
                continue;
            }
            if (this.subjectCursor < this.subjectSize && child.next()) {
                if (this.debug) {
                    System.err.println("child has next:" + child);
                }
                this.forward = true;
                this.subjectCursor += this.delta;
                this.patternCursor += this.delta;
                continue;
            }
            if (this.debug) {
                System.err.println("child has no next:" + child);
            }
            this.forward = false;
            this.subjectCursor -= this.delta;
            this.patternCursor -= this.delta;
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("[");
        if (this.initialized) {
            String sep = "";
            for (int i = 0; i < Math.min(this.patternCursor, this.patternSize); ++i) {
                s2.append(sep).append(this.patternChildren.get(i).toString());
                sep = ", ";
            }
            if (this.patternCursor < this.patternSize) {
                s2.append("...");
            }
            s2.append("]").append("==").append(this.subject.toString());
        } else {
            s2.append("**uninitialized**]");
        }
        return s2.toString();
    }
}

