/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.Random;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;

public class Math {
    private final IValueFactory values;
    private final Random random;

    public Math(IValueFactory values) {
        this.values = values;
        this.random = new Random();
    }

    public IValue arbInt() {
        return this.values.integer(this.random.nextInt());
    }

    public IValue arbInt(IInteger limit) {
        return this.values.integer(this.random.nextInt(limit.intValue()));
    }

    public IValue arbReal() {
        return this.values.real(this.random.nextDouble());
    }

    public void arbSeed(IInteger seed) {
        this.random.setSeed(seed.intValue());
    }

    public IValue fitFloat(IReal r) {
        float x = r.floatValue();
        if (x == Float.NEGATIVE_INFINITY || x == Float.POSITIVE_INFINITY) {
            throw RuntimeExceptionFactory.arithmeticException("<r> is outside of float boundaries", null, null);
        }
        return this.values.real(x);
    }

    public IValue fitDouble(IReal r) {
        double x = r.doubleValue();
        if (x == Double.NEGATIVE_INFINITY || x == Double.POSITIVE_INFINITY) {
            throw RuntimeExceptionFactory.arithmeticException("<r> is outside of float boundaries", null, null);
        }
        return this.values.real(x);
    }

    public IValue cos(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).cos(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue denominator(IRational n) {
        return n.denominator();
    }

    public IValue E() {
        return this.values.e(this.values.getPrecision());
    }

    public IValue exp(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).exp(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue ln(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).ln(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue log(INumber x, INumber base) {
        try {
            return x.toReal(this.values.getPrecision()).log(base.toReal(this.values.getPrecision()), this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue numerator(IRational n) {
        return n.numerator();
    }

    public IValue nroot(INumber x, IInteger y) {
        try {
            return x.toReal(this.values.getPrecision()).nroot(y, this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue PI() {
        return this.values.pi(this.values.getPrecision());
    }

    public IValue pow(INumber x, IInteger y) {
        try {
            return x.toReal(this.values.getPrecision()).pow(y);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue pow(INumber x, IReal y) {
        try {
            return x.toReal(this.values.getPrecision()).pow(y, this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue precision(INumber x) {
        if (x.getType().isInteger()) {
            IInteger k = (IInteger)x;
            return this.values.integer(k.toReal(this.values.getPrecision()).precision());
        }
        if (x.getType().isRational()) {
            IRational k = (IRational)x;
            return this.values.integer(k.toReal(this.values.getPrecision()).precision());
        }
        return this.values.integer(((IReal)x).precision());
    }

    public IValue unscaled(IReal x) {
        return x.unscaled();
    }

    public IValue precision(INumber x, IInteger precision) {
        return this.values.real(x.toString(), precision.intValue());
    }

    public IValue setPrecision(IInteger precision) {
        return this.values.integer(this.values.setPrecision(precision.intValue()));
    }

    public IValue scale(INumber x) {
        try {
            if (x.getType().isInteger()) {
                IInteger k = (IInteger)x;
                return this.values.integer(k.toReal(this.values.getPrecision()).scale());
            }
            if (x.getType().isRational()) {
                IRational k = (IRational)x;
                return this.values.integer(k.toReal(this.values.getPrecision()).scale());
            }
            return this.values.integer(((IReal)x).scale());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue remainder(IRational n) {
        return n.remainder();
    }

    public IValue round(INumber d) {
        return d.toReal(this.values.getPrecision()).round().toInteger();
    }

    public IValue sin(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).sin(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue sqrt(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).sqrt(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue tan(INumber x) {
        try {
            return x.toReal(this.values.getPrecision()).tan(this.values.getPrecision());
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), null, null);
        }
    }

    public IValue toInt(INumber d) {
        return d.toInteger();
    }

    public IValue toRat(IInteger numerator, IInteger denominator) {
        return this.values.rational(numerator, denominator);
    }

    public IValue toReal(INumber n) {
        return n.toReal(this.values.getPrecision());
    }

    public IValue toString(INumber d) {
        return this.values.string(d.toString());
    }

    public IValue toReal(IRational n) {
        return n.toReal(this.values.getPrecision());
    }

    public IValue toInt(IRational n) {
        return n.toInteger();
    }

    public IValue toReal(IInteger n) {
        return this.values.real(n.intValue());
    }
}

